% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCIs.R
\name{bootAnnual}
\alias{bootAnnual}
\title{Single confidence interval bootstrap run}
\usage{
bootAnnual(eList, blockLength = 200, startSeed = 494817,
  verbose = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{blockLength}{integer suggested value is 200}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}

\item{verbose}{logical specifying whether or not to display progress message}
}
\description{
One bootstrap run used to calculate confidence interval bands.
}
\examples{
library(EGRET)
eList <- Choptank_eList
\dontrun{
annualResults <- bootAnnual(eList)
}
}
