% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseMedex.R
\name{parseMedEx}
\alias{parseMedEx}
\title{Parse MedEx NLP Output}
\usage{
parseMedEx(filename)
}
\arguments{
\item{filename}{File name for a single file containing MedEx output.}
}
\value{
A data.table object with columns for filename, drugname, strength, dose, route,
and freq. The filename contains the file name corresponding to the clinical
note. Each of the entity columns are of the format
"extracted expression::start position::stop position".
}
\description{
Takes files with the raw medication extraction output generated by the MedEx
natural language processing system and converts it into a standardized format.
}
\details{
Output from different medication extraction systems is formatted in different ways.
In order to be able to process the extracted information, we first need to convert
the output from different systems into a standardized format. Extracted expressions
for various drug entities (e.g., drug name, strength, frequency, etc.) each receive
their own column formatted as "extracted expression::start position::stop position".
If multiple expressions are extracted for the same entity, they will be separated by
backticks.

MedEx output files anchor extractions to a specific drug name extraction.
}
