% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAplate.R
\name{elisa_plate}
\alias{elisa_plate}
\title{Constructor function to build an elisa_plate object}
\usage{
elisa_plate(batchID = NA_character_, expID = NA_character_,
  desc = NA_character_, data.std = data.frame(),
  mdata.std = data.frame(), data.unknown = data.frame(),
  mdata.unknown = data.frame(), normFactor = NaN, range.ODs = c(-1,
  -1))
}
\arguments{
\item{batchID}{characters to specify the batch}

\item{expID}{characters to specify experiment or plate ID}

\item{desc}{characters for the data/experiment information}

\item{data.std}{data.frame for standard curve data}

\item{mdata.std}{data.frame containing the mean ODs and concentration of the calibration data}

\item{data.unknown}{data.frame for data of samples with unknown concentration
fitted with either four- or five-parameter logistic function.}

\item{mdata.unknown}{data.frame containing the mean ODs and concentration by sample IDs.}

\item{normFactor}{numeric the correction factor for batch effects.}

\item{range.ODs}{numeric the min and max ODs in the plate.}
}
\value{
an elisa_plate object
}
\description{
S3 method as a constructor to build the S4 
class object of the elisa_plate \code{\link{elisa_plate}}
}
\details{
S3 method as a constructor to build the S4 
class object of elisa_plate \code{\link{elisa_plate}}. 
Normally this is called to build an empty object 
with default values and then load data into it
by calling loadData \code{\link{loadData}} or load.ODs 
\code{\link{load.ODs}}
}
\examples{
elisa_plate();
}
\seealso{
\code{\link{nls.lm}} \code{\link{loadData}} \code{\link{elisa_plate}} 
\code{\link{load.ODs}}
}
