% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior}
\alias{prior}
\title{Prior specification}
\usage{
prior(
  design,
  type = "standard",
  update = NULL,
  ask = NULL,
  fill_default = TRUE,
  ...
)
}
\arguments{
\item{design}{Design list for which a prior is constructed, typically the output of \code{design()}}

\item{type}{Character. What type of group-level model you plan on using i.e. \code{diagonal}}

\item{update}{Prior list from which to copy values}

\item{ask}{Character. For which parameter types to ask for prior specification, i.e. \code{Sigma}, \code{mu} or \code{loadings} for factor models}

\item{fill_default}{Boolean, If \code{TRUE} will fill all non-specified parameters, and parameters outside of \code{ask}, to default values}

\item{...}{Either values to prefill, i.e. \code{theta_mu_mean = c(1:6)}, or additional arguments such as \code{n_factors = 2}}
}
\value{
A prior list object
}
\description{
Specify priors for the chosen model. These values are entered manually by default but can be
recycled from another prior (given in the \code{update} argument).
}
\details{
Where a value is not supplied, the user is prompted to enter
numeric values (or functions that evaluate to numbers).

To get the default prior for a type, run: \verb{get_prior_\{type\}(design = design, sample = F)}

E.g.: \code{get_prior_diagonal(design = design, sample = F)}
}
\examples{
# First define a design for the model
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Then set up a prior using prior
p_vector=c(v_Sleft=-2,v_Sright=2,a=log(1),a_Eneutral=log(1.5),a_Eaccuracy=log(2),
                     t0=log(.2),Z=qnorm(.5),sv=log(.5),SZ=qnorm(.5))
psd <- c(v_Sleft=1,v_Sright=1,a=.3,a_Eneutral=.3,a_Eaccuracy=.3,
                     t0=.4,Z=1,sv=.4,SZ=1)
# Here we left the variance prior at default
prior_DDMaE <- prior(design_DDMaE,mu_mean=p_vector,mu_sd=psd)
# Also add a group-level variance prior:
pscale <- c(v_Sleft=.6,v_Sright=.6,a=.3,a_Eneutral=.3,a_Eaccuracy=.3,
                             t0=.2,Z=.5,sv=.4,SZ=.3)
df <- .4
prior_DDMaE <- prior(design_DDMaE,mu_mean=p_vector,mu_sd=psd, A = pscale, df = df)
# If we specify a new design
design_DDMat0E <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~E, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# We can easily update the prior
prior_DDMat0E <- prior(design_DDMat0E, update = prior_DDMaE)
}
