% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emcov.R
\name{startvals.cov}
\alias{startvals.cov}
\title{Starting values for means and covariances}
\usage{
startvals.cov(dat, start = c("diag", "pairwise", "listwise", "full"))
}
\arguments{
\item{dat}{Data frame or matrix that contains the raw data.}

\item{start}{Starting value method (see details).}
}
\value{
A list consisting of:
\itemize{
  \item{\code{mustart} - starting values for means.}
  \item{\code{covstart} - starting values for covariances.}
}
}
\description{
Starting values for means and covariances
}
\details{
Attempts to figure out a starting values for the means and covariances for use
with other functions that do the EM algorithm such as \code{\link{em.prec}} or
\code{\link{em.cov}}. Note that means are determined univariately using all
available cases. For covariances, several options are available:

- "diag" Use all available complete values to compute the variances of each variable and construct a diagonal covariance matrix.
- "pairwise" Pairwise (co)variances will be used to construct the starting covariance matrix.
- "listwise" Listwise deletion will be used and only those with complete data will contribute to the starting covariance matrix.
- "full" Cheat and use \code{lavaan} to obtain direct maximum likelihood estimates of covariances. This defeats the purpose to some extent, but not that \code{lavaan} may be quite slow compared to this implementation.
}
\examples{
\donttest{
  library(psych)
  data(bfi)
  startvals.cov(bfi[,1:25])
}
}
