% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.overlap.R
\name{visualize.overlap}
\alias{visualize.overlap}
\title{visualize.overlap, Makes a contour map of suitability of habitat in environment space for two models}
\usage{
visualize.overlap(
  model.1,
  model.2,
  env,
  nbins = 100,
  layers,
  plot.points = TRUE
)
}
\arguments{
\item{model.1}{An enmtools.model object}

\item{model.2}{An enmtools.model object}

\item{env}{A set of environmental layers}

\item{nbins}{The number of bins per layer to use for drawing environment space}

\item{layers}{A vector of layer names to use for drawing environment space}

\item{plot.points}{Logical determining whether presence points should be plotted on suitability plot}
}
\value{
overlap.plot A two dimensional plot of an ENM
}
\description{
visualize.overlap, Makes a contour map of suitability of habitat in environment space for two models
}
\examples{
\donttest{
data(iberolacerta.clade)
ar <- iberolacerta.clade$species$aranica
au <- iberolacerta.clade$species$aurelioi
data(euro.worldclim)
aranica.dm <- enmtools.dm(ar, euro.worldclim)
aurelioi.dm <- enmtools.dm(au, euro.worldclim)
visualize.overlap(aranica.dm, aurelioi.dm, euro.worldclim, layers = c("bio1", "bio9"))
}
}
\keyword{enm}
\keyword{niche}
\keyword{overlap}
\keyword{plot}
\keyword{sdm}
