% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{ENMdetails-class}
\alias{ENMdetails-class}
\alias{ENMdetails}
\alias{show,ENMdetails-method}
\title{ENMdetails class}
\usage{
\S4method{show}{ENMdetails}(object)
}
\arguments{
\item{object}{ENMdetails object}
}
\description{
An S4 class that details packages, functions, messages associated with a specific species distribution model (SDM) or ecological niche model (ENM). 
Objects of this class are generated by \code{ENMdetails()}. For examples, look in the package's R folder for scripts beginning with "enm" -- these are 
pre-made ENMdetails object specifications that work with ENMeval out of the box.
}
\section{Slots}{

\describe{
\item{\code{name}}{character: name of algorithm}

\item{\code{fun}}{function: function that runs the algorithm}

\item{\code{errors}}{function: returns errors chosen by the user to prevent any malfunction in the analysis.
The available arguments are: occs, envs, bg, tune.args, partitions, algorithm, partition.settings, other.settings, 
categoricals, doClamp, clamp.directions.}

\item{\code{msgs}}{function: prints messages showing the package version number, etc., and those related to the input tuning parameters \code{tune.args}.
The available arguments are: tune.args, other.settings.}

\item{\code{args}}{function: returns the parameters needed to run the algorithm function.
The available arguments are: occs.z, bg.z, tune.tbl.i, other.settings (where x.z is a data.frame of the envs values at
coordinates of x, and tune.tbl.i is a single set of tuning parameters).}

\item{\code{predict}}{function: specifies how to calculate a model prediction for a Raster* or a data frame.
The available arguments are: mod, envs, tune.tbl.i, other.settings.}

\item{\code{ncoefs}}{function: counts the number of non-zero model coefficients.
The available arguments are: mod.}

\item{\code{varimp}}{function: generates a data frame of variable importance from the model object (if functionality is available).
The available arguments are: mod.}
}}

\author{
Jamie M. Kass, \email{jamie.m.kass@gmail.com}
}
