% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_metrics.R
\name{quantile_loss}
\alias{quantile_loss}
\title{Quantile loss}
\usage{
quantile_loss(
  y,
  y_hat,
  q,
  return_agg = c("mean", "sum", "vector"),
  na.rm = FALSE
)
}
\arguments{
\item{y}{Vector of observations.}

\item{y_hat}{Vector of predicted quantiles at probability level \code{q}.}

\item{q}{Probability level of the predicted quantile.}

\item{return_agg}{Whether to return the \code{"mean"} (default), \code{"sum"}, or \code{"vector"} of losses.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}
}
\value{
The mean (or total or vectorial) quantile loss between \code{y} and \code{y_hat} at level \code{q}.
}
\description{
Quantile loss
}
\examples{
quantile_loss(c(2.3, 4.2, 1.8), c(2.9, 5.6, 2.7), q=0.8)
}
