% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setMutationMatrixByRates}
\alias{setMutationMatrixByRates}
\title{Setting the mutation matrix by rates}
\usage{
setMutationMatrixByRates(genomeObj, forwardMut = 0, backwardMut = 0)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}

\item{forwardMut}{the forward mutation rate}

\item{backwardMut}{the backward mutation rate}
}
\value{
a \code{MutationMatrix} object
}
\description{
Generation of the mutation matrix associated with the genome given as input
and specifying the forward and backward mutation rates.
}
\details{
A mutation matrix is used to simulate mutations that affect loci. An object
of the class \code{MutationMatrix} does not only contain a (genotypic)
mutation matrix. It also contains the attributes necessary for the
construction and easy-to-read display of this matrix.

The mutation matrix itself is a square matrix of size equal to the number of
genotypes. It is a probability matrix in that the sum of the values in
each row is equal to 1. For a given genotype, the row associated with it
describes the probabilistic proportions that lead by mutation of this
genotype to the production of the other genotypes (and of itself if there
are no mutations).
}
\examples{
### Example with two loci, each with two alleles ###
# Definition of the diploid locus
LD <- list(dl = as.factor(c("A", "a")))
# Definition of the haploid locus
HL <- list(hl = as.factor(c("B", "b")))
# Definition of the object of Genome class
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = LD)
# The mutation matrices can be defined as follows:
mutMatrixObj <- setMutationMatrixByRates(genomeObj, forwardMut = 1e-3)
mutMatrixObj

# One can also add a backward mutation rate:
mutMatrixObj <- setMutationMatrixByRates(genomeObj,
  forwardMut = 1e-3,
  backwardMut = 1e-4
)
mutMatrixObj

}
\author{
Ehouarn Le Faou
}
