% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{mutation}
\alias{mutation}
\title{Definition of a mutation}
\usage{
mutation(from, to, rate)
}
\arguments{
\item{from}{name of the original allele}

\item{to}{name of the mutant allele}

\item{rate}{rate at which the mutation occurs}
}
\value{
A standardised list of input parameters that will be used by the
function \link[Ease]{setMutationMatrix} to generate the mutation matrix.
}
\description{
Utility function to easily generate a mutation matrix
(see \link[Ease]{setMutationMatrix}).
}
\details{
Mutation occurs from one allele to another at a specific rate. Please
take care to define alleles as traits, that these alleles are present
in the genome you are using and that the alleles are associated with
the same locus.
}
\examples{
### Example with two loci, each with two alleles ###

# Definition of the genome
DL <- list(dl = c("A", "a"))
HL <- list(hl = c("B", "b"))
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = DL)

# The mutation function allows each transition from one allele to
# another to be defined individually, to produce the mutation matrix
# as follows:
mutMatrixObj <- setMutationMatrix(genomeObj,
  mutations = list(
    mutation(from = "A", to = "a", rate = 0.1),
    mutation(from = "B", to = "b", rate = 0.1)
  )
)

}
