% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_model.R
\name{write_model}
\alias{write_model}
\title{Write the EcoDiet model in BUGS}
\usage{
write_model(
  file.name = "EcoDiet_model.txt",
  literature_configuration = FALSE,
  print.model = FALSE
)
}
\arguments{
\item{file.name}{The name and location under which the '.txt' BUGS definition
of the model will be saved. If not provided, the file will be saved in the
current repository under the "EcoDiet_model.txt" name.}

\item{literature_configuration}{A boolean (TRUE or FALSE) indicating whether the model will have
prior distributions informed by a literature study}

\item{print.model}{Indicates whether the user wants to print the written model in the console.}
}
\value{
A string containing the model definition in BUGS
}
\description{
This function writes the EcoDiet model in the BUGS syntax as a several line long string.

The model definition depends on whether or not literature data will be used to inform the priors,
hence the parameter \code{literature_configuration}.

To know more about what is inside the model, please read the reference article.
}
\examples{
\donttest{
write_model(file.name="my_model_with_priors.txt", literature_configuration = TRUE)

write_model(literature_configuration = FALSE, print.model = TRUE)

unlink('my_model_with_priors.txt')
unlink('EcoDiet_model.txt')
}

}
\seealso{
\code{\link{run_model}} to run the model after it has been defined
}
