% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBPS_2014.R
\name{readBPS_2014}
\alias{readBPS_2014}
\title{Beginning Postsecondary Students (BPS:12/14) Data}
\usage{
readBPS_2014(
  path = getwd(),
  csvFilename = "bps14derived_datafile.csv",
  formatFilename = "bps14derived_format.txt",
  metadataFilename = "bps14derived_metadata.txt"
)
}
\arguments{
\item{path}{a character value to the full directory path to the BPS extracted data files}

\item{csvFilename}{a character value of the derived data file (.csv) containing the raw BPS:12/14 data}

\item{formatFilename}{a character value of the format file (.txt) that describes the layout of the \code{csvFilename}}

\item{metadataFilename}{a character value of the metadata file (.txt) that describes additional metadata of the \code{csvFilename}}
}
\value{
An \code{edsurvey.data.frame} for the BPS longitudinal dataset.
}
\description{
Opens a connection to a BPS 2012 to 2014 cohort data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the BPS 2012 to 2014 cohort longitudinal database.
}
\examples{
\dontrun{
# using default filenames
bps14 <- readBPS_2014(path = "~/BPS/2012")
dim(bps14)

# parameters specified without default filenames
bps14 <- readBPS_2014(path = getwd(),
                      csvFilename = "renamedData.csv",
                      formatFilename = "renamedFormat.txt",
                      metadataFilename = "renamedMeta.txt")
dim(bps14)
}
}
\seealso{
\code{\link{readBB_2012}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Sun-joo Lee
}
