% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseScript_SPSS.R
\name{parseScript_SPSS}
\alias{parseScript_SPSS}
\title{Parse SPSS Syntax Script for Fixed-Width Data Files}
\usage{
parseScript_SPSS(
  spsFilePath,
  verbose = FALSE,
  outputFormat = c("data.frame"),
  encoding = getOption("encoding")
)
}
\arguments{
\item{spsFilePath}{a character value of the file path to the SPSS script to parse.}

\item{verbose}{a logic value to indicate if user wishes to print parsing activity to console. Default value is \code{FALSE}.}

\item{outputFormat}{a named argument to indicate which output format the resulting object should be.  See details for information on each format.
Currently, \code{data.frame} format is only supported.}

\item{encoding}{a character value to indicate the encoding specification that is used by \code{readLines} base function for the \code{spsFilePath} parameter.
Only adjust this parameter if the original file encoding of the file is known, is not producing correct string values, or other errors occur.
See \code{?readLines} help for details about it's use for file encoding, and additional details.}
}
\value{
returns an object containing information specified by the \code{outputFormat} argument.
}
\description{
Parses an SPSS Syntax Script (.sps) file to return information relating to fixed-width data files.
}
\details{
NOT CURRENTLY EXPORTED!  In Future this could potentially be made to a separate R package
THIS parseScript_SPSS function should be used 100% moving forward.
Old/Previous SPSS script parsers should be slowly transitioned to utilize this function when possible to maximize code use.

The SPSS syntax script parser is focused on gathering details for use with fixed-width data files.  This function scans for the following SPSS commands:
   \itemize{
            \item{FILE HANDLE}
            \item{DATA LIST}
            \item{VARIABLE LABEL}
            \item{VALUE LABEL}
            \item{MISSING VALUE}
   }

The \code{outputFormat} specified will determine the result object returned.  This function currently supports the following formats.

\itemize{
     \item{data.frame}
          \itemize{
               \item{variableName - The variable name as defined in the script}
               \item{Start - The start number index of the variable defined for the fixed-width format layout}
               \item{End - The end number index of the variable defined for the fixed-width format layout}
               \item{Width - The length of how many columns the variable uses in the fixed-width format layout}
               \item{Attributes - Any SPSS attributes that are defined in the DATA LIST command.  This is typically only for field formatting.}
               \item{RecordNumber - Some fixed-width data files are considered "multi-line" where one record of data can span multiple rows in the file.
               The RecordNumber indicates which line the variable is assigned.}
               \item{Labels - The descriptive label associated with the variable name to give more detail or context.}
               \item{labelValues - For categorical variables a stored value will typically be assigned a longer label/definition. This string identifies these mappings.
               The '^' symbol is used to delimit each individual label value. Then additionally, the '=' is used to split the value from the left side of the '=' symbol,
               and the remaining right-hand side of '=' is the text label for that value.}
               \item{dataType - A best-guess of the data type (either 'numeric' or 'character') without actually examining the data-file.}
               \item{missingValues - If a MISSING VALUE clause is included in the script this will list the values that are considered 'Missing'.
               If multiple values specified, they will be delimited by a ';' (semi-colon) symbol.}
          }
}
}
\author{
Tom Fink
}
