% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary2.R
\name{summary2}
\alias{summary2}
\title{Summarize edsurvey.data.frame Variables}
\usage{
summary2(
  data,
  variable,
  weightVar = attr(getAttributes(data, "weights"), "default"),
  dropOmittedLevels = FALSE,
  omittedLevels = deprecated()
)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame}, an \code{edsurvey.data.frame.list}, or \code{light.edsurvey.data.frame}}

\item{variable}{character vector of variable names}

\item{weightVar}{character weight variable name. Default is the default weight of \code{data} if it exists.
If the given survey data do not have a default weight,
the function will produce unweighted statistics instead.
Can be set to \code{NULL} to return unweighted statistics.}

\item{dropOmittedLevels}{a logical value. When set to \code{TRUE}, drops those levels of the specified \code{variable}.
Use print on an \code{edsurvey.data.frame} to see the omitted levels. Defaults to \code{FALSE}.}

\item{omittedLevels}{this argument is deprecated. Use \code{dropOmittedLevels}}
}
\value{
summary of weighted or unweighted statistics of a given variable in an \code{edsurvey.data.frame}

For categorical variables, the summary results are a crosstab of all variables and include the following:
  \item{[variable name]}{level of the variable in the column name that the row regards. There is one column per element of \code{variable}.}
  \item{N}{number of cases for each category. Weighted N also is produced if users choose to produce weighted statistics.}
  \item{Percent}{percentage of each category. Weighted percent also is produced if users choose to produce weighted statistics.}
  \item{SE}{standard error of the percentage statistics}

For continuous variables, the summary results are by variable and include the following:
  \item{Variable}{name of the variable the row regards}
  \item{N}{total number of cases (both valid and invalid cases)}
  \item{Min.}{smallest value of the variable}
  \item{1st Qu.}{first quantile of the variable}
  \item{Median}{median value of the variable}
  \item{Mean}{mean of the variable}
  \item{3rd Qu.}{third quantile of the variable}
  \item{Max.}{largest value of the variable}
  \item{SD}{standard deviation or weighted standard deviation}
  \item{NA's}{number of \code{NA} in variable and in weight variables}
  \item{Zero weights}{number of zero weight cases if users choose to produce weighted statistics}

If the weight option is chosen, the function produces weighted percentile and standard deviation. Refer to the vignette titled
\emph{\href{https://www.air.org/sites/default/files/EdSurvey-Statistics.pdf}{Statistical Methods Used in EdSurvey}} and
the vignette titled
\emph{\href{https://www.air.org/sites/default/files/EdSurvey-Percentiles.pdf}{Methods Used for Estimating Percentiles in EdSurvey}}
for how the function calculates these statistics (with and without plausible values).
}
\description{
Summarizes \code{edsurvey.data.frame} variables.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(path=system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# print out summary of weighted statistics of a continuous variable
summary2(data=sdf, variable="composite")
# print out summary of weighted statistics of a variable, including omitted levels
summary2(data=sdf, variable="b017451", omittedLevels = FALSE)
# make a crosstab
summary2(data=sdf, variable=c("b017451", "dsex"), omittedLevels = FALSE)

# print out summary of unweighted statistics of a variable
summary2(data=sdf, variable="composite", weightVar = NULL)
}
}
\seealso{
\code{\link{percentile}}
}
\author{
Paul Bailey and Trang Nguyen
}
