% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elr_aggregated_effects.R
\name{autoSelectSubset}
\alias{autoSelectSubset}
\title{Autoselect Subset for Aggregated Effects}
\usage{
autoSelectSubset(obj, newdata, nsub = 10)
}
\arguments{
\item{obj}{Object of class \code{effectlite}.}

\item{newdata}{A data.frame with a single row, containing the same continuous and 
categorical covariates (and potentially the treatment variable) as used when fitting the
EffectLiteR model in obj.}

\item{nsub}{Integer. How many data points should be used for matching
the continous covariates. Will be ignored if no values for continuous covariates
are specified.}
}
\value{
Vector of integers indicating the rows to use for computing the aggregated
effects. Can directly be used in \code{\link[EffectLiteR]{computeAggregatedEffects}}
}
\description{
Automatically selects a subset of the original dataset for computing specific
aggregated effects. The subset is selected such that it is as close as possible
to the user supplied newdata frame. The function uses exact matching for 
categorical covariates (and the treatment if specified) and matching based 
on the Mahalanobis distance for continuous covariates.
}
\examples{
m1 <- effectLite(y="dv", z=c("z1"), k=c("k1"), x="x", 
control="control", data=example01, fixed.cell=TRUE, fixed.z=TRUE)
newdata <- data.frame(k1=NA, z1=1)
agg.subset <- autoSelectSubset(m1, newdata)
}
