% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelo.R
\name{likelo}
\alias{likelo}
\title{(log) likelihood of Elo-rating model}
\usage{
likelo(eloobject, daterange = NULL, burnin = NULL, ll = TRUE)
}
\arguments{
\item{eloobject}{output from \code{\link{elo.seq}}}

\item{daterange}{character or Date of length 2, gives the date range for which likelihood should be calculated. By default, the entire date range is considered.}

\item{burnin}{not yet implemented}

\item{ll}{logical, should the log likelihood be returned rather than the likelihood, by default \code{TRUE}}
}
\value{
numeric of length 1, the log likelihood
}
\description{
(log) likelihood of Elo-rating model
}
\details{
This function returns the (log) likelihood of a dominance interaction sequence. The likelihood is the product of all winning probabilities (for each interaction).
}
\examples{
data(adv)
res <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date, k = 200)
likelo(res)
res <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date, k = 100)
likelo(res)
ks <- seq(100, 400, by = 20)
liks <- numeric(length(ks))
for(i in 1:length(liks)) {
  liks[i] <- likelo(elo.seq(winner = adv$winner, loser = adv$loser,
                    Date = adv$Date, k = ks[i]))
}
plot(ks, liks, type = "l")
}
\references{
\insertRef{franz2015a}{EloRating}

\insertRef{mcmahan1984}{EloRating}
}
