% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat2seq.R
\name{mat2seq}
\alias{mat2seq}
\alias{mat2seqint}
\title{matrix to sequence conversion}
\usage{
mat2seq(mat)
}
\arguments{
\item{mat}{square interaction matrix with winner in rows and losers in columns (can have column/row names or not)}
}
\value{
a data.frame with a winner and a loser column
}
\description{
matrix to sequence conversion
}
\examples{
mat <- matrix(c(0,1,1,0,0,1,0,0,0), ncol=3, byrow = TRUE)
rownames(mat) <- colnames(mat) <- LETTERS[1:3]
mat2seq(mat)

mat <- matrix(c(0,1,1,0,0,1,3,0,0), ncol=3, byrow = TRUE)
rownames(mat) <- colnames(mat) <- LETTERS[1:3]
mat2seq(mat)

# without column names
mat <- matrix(c(0,1,1,0,0,1,0,0,0), ncol=3, byrow = TRUE)
mat2seq(mat)

}
