% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_steep_gen.R
\name{simple_steep_gen}
\alias{simple_steep_gen}
\title{generate dominance interactions with specified steepness}
\usage{
simple_steep_gen(
  n_ind,
  n_int,
  steep,
  id_bias = 0,
  rank_bias = 0,
  sequential = TRUE
)
}
\arguments{
\item{n_ind}{integer, the number of individuals}

\item{n_int}{integer, the number of interactions}

\item{steep}{numeric (between 0 and 1), the desired steepness value}

\item{id_bias}{numeric, between 0 and 1. If 0 all individual are equally
likely to interact. If 1, some individuals have higher propensities
to interact.}

\item{rank_bias}{numeric, between 0 and 1. If 0 there is no relationship
between rank distance and interaction propensity. If 1 there is a
strong relationship: dyads closer in rank interact more often.}

\item{sequential}{logical, default is \code{TRUE}. See details.}
}
\value{
a list with the first item being the interactions in sequence form
(\code{$sequence}). The second item (\code{$matrix}) is the
square interaction matrix and the third item (\code{$settings})
is a list with input settings (including probabilities to interact
for each dyad).
}
\description{
generate dominance interactions with specified steepness
}
\details{
Initially (and this is still the default), the function generated
interactions and their outcomes sequentially: first a dyad
was chosen that interacted and then its winner was determined.
This was repeated for as many interactions as set by \code{n_int=}.

The same results can be achieved much
more efficiently by first setting the number of interactions per
dyad and then looping through all dyads and then generate the
interactions and their outcomes per dyad. This can be achieved by
setting \code{sequential = FALSE}. In this latter case the
'sequence' of interactions reported in the results is just a
randomized version of all interactions, whereas in the former case
there is a 'natural sequence' (although it is meaningless because
the sequence is irrelevant with respect to outcomes of individual
interactions (the system is stable)).
}
\examples{
res <- simple_steep_gen(n_ind = 5, n_int = 30, steep = 0.99)
res$sequence
res$matrix


library(EloRating)
steeps <- runif(20, 0, 1)
nids <- sample(6:10, length(steeps), TRUE)
mats <- sapply(1:length(steeps), function(x) {
  simple_steep_gen(nids[x], nids[x] ^ 2.5, steeps[x], 0)[[2]]
 })
obs_steeps <- unlist(lapply(mats, function(x)steepness(x)[1]))
plot(steeps, obs_steeps, xlim = c(0, 1), ylim = c(0, 1))
abline(0, 1)
}
