% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{EmbedSOM}
\alias{EmbedSOM}
\title{Process the cells with SOM into a nice embedding}
\usage{
EmbedSOM(fsom = NULL, smooth = NULL, k = NULL, adjust = NULL,
  data = NULL, map = NULL, importance = NULL, emcoords = "flat",
  emcoords.pow = 1)
}
\arguments{
\item{fsom}{FlowSOM object with a built SOM (used if data or map are missing)}

\item{smooth}{Produce smoother (positive values) or more rough approximation (negative values).}

\item{k}{How many SOM neighbors to take into the whole computation}

\item{adjust}{How much non-local information to remove (parameter a)}

\item{data}{Data matrix with points that optionally overrides the one from `fsom$data`}

\item{map}{Map object in FlowSOM format, to optionally override `fsom$map`}

\item{importance}{Importance of dimensions that was used to train the SOM}

\item{emcoords}{Either a matrix of embedded coordinates (same number of rows as map$coords, and either 2 or 3 columns depending on the SOM grid dimension), or one of 'flat' (default behavior), 'som' (adjust the SOM coords according to U-matrix distances), 'mst' (embed to MST-like structure), 'fsom-mst' (embed to MST that should look exactly like that of FlowSOM), 'tsne' (embed using tSNE from package Rtsne), 'umap' (embed using UMAP from package umap) or 'uwot::umap' (embed using UMAP from package uwot)}

\item{emcoords.pow}{Exaggeration factor (power) of the distances in U-matrix used for some methods of auto-generating emcoords; default 1.}
}
\value{
matrix with 2D or 3D coordinates of the embedded cels, depending on the map
}
\description{
Process the cells with SOM into a nice embedding
}
\examples{
d <- cbind(rnorm(10000), 3*runif(10000), rexp(10000))
colnames(d) <- paste0("col",1:3)
map <- EmbedSOM::SOM(d, xdim=10, ydim=10)
e <- EmbedSOM::EmbedSOM(data=d, map=map)
EmbedSOM::PlotEmbed(e, data=d, 'col1', pch=16)
}
