% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNC__Ackley.R
\name{ackley_func}
\alias{ackley_func}
\title{Ackley Function}
\usage{
ackley_func(x)
}
\arguments{
\item{x}{numeric or complex vector.}
}
\value{
The value of the function.
}
\description{
\loadmathjax
Implementation of n-dimensional Ackley function, with \mjeqn{a=20}{a=20},
\mjeqn{b=0.2}{b=0.2} and \mjeqn{c=2\pi}{c=2\pi} (see definition below).
}
\details{
On an n-dimensional domain it is defined by

\mjdeqn{f(\vec{x}) = -a\exp\left(-b \sqrt{\frac{1}{n}\sum_{i=1}^n x_{i}^2} \right) -\exp\left(\frac{1}{n}\sum_{i=1}^n \cos(cx_{i}) \right) + a + \exp(1),}{-a\emph{exp(-b}sqrt(1/n\emph{sum_1^n (x_{i}^2)) -exp(1/n}sum_1^n (\cos(c*x_i)) + a + exp(1),}
and is usually evaluated on
\mjeqn{x_{i} \in [ -32.768, 32.768 ]}{x_{i} in [-32.768, 32.768]}, for all
\mjeqn{i=1,...,n}{i=1,...,n}. The function has one global minimum at
\mjeqn{f(\vec{x})=0}{f(x)=0} for \mjeqn{x_{i}=0}{x_i=0} for all \mjeqn{i=1,...,n}{i=1,...,n}.
}
\references{
\insertRef{Ackley1987}{EmiR}
}
