% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__SA.R
\name{config_sa}
\alias{config_sa}
\title{Configuration object for the Simulated Annealing Algorithm}
\usage{
config_sa(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  T0 = 50,
  Ns = 3,
  Nt = 3,
  c_step = 2,
  Rt = 0.85,
  Wmin = 0.25,
  Wmax = 1.25
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of particles.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{T0}{initial temperature. Default is \code{50}.}

\item{Ns}{number of iterations before changing velocity. Default is \code{3}.}

\item{Nt}{number of iterations before changing the temperature. Default is \code{3}.}

\item{c_step}{parameter involved in the velocity update. Default is \code{2}.}

\item{Rt}{scaling factor for the temperature. Default is \code{0.85}.}

\item{Wmin}{parameter involved in the generation of the starting point. Default is \code{0.25}.}

\item{Wmax}{parameter involved in the generation of the starting point. Default is \code{1.25}.}
}
\value{
\code{config_sa} returns an object of class \code{SAConfig}.
}
\description{
Create a configuration object for the Simulated Annealing algorithm (SA). At minimum the number of iterations
(parameter \code{iterations}) and the number of particles (parameter \code{population_size}) have
to be provided.
}
\references{
\insertRef{Kirkpatrick1983}{EmiR}
}
