% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNC__Rastrigin.R
\name{rastrigin_func}
\alias{rastrigin_func}
\title{Rastrigin Function}
\usage{
rastrigin_func(x)
}
\arguments{
\item{x}{numeric or complex vector.}
}
\value{
The value of the function.
}
\description{
Implementation of n-dimensional Rastrigin function.
}
\details{
\loadmathjax
On an n-dimensional domain it is defined by:

\mjdeqn{f(\vec{x}) = 20n + \sum_{i=1}^n \left( x_{i}^2 - 20\cos(2\pi x_{i}) \right),}{20n + sum_{i=0}^n \link[=x_{i}^2 - 20cos(2*pi*x_{i})]{x_{i}^2 - 20cos(2\emph{pi}x_{i})},}
and is usually evaluated on
\mjeqn{x_{i} \in [ -5.12, 5.12 ]}{x_{i} in [-5.12, 5.12]}, for all
\mjeqn{i=1,...,n}{i=1,...,n}. The function has one global minimum at
\mjeqn{f(\vec{x})=0}{f(x)=0} for \mjeqn{x_{i}=0}{x_i=0} for all \mjeqn{i=1,...,n}{i=1,...,n}.
}
\references{
\insertRef{rastrigin1974systems}{EmiR}
}
