% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vehicles.R
\name{vehicles}
\alias{vehicles}
\title{Tool to set-up vehicle data table}
\usage{
vehicles(total_v, area_name = names(total_v), distribution, type,
  category = NA, fuel = NA, vnames = NA, example = F,
  verbose = T)
}
\arguments{
\item{total_v}{total of vehicles by area (area length)}

\item{area_name}{area names (area length)}

\item{distribution}{distribution of vehicles by vehicle class}

\item{type}{type of vehicle by vehicle class (distribution length)}

\item{category}{category name (distribution length / NA)}

\item{fuel}{fuel type by vehicle class (distribution length / NA)}

\item{vnames}{name of each vehicle class (distribution length / NA)}

\item{example}{a simple example}

\item{verbose}{display additional information}
}
\description{
Return a data frame with 4 columns (vehicle category, type, fuel and avarage kilometers driven) and an aditional column with the number of vehicles for each interest area (cityes, states, countries, etc).

Average daily kilometres driven are defined by vehicle type:

- LDV (Light duty Vehicles) 41 km / day

- TRUCKS (Trucks) 110 km / day

- BUS (Busses) 165 km / day

- MOTO (motorcycles and other vehicles) 140 km / day

The number of vehicles are defined by the distribution of vehicles by vehicle classs and the total number of vehicles by area.
}
\note{
total_v and area_name must have the same length.

distribution, type, category (if used), fuel (if used) and vnames (if used) must have the same length.
}
\examples{
fleet <- vehicles(example = TRUE)

# or the code bellow for the same result
# DETRAN 2016 data for total number of vehicles for 5 Brazilian states (Sao Paulo,
# Rio de Janeiro, Minas Gerais, Parana and Santa Catarina)
# vahicle distribution of Sao Paulo

fleet <- vehicles(total_v = c(27332101, 6377484, 10277988, 7140439, 4772160),
                  area_name = c("SP", "RJ", "MG", "PR", "SC"),
                  distribution = c( 0.4253, 0.0320, 0.3602, 0.0260,
                                   0.0290, 0.0008, 0.1181, 0.0086),
                  category =  c("LDV_E25","LDV_E100","LDV_F","TRUCKS_B5",
                                "CBUS_B5","MBUS_B5","MOTO_E25","MOTO_F"),
                  type = c("LDV", "LDV", "LDV","TRUCKS",
                          "BUS","BUS","MOTO", "MOTO"),
                  fuel = c("E25", "E100", "FLEX","B5",
                           "B5","B5","E25", "FLEX"),
                  vnames = c("Light duty Vehicles Gasohol","Light Duty Vehicles Ethanol",
                             "Light Duty Vehicles Flex","Diesel trucks","Diesel urban busses",
                             "Diesel intercity busses","Gasohol motorcycles",
                             "Flex motorcycles"))
}
\seealso{
\code{\link{areaSource}} and  \code{\link{totalEmission}}
}
