% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{simulateControls}
\alias{simulateControls}
\title{Simulate (negative) controls}
\usage{
simulateControls(n = 50, mean = 0, sd = 0.1, seLogRr = runif(n, min
  = 0.01, max = 0.2), trueLogRr = 0)
}
\arguments{
\item{n}{Number of controls to simulate.}

\item{mean}{The mean of the error distribution (on the log RR scale).}

\item{sd}{The standard deviation of the error distribution (on the log RR scale).}

\item{seLogRr}{The standard error of the log of the relative risk. This is recycled for the
controls. The default is to sample these from a uniform distribution.}

\item{trueLogRr}{The true relative risk (on the log scale) used to generate these controls.  This
is recycled for the controls.}
}
\description{
Simulate (negative) controls
}
\details{
Generate point estimates given known true effect sizes and standard errors
}
\examples{
data <- simulateControls(n = 50 * 3, mean = 0.25, sd = 0.25, trueLogRr = log(c(1, 2, 4)))
plotTrueAndObserved(data$logRr, data$seLogRr, data$trueLogRr)

}
