% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalCalibrationUsingAsymptotics.R,
%   R/EmpiricalCalibrationUsingMcmc.R
\name{calibrateP}
\alias{calibrateP}
\alias{calibrateP.null}
\alias{calibrateP.mcmcNull}
\title{Calibrate the p-value}
\usage{
calibrateP(null, logRr, seLogRr, ...)

\method{calibrateP}{null}(null, logRr, seLogRr, ...)

\method{calibrateP}{mcmcNull}(null, logRr, seLogRr, pValueOnly, ...)
}
\arguments{
\item{null}{An object of class \code{null} created using the \code{fitNull} function or an
object of class \code{mcmcNull} created using the \code{fitMcmcNull} function.}

\item{logRr}{A numeric vector of one or more effect estimates on the log scale}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025)}

\item{...}{Any additional parameters (currently none).}

\item{pValueOnly}{If true, will return only the calibrated P-value itself, not the credible
interval.}
}
\value{
The two-sided calibrated p-value.
}
\description{
\code{calibrateP} computes calibrated p-values using the fitted null distribution
}
\details{
This function computes a calibrated two-sided p-value as described in Schuemie et al (2014).
}
\section{Methods (by class)}{
\itemize{
\item \code{null}: Computes the calibrated P-value using asymptotic assumptions.

\item \code{mcmcNull}: Computes the calibrated P-value and 95 percent credible interval using Markov Chain
Monte Carlo (MCMC).
}}

\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
null <- fitNull(negatives$logRr, negatives$seLogRr)
positive <- sccs[sccs$groundTruth == 1, ]
calibrateP(null, positive$logRr, positive$seLogRr)

}
\references{
Schuemie MJ, Ryan PB, Dumouchel W, Suchard MA, Madigan D. Interpreting observational studies: why
empirical calibration is needed to correct p-values. Statistics in Medicine 33(2):209-18,2014
}
