% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{match_output_arguments}
\alias{match_output_arguments}
\title{Match Input Output Arguments with Supported Options}
\usage{
match_output_arguments(
  input_args = c(),
  supported_args = c(),
  logger = NULL,
  level = "info"
)
}
\arguments{
\item{input_args}{A character vector of input arguments (can be partial).}

\item{supported_args}{A character vector of supported output arguments.}

\item{logger}{A character vector indicating the logger to target messages at. Defaults
to no logging.}

\item{level}{Character string defaulting to "info". Logging level see documentation
of futile.logger for details. Supported options are "info" and "debug"}
}
\value{
A logical vector of named output arguments
}
\description{
Match Input Output Arguments with Supported Options
}
\examples{
# select nothing
match_output_arguments(supported_args = c("fit", "plots", "samples"))

# select just plots
match_output_arguments("plots", supported_args = c("fit", "plots", "samples"))

# select plots and samples
match_output_arguments(c("plots", "samples"),
                       supported_args = c("fit", "plots", "samples"))

# lazily select arguments
match_output_arguments("p",
                       supported_args = c("fit", "plots", "samples"))
}
