// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_simulate_secondary_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_simulate_secondary");
    reader.add_event(1, 1, "include", "functions/convolve.stan");
    reader.add_event(1, 0, "start", "functions/convolve.stan");
    reader.add_event(48, 47, "end", "functions/convolve.stan");
    reader.add_event(48, 2, "restart", "model_simulate_secondary");
    reader.add_event(48, 2, "include", "functions/pmfs.stan");
    reader.add_event(48, 0, "start", "functions/pmfs.stan");
    reader.add_event(142, 94, "end", "functions/pmfs.stan");
    reader.add_event(142, 3, "restart", "model_simulate_secondary");
    reader.add_event(142, 3, "include", "functions/observation_model.stan");
    reader.add_event(142, 0, "start", "functions/observation_model.stan");
    reader.add_event(263, 121, "end", "functions/observation_model.stan");
    reader.add_event(263, 4, "restart", "model_simulate_secondary");
    reader.add_event(263, 4, "include", "functions/secondary.stan");
    reader.add_event(263, 0, "start", "functions/secondary.stan");
    reader.add_event(316, 53, "end", "functions/secondary.stan");
    reader.add_event(316, 5, "restart", "model_simulate_secondary");
    reader.add_event(327, 16, "include", "data/secondary.stan");
    reader.add_event(327, 0, "start", "data/secondary.stan");
    reader.add_event(333, 6, "end", "data/secondary.stan");
    reader.add_event(333, 17, "restart", "model_simulate_secondary");
    reader.add_event(334, 18, "include", "data/simulation_delays.stan");
    reader.add_event(334, 0, "start", "data/simulation_delays.stan");
    reader.add_event(339, 5, "end", "data/simulation_delays.stan");
    reader.add_event(339, 19, "restart", "model_simulate_secondary");
    reader.add_event(340, 20, "include", "data/simulation_observation_model.stan");
    reader.add_event(340, 0, "start", "data/simulation_observation_model.stan");
    reader.add_event(347, 7, "end", "data/simulation_observation_model.stan");
    reader.add_event(347, 21, "restart", "model_simulate_secondary");
    reader.add_event(382, 54, "end", "model_simulate_secondary");
    return reader;
}
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& len, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        int xlen(0);
        (void) xlen;  // dummy to suppress unused var warning
        stan::math::fill(xlen, std::numeric_limits<int>::min());
        stan::math::assign(xlen,num_elements(x));
        current_statement_begin__ = 7;
        int ylen(0);
        (void) ylen;  // dummy to suppress unused var warning
        stan::math::fill(ylen, std::numeric_limits<int>::min());
        stan::math::assign(ylen,num_elements(y));
        current_statement_begin__ = 8;
        validate_non_negative_index("convolution", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> convolution(len);
        stan::math::initialize(convolution, DUMMY_VAR__);
        stan::math::fill(convolution, DUMMY_VAR__);
        stan::math::assign(convolution,rep_vector(0, len));
        current_statement_begin__ = 9;
        for (int i = 1; i <= xlen; ++i) {
            current_statement_begin__ = 10;
            for (int j = 1; j <= std::min(((len - i) + 1), ylen); ++j) {
                current_statement_begin__ = 11;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_uni(((i + j) - 1)), stan::model::nil_index_list()), 
                            (stan::model::rvalue(convolution, stan::model::cons_list(stan::model::index_uni(((i + j) - 1)), stan::model::nil_index_list()), "convolution") + (get_base1(x, i, "x", 1) * get_base1(y, j, "y", 1))), 
                            "assigning variable convolution");
            }
        }
        current_statement_begin__ = 14;
        return stan::math::promote_scalar<fun_return_scalar_t__>(convolution);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& len, std::ostream* pstream__) const {
        return convolve(x, y, len, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_dot_product(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                         const int& len, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 22;
        int ylen(0);
        (void) ylen;  // dummy to suppress unused var warning
        stan::math::fill(ylen, std::numeric_limits<int>::min());
        stan::math::assign(ylen,num_elements(y));
        current_statement_begin__ = 23;
        validate_non_negative_index("z", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z(len);
        stan::math::initialize(z, DUMMY_VAR__);
        stan::math::fill(z, DUMMY_VAR__);
        current_statement_begin__ = 24;
        for (int s = 1; s <= len; ++s) {
            current_statement_begin__ = 25;
            stan::model::assign(z, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        dot_product(stan::model::rvalue(x, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - ylen) + 1)), s), stan::model::nil_index_list()), "x"), tail(y, std::min(ylen, s))), 
                        "assigning variable z");
        }
        current_statement_begin__ = 29;
        return stan::math::promote_scalar<fun_return_scalar_t__>(z);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_dot_product_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                         const int& len, std::ostream* pstream__) const {
        return convolve_dot_product(x, y, len, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_to_report(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& delay_rev_pmf,
                       const int& seeding_time, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(infections));
        current_statement_begin__ = 38;
        validate_non_negative_index("reports", "(t - seeding_time)", (t - seeding_time));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports((t - seeding_time));
        stan::math::initialize(reports, DUMMY_VAR__);
        stan::math::fill(reports, DUMMY_VAR__);
        current_statement_begin__ = 39;
        validate_non_negative_index("unobs_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> unobs_reports(t);
        stan::math::initialize(unobs_reports, DUMMY_VAR__);
        stan::math::fill(unobs_reports, DUMMY_VAR__);
        stan::math::assign(unobs_reports,infections);
        current_statement_begin__ = 40;
        int delays(0);
        (void) delays;  // dummy to suppress unused var warning
        stan::math::fill(delays, std::numeric_limits<int>::min());
        stan::math::assign(delays,num_elements(delay_rev_pmf));
        current_statement_begin__ = 41;
        if (as_bool(delays)) {
            current_statement_begin__ = 42;
            stan::math::assign(unobs_reports, convolve_dot_product(unobs_reports, delay_rev_pmf, t, pstream__));
            current_statement_begin__ = 43;
            stan::math::assign(reports, stan::model::rvalue(unobs_reports, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "unobs_reports"));
        } else {
            current_statement_begin__ = 45;
            stan::math::assign(reports, stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "infections"));
        }
        current_statement_begin__ = 47;
        return stan::math::promote_scalar<fun_return_scalar_t__>(reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_to_report_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& delay_rev_pmf,
                       const int& seeding_time, std::ostream* pstream__) const {
        return convolve_to_report(infections, delay_rev_pmf, seeding_time, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
discretised_pmf(const T0__& mu,
                    const T1__& sigma,
                    const int& n,
                    const int& dist,
                    const int& left_truncate, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 58;
        if (as_bool(logical_gt(sigma, 0))) {
            {
            current_statement_begin__ = 59;
            validate_non_negative_index("upper_cdf", "(n + 1)", (n + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> upper_cdf((n + 1));
            stan::math::initialize(upper_cdf, DUMMY_VAR__);
            stan::math::fill(upper_cdf, DUMMY_VAR__);
            current_statement_begin__ = 60;
            if (as_bool(logical_eq(dist, 0))) {
                current_statement_begin__ = 61;
                for (int i = 1; i <= (n + 1); ++i) {
                    current_statement_begin__ = 62;
                    stan::model::assign(upper_cdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                lognormal_cdf(((i - 1) + left_truncate), mu, sigma), 
                                "assigning variable upper_cdf");
                }
            } else if (as_bool(logical_eq(dist, 1))) {
                {
                current_statement_begin__ = 65;
                local_scalar_t__ alpha(DUMMY_VAR__);
                (void) alpha;  // dummy to suppress unused var warning
                stan::math::initialize(alpha, DUMMY_VAR__);
                stan::math::fill(alpha, DUMMY_VAR__);
                stan::math::assign(alpha,(pow(mu, 2) / pow(sigma, 2)));
                current_statement_begin__ = 66;
                local_scalar_t__ beta(DUMMY_VAR__);
                (void) beta;  // dummy to suppress unused var warning
                stan::math::initialize(beta, DUMMY_VAR__);
                stan::math::fill(beta, DUMMY_VAR__);
                stan::math::assign(beta,(mu / pow(sigma, 2)));
                current_statement_begin__ = 67;
                for (int i = 1; i <= (n + 1); ++i) {
                    current_statement_begin__ = 68;
                    stan::model::assign(upper_cdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                gamma_cdf(((i - 1) + left_truncate), alpha, beta), 
                                "assigning variable upper_cdf");
                }
                }
            } else {
                current_statement_begin__ = 71;
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Unknown distribution function provided.";
                throw std::domain_error(errmsg_stream__.str());
            }
            current_statement_begin__ = 74;
            stan::math::assign(pmf, subtract(stan::model::rvalue(upper_cdf, stan::model::cons_list(stan::model::index_min_max(2, (n + 1)), stan::model::nil_index_list()), "upper_cdf"), stan::model::rvalue(upper_cdf, stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list()), "upper_cdf")));
            current_statement_begin__ = 76;
            stan::math::assign(pmf, divide(pmf, (get_base1(upper_cdf, (n + 1), "upper_cdf", 1) - get_base1(upper_cdf, 1, "upper_cdf", 1))));
            }
        } else {
            current_statement_begin__ = 79;
            stan::math::assign(pmf, rep_vector(0, n));
            current_statement_begin__ = 80;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 82;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_pmf_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& mu,
                    const T1__& sigma,
                    const int& n,
                    const int& dist,
                    const int& left_truncate, std::ostream* pstream__) const {
        return discretised_pmf(mu, sigma, n, dist, left_truncate, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse_mf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 87;
        int max_pmf(0);
        (void) max_pmf;  // dummy to suppress unused var warning
        stan::math::fill(max_pmf, std::numeric_limits<int>::min());
        stan::math::assign(max_pmf,num_elements(pmf));
        current_statement_begin__ = 88;
        validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_pmf(max_pmf);
        stan::math::initialize(rev_pmf, DUMMY_VAR__);
        stan::math::fill(rev_pmf, DUMMY_VAR__);
        current_statement_begin__ = 89;
        for (int d = 1; d <= max_pmf; ++d) {
            current_statement_begin__ = 90;
            stan::model::assign(rev_pmf, 
                        stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                        get_base1(pmf, ((max_pmf - d) + 1), "pmf", 1), 
                        "assigning variable rev_pmf");
        }
        current_statement_begin__ = 92;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev_pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse_mf_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf, std::ostream* pstream__) const {
        return reverse_mf(pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
combine_pmfs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& fixed_pmf,
                 const std::vector<T1__>& pmf_mu,
                 const std::vector<T2__>& pmf_sigma,
                 const std::vector<int>& pmf_n,
                 const std::vector<int>& dist,
                 const int& len,
                 const int& left_truncate,
                 const int& reverse_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 97;
        int n_fixed(0);
        (void) n_fixed;  // dummy to suppress unused var warning
        stan::math::fill(n_fixed, std::numeric_limits<int>::min());
        stan::math::assign(n_fixed,num_elements(fixed_pmf));
        current_statement_begin__ = 98;
        int n_variable(0);
        (void) n_variable;  // dummy to suppress unused var warning
        stan::math::fill(n_variable, std::numeric_limits<int>::min());
        stan::math::assign(n_variable,num_elements(pmf_mu));
        current_statement_begin__ = 99;
        validate_non_negative_index("pmf", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(len);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        stan::math::assign(pmf,rep_vector(0, len));
        current_statement_begin__ = 100;
        if (as_bool(logical_gt(n_fixed, 0))) {
            current_statement_begin__ = 101;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_min_max(1, n_fixed), stan::model::nil_index_list()), 
                        fixed_pmf, 
                        "assigning variable pmf");
        } else if (as_bool(logical_gt(n_variable, 0))) {
            current_statement_begin__ = 103;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 105;
        for (int s = 1; s <= n_variable; ++s) {
            {
            current_statement_begin__ = 106;
            validate_non_negative_index("variable_pmf", "get_base1(pmf_n, s, \"pmf_n\", 1)", get_base1(pmf_n, s, "pmf_n", 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> variable_pmf(get_base1(pmf_n, s, "pmf_n", 1));
            stan::math::initialize(variable_pmf, DUMMY_VAR__);
            stan::math::fill(variable_pmf, DUMMY_VAR__);
            current_statement_begin__ = 107;
            stan::math::assign(variable_pmf, discretised_pmf(get_base1(pmf_mu, s, "pmf_mu", 1), get_base1(pmf_sigma, s, "pmf_sigma", 1), get_base1(pmf_n, s, "pmf_n", 1), get_base1(dist, s, "dist", 1), left_truncate, pstream__));
            current_statement_begin__ = 108;
            stan::math::assign(pmf, convolve(pmf, variable_pmf, len, pstream__));
            }
        }
        current_statement_begin__ = 110;
        if (as_bool(reverse_pmf)) {
            current_statement_begin__ = 111;
            stan::math::assign(pmf, reverse_mf(pmf, pstream__));
        }
        current_statement_begin__ = 113;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct combine_pmfs_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& fixed_pmf,
                 const std::vector<T1__>& pmf_mu,
                 const std::vector<T2__>& pmf_sigma,
                 const std::vector<int>& pmf_n,
                 const std::vector<int>& dist,
                 const int& len,
                 const int& left_truncate,
                 const int& reverse_pmf, std::ostream* pstream__) const {
        return combine_pmfs(fixed_pmf, pmf_mu, pmf_sigma, pmf_n, dist, len, left_truncate, reverse_pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
delays_lp(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const std::vector<int>& delay_dist,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 119;
        int mean_delays(0);
        (void) mean_delays;  // dummy to suppress unused var warning
        stan::math::fill(mean_delays, std::numeric_limits<int>::min());
        stan::math::assign(mean_delays,num_elements(delay_mean));
        current_statement_begin__ = 120;
        int sd_delays(0);
        (void) sd_delays;  // dummy to suppress unused var warning
        stan::math::fill(sd_delays, std::numeric_limits<int>::min());
        stan::math::assign(sd_delays,num_elements(delay_sd));
        current_statement_begin__ = 121;
        if (as_bool(mean_delays)) {
            current_statement_begin__ = 122;
            for (int s = 1; s <= mean_delays; ++s) {
                current_statement_begin__ = 123;
                if (as_bool(logical_gt(get_base1(delay_mean_sd, s, "delay_mean_sd", 1), 0))) {
                    current_statement_begin__ = 125;
                    lp_accum__.add((normal_log(get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1)) * weight));
                    current_statement_begin__ = 127;
                    if (as_bool(get_base1(delay_dist, s, "delay_dist", 1))) {
                        current_statement_begin__ = 128;
                        lp_accum__.add((-(normal_ccdf_log(0, get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1))) * weight));
                    }
                }
            }
        }
        current_statement_begin__ = 133;
        if (as_bool(sd_delays)) {
            current_statement_begin__ = 134;
            for (int s = 1; s <= sd_delays; ++s) {
                current_statement_begin__ = 135;
                if (as_bool(logical_gt(get_base1(delay_sd_sd, s, "delay_sd_sd", 1), 0))) {
                    current_statement_begin__ = 137;
                    lp_accum__.add((normal_log(get_base1(delay_sd, s, "delay_sd", 1), get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1)) * weight));
                    current_statement_begin__ = 138;
                    lp_accum__.add((-(normal_ccdf_log(0, get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1))) * weight));
                }
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct delays_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const std::vector<int>& delay_dist,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return delays_lp(delay_mean, delay_mean_mean, delay_mean_sd, delay_sd, delay_sd_mean, delay_sd_sd, delay_dist, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
day_of_week_effect(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 145;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 146;
        int wl(0);
        (void) wl;  // dummy to suppress unused var warning
        stan::math::fill(wl, std::numeric_limits<int>::min());
        stan::math::assign(wl,num_elements(effect));
        current_statement_begin__ = 148;
        validate_non_negative_index("scaled_effect", "wl", wl);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_effect(wl);
        stan::math::initialize(scaled_effect, DUMMY_VAR__);
        stan::math::fill(scaled_effect, DUMMY_VAR__);
        stan::math::assign(scaled_effect,multiply(wl, effect));
        current_statement_begin__ = 149;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 150;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 152;
            stan::model::assign(scaled_reports, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (get_base1(reports, s, "reports", 1) * get_base1(scaled_effect, get_base1(day_of_week, s, "day_of_week", 1), "scaled_effect", 1)), 
                        "assigning variable scaled_reports");
        }
        current_statement_begin__ = 154;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct day_of_week_effect_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) const {
        return day_of_week_effect(reports, day_of_week, effect, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
scale_obs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 159;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 160;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 161;
        stan::math::assign(scaled_reports, multiply(reports, frac_obs));
        current_statement_begin__ = 162;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct scale_obs_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) const {
        return scale_obs(reports, frac_obs, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
truncate(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& trunc_rev_cmf,
             const int& reconstruct, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 166;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 167;
        validate_non_negative_index("trunc_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_reports(t);
        stan::math::initialize(trunc_reports, DUMMY_VAR__);
        stan::math::fill(trunc_reports, DUMMY_VAR__);
        stan::math::assign(trunc_reports,reports);
        current_statement_begin__ = 169;
        int trunc_max(0);
        (void) trunc_max;  // dummy to suppress unused var warning
        stan::math::fill(trunc_max, std::numeric_limits<int>::min());
        stan::math::assign(trunc_max,num_elements(trunc_rev_cmf));
        current_statement_begin__ = 170;
        int first_t(0);
        (void) first_t;  // dummy to suppress unused var warning
        stan::math::fill(first_t, std::numeric_limits<int>::min());
        stan::math::assign(first_t,((t - trunc_max) + 1));
        current_statement_begin__ = 172;
        if (as_bool(reconstruct)) {
            current_statement_begin__ = 173;
            stan::model::assign(trunc_reports, 
                        stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                        stan::model::deep_copy(elt_divide(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), trunc_rev_cmf)), 
                        "assigning variable trunc_reports");
        } else {
            current_statement_begin__ = 175;
            stan::model::assign(trunc_reports, 
                        stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                        stan::model::deep_copy(elt_multiply(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), trunc_rev_cmf)), 
                        "assigning variable trunc_reports");
        }
        current_statement_begin__ = 177;
        return stan::math::promote_scalar<fun_return_scalar_t__>(trunc_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncate_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& trunc_rev_cmf,
             const int& reconstruct, std::ostream* pstream__) const {
        return truncate(reports, trunc_rev_cmf, reconstruct, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 183;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 184;
        if (as_bool(truncation)) {
            current_statement_begin__ = 185;
            if (as_bool(logical_gt(get_base1(trunc_mean_sd, 1, "trunc_mean_sd", 1), 0))) {
                current_statement_begin__ = 187;
                lp_accum__.add(normal_log<propto__>(truncation_mean, trunc_mean_mean, trunc_mean_sd));
            }
            current_statement_begin__ = 189;
            if (as_bool(logical_gt(get_base1(trunc_sd_sd, 1, "trunc_sd_sd", 1), 0))) {
                current_statement_begin__ = 191;
                lp_accum__.add(normal_log<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return truncation_lp(truncation_mean, truncation_sd, trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const T3__& phi_mean,
              const T4__& phi_sd,
              const int& model_type,
              const T6__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T6__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 199;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 200;
        if (as_bool(model_type)) {
            current_statement_begin__ = 202;
            lp_accum__.add(normal_log<propto__>(get_base1(rep_phi, model_type, "rep_phi", 1), phi_mean, phi_sd));
            if (get_base1(rep_phi, model_type, "rep_phi", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, phi_mean, phi_sd));
            current_statement_begin__ = 203;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 207;
        if (as_bool(logical_gt(sqrt_phi, 1e4))) {
            current_statement_begin__ = 208;
            if (as_bool(logical_eq(weight, 1))) {
                current_statement_begin__ = 209;
                lp_accum__.add(poisson_log<propto__>(cases, reports));
            } else {
                current_statement_begin__ = 211;
                lp_accum__.add((poisson_log(cases, reports) * weight));
            }
        } else {
            current_statement_begin__ = 214;
            if (as_bool(logical_eq(weight, 1))) {
                current_statement_begin__ = 215;
                lp_accum__.add(neg_binomial_2_log<propto__>(cases, reports, sqrt_phi));
            } else {
                current_statement_begin__ = 217;
                lp_accum__.add(neg_binomial_2_log(cases, reports, sqrt_phi));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_lp_functor__ {
    template <typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const T3__& phi_mean,
              const T4__& phi_sd,
              const int& model_type,
              const T6__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return report_lp(cases, reports, rep_phi, phi_mean, phi_sd, model_type, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
report_log_lik(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 225;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 226;
        validate_non_negative_index("log_lik", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(t);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 227;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 228;
        if (as_bool(model_type)) {
            current_statement_begin__ = 230;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 234;
        if (as_bool(logical_gt(sqrt_phi, 1e4))) {
            current_statement_begin__ = 235;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 236;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                            "assigning variable log_lik");
            }
        } else {
            current_statement_begin__ = 239;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 240;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (neg_binomial_2_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1), sqrt_phi) * weight), 
                            "assigning variable log_lik");
            }
        }
        current_statement_begin__ = 243;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_log_lik_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) const {
        return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
    }
};
template <typename T0__, typename T1__, class RNG>
std::vector<int>
report_rng(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 247;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 248;
        validate_non_negative_index("sampled_reports", "t", t);
        std::vector<int  > sampled_reports(t, int(0));
        stan::math::fill(sampled_reports, std::numeric_limits<int>::min());
        current_statement_begin__ = 249;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 250;
        if (as_bool(model_type)) {
            current_statement_begin__ = 251;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 254;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 256;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 257;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            poisson_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), base_rng__), 
                            "assigning variable sampled_reports");
            } else {
                current_statement_begin__ = 259;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            neg_binomial_2_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), sqrt_phi, base_rng__), 
                            "assigning variable sampled_reports");
            }
        }
        current_statement_begin__ = 262;
        return stan::math::promote_scalar<fun_return_scalar_t__>(sampled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_rng_functor__ {
    template <typename T0__, typename T1__, class RNG>
        std::vector<int>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) const {
        return report_rng(reports, rep_phi, model_type, base_rng__, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__>::type, Eigen::Dynamic, 1>
calculate_secondary(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                        const std::vector<int>& obs,
                        const std::vector<T2__>& frac_obs,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& delay_rev_pmf,
                        const int& cumulative,
                        const int& historic,
                        const int& primary_hist_additive,
                        const int& current,
                        const int& primary_current_additive,
                        const int& predict, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 269;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 270;
        int obs_scale(0);
        (void) obs_scale;  // dummy to suppress unused var warning
        stan::math::fill(obs_scale, std::numeric_limits<int>::min());
        stan::math::assign(obs_scale,num_elements(frac_obs));
        current_statement_begin__ = 271;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 272;
        validate_non_negative_index("conv_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> conv_reports(t);
        stan::math::initialize(conv_reports, DUMMY_VAR__);
        stan::math::fill(conv_reports, DUMMY_VAR__);
        stan::math::assign(conv_reports,rep_vector(1e-5, t));
        current_statement_begin__ = 273;
        validate_non_negative_index("secondary_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> secondary_reports(t);
        stan::math::initialize(secondary_reports, DUMMY_VAR__);
        stan::math::fill(secondary_reports, DUMMY_VAR__);
        stan::math::assign(secondary_reports,rep_vector(0.0, t));
        current_statement_begin__ = 275;
        if (as_bool(obs_scale)) {
            current_statement_begin__ = 276;
            stan::math::assign(scaled_reports, scale_obs(reports, get_base1(frac_obs, 1, "frac_obs", 1), pstream__));
        } else {
            current_statement_begin__ = 278;
            stan::math::assign(scaled_reports, reports);
        }
        current_statement_begin__ = 281;
        stan::math::assign(conv_reports, add(conv_reports, convolve_to_report(scaled_reports, delay_rev_pmf, 0, pstream__)));
        current_statement_begin__ = 285;
        for (int i = 1; i <= t; ++i) {
            current_statement_begin__ = 287;
            if (as_bool((primitive_value(cumulative) && primitive_value(logical_gt(i, 1))))) {
                current_statement_begin__ = 288;
                if (as_bool(logical_gt(i, predict))) {
                    current_statement_begin__ = 289;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(secondary_reports, (i - 1), "secondary_reports", 1), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 291;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(obs, (i - 1), "obs", 1), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 295;
            if (as_bool(historic)) {
                current_statement_begin__ = 296;
                if (as_bool(primary_hist_additive)) {
                    current_statement_begin__ = 297;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") + get_base1(conv_reports, i, "conv_reports", 1)), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 299;
                    if (as_bool(logical_gt(get_base1(conv_reports, i, "conv_reports", 1), get_base1(secondary_reports, i, "secondary_reports", 1)))) {
                        current_statement_begin__ = 300;
                        stan::model::assign(conv_reports, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(secondary_reports, i, "secondary_reports", 1), 
                                    "assigning variable conv_reports");
                    }
                    current_statement_begin__ = 302;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") - get_base1(conv_reports, i, "conv_reports", 1)), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 306;
            if (as_bool(current)) {
                current_statement_begin__ = 307;
                if (as_bool(primary_current_additive)) {
                    current_statement_begin__ = 308;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") + get_base1(scaled_reports, i, "scaled_reports", 1)), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 310;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") - get_base1(scaled_reports, i, "scaled_reports", 1)), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 313;
            stan::model::assign(secondary_reports, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (1e-6 + get_base1(secondary_reports, i, "secondary_reports", 1)), 
                        "assigning variable secondary_reports");
        }
        current_statement_begin__ = 315;
        return stan::math::promote_scalar<fun_return_scalar_t__>(secondary_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct calculate_secondary_functor__ {
    template <typename T0__, typename T2__, typename T3__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                        const std::vector<int>& obs,
                        const std::vector<T2__>& frac_obs,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& delay_rev_pmf,
                        const int& cumulative,
                        const int& historic,
                        const int& primary_hist_additive,
                        const int& current,
                        const int& primary_current_additive,
                        const int& predict, std::ostream* pstream__) const {
        return calculate_secondary(reports, obs, frac_obs, delay_rev_pmf, cumulative, historic, primary_hist_additive, current, primary_current_additive, predict, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_simulate_secondary
  : public stan::model::model_base_crtp<model_simulate_secondary> {
private:
        int n;
        int t;
        int h;
        int all_dates;
        std::vector<int> obs;
        matrix_d primary;
        int seeding_time;
        int cumulative;
        int historic;
        int primary_hist_additive;
        int current;
        int primary_current_additive;
        int delays;
        std::vector<std::vector<double> > delay_mean;
        std::vector<std::vector<double> > delay_sd;
        std::vector<int> delay_max;
        std::vector<int> delay_dist;
        std::vector<int> day_of_week;
        int week_effect;
        std::vector<std::vector<double> > day_of_week_simplex;
        int obs_scale;
        std::vector<std::vector<double> > frac_obs;
        int model_type;
        std::vector<std::vector<double> > rep_phi;
        int delay_max_total;
public:
    model_simulate_secondary(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_simulate_secondary(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_simulate_secondary_namespace::model_simulate_secondary";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 321;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 322;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            current_statement_begin__ = 323;
            context__.validate_dims("data initialization", "h", "int", context__.to_vec());
            h = int(0);
            vals_i__ = context__.vals_i("h");
            pos__ = 0;
            h = vals_i__[pos__++];
            current_statement_begin__ = 324;
            context__.validate_dims("data initialization", "all_dates", "int", context__.to_vec());
            all_dates = int(0);
            vals_i__ = context__.vals_i("all_dates");
            pos__ = 0;
            all_dates = vals_i__[pos__++];
            current_statement_begin__ = 326;
            validate_non_negative_index("obs", "(t - h)", (t - h));
            context__.validate_dims("data initialization", "obs", "int", context__.to_vec((t - h)));
            obs = std::vector<int>((t - h), int(0));
            vals_i__ = context__.vals_i("obs");
            pos__ = 0;
            size_t obs_k_0_max__ = (t - h);
            for (size_t k_0__ = 0; k_0__ < obs_k_0_max__; ++k_0__) {
                obs[k_0__] = vals_i__[pos__++];
            }
            size_t obs_i_0_max__ = (t - h);
            for (size_t i_0__ = 0; i_0__ < obs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "obs[i_0__]", obs[i_0__], 0);
            }
            current_statement_begin__ = 327;
            validate_non_negative_index("primary", "n", n);
            validate_non_negative_index("primary", "t", t);
            context__.validate_dims("data initialization", "primary", "matrix_d", context__.to_vec(n,t));
            primary = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, t);
            vals_r__ = context__.vals_r("primary");
            pos__ = 0;
            size_t primary_j_2_max__ = t;
            size_t primary_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < primary_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < primary_j_1_max__; ++j_1__) {
                    primary(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 328;
            context__.validate_dims("data initialization", "seeding_time", "int", context__.to_vec());
            seeding_time = int(0);
            vals_i__ = context__.vals_i("seeding_time");
            pos__ = 0;
            seeding_time = vals_i__[pos__++];
            current_statement_begin__ = 329;
            context__.validate_dims("data initialization", "cumulative", "int", context__.to_vec());
            cumulative = int(0);
            vals_i__ = context__.vals_i("cumulative");
            pos__ = 0;
            cumulative = vals_i__[pos__++];
            current_statement_begin__ = 330;
            context__.validate_dims("data initialization", "historic", "int", context__.to_vec());
            historic = int(0);
            vals_i__ = context__.vals_i("historic");
            pos__ = 0;
            historic = vals_i__[pos__++];
            current_statement_begin__ = 331;
            context__.validate_dims("data initialization", "primary_hist_additive", "int", context__.to_vec());
            primary_hist_additive = int(0);
            vals_i__ = context__.vals_i("primary_hist_additive");
            pos__ = 0;
            primary_hist_additive = vals_i__[pos__++];
            current_statement_begin__ = 332;
            context__.validate_dims("data initialization", "current", "int", context__.to_vec());
            current = int(0);
            vals_i__ = context__.vals_i("current");
            pos__ = 0;
            current = vals_i__[pos__++];
            current_statement_begin__ = 333;
            context__.validate_dims("data initialization", "primary_current_additive", "int", context__.to_vec());
            primary_current_additive = int(0);
            vals_i__ = context__.vals_i("primary_current_additive");
            pos__ = 0;
            primary_current_additive = vals_i__[pos__++];
            current_statement_begin__ = 335;
            context__.validate_dims("data initialization", "delays", "int", context__.to_vec());
            delays = int(0);
            vals_i__ = context__.vals_i("delays");
            pos__ = 0;
            delays = vals_i__[pos__++];
            current_statement_begin__ = 336;
            validate_non_negative_index("delay_mean", "n", n);
            validate_non_negative_index("delay_mean", "delays", delays);
            context__.validate_dims("data initialization", "delay_mean", "double", context__.to_vec(n,delays));
            delay_mean = std::vector<std::vector<double> >(n, std::vector<double>(delays, double(0)));
            vals_r__ = context__.vals_r("delay_mean");
            pos__ = 0;
            size_t delay_mean_k_0_max__ = n;
            size_t delay_mean_k_1_max__ = delays;
            for (size_t k_1__ = 0; k_1__ < delay_mean_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
                    delay_mean[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 337;
            validate_non_negative_index("delay_sd", "n", n);
            validate_non_negative_index("delay_sd", "delays", delays);
            context__.validate_dims("data initialization", "delay_sd", "double", context__.to_vec(n,delays));
            delay_sd = std::vector<std::vector<double> >(n, std::vector<double>(delays, double(0)));
            vals_r__ = context__.vals_r("delay_sd");
            pos__ = 0;
            size_t delay_sd_k_0_max__ = n;
            size_t delay_sd_k_1_max__ = delays;
            for (size_t k_1__ = 0; k_1__ < delay_sd_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
                    delay_sd[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 338;
            validate_non_negative_index("delay_max", "delays", delays);
            context__.validate_dims("data initialization", "delay_max", "int", context__.to_vec(delays));
            delay_max = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("delay_max");
            pos__ = 0;
            size_t delay_max_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_max_k_0_max__; ++k_0__) {
                delay_max[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 339;
            validate_non_negative_index("delay_dist", "delays", delays);
            context__.validate_dims("data initialization", "delay_dist", "int", context__.to_vec(delays));
            delay_dist = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("delay_dist");
            pos__ = 0;
            size_t delay_dist_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_dist_k_0_max__; ++k_0__) {
                delay_dist[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 341;
            validate_non_negative_index("day_of_week", "(t - seeding_time)", (t - seeding_time));
            context__.validate_dims("data initialization", "day_of_week", "int", context__.to_vec((t - seeding_time)));
            day_of_week = std::vector<int>((t - seeding_time), int(0));
            vals_i__ = context__.vals_i("day_of_week");
            pos__ = 0;
            size_t day_of_week_k_0_max__ = (t - seeding_time);
            for (size_t k_0__ = 0; k_0__ < day_of_week_k_0_max__; ++k_0__) {
                day_of_week[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 342;
            context__.validate_dims("data initialization", "week_effect", "int", context__.to_vec());
            week_effect = int(0);
            vals_i__ = context__.vals_i("week_effect");
            pos__ = 0;
            week_effect = vals_i__[pos__++];
            current_statement_begin__ = 343;
            validate_non_negative_index("day_of_week_simplex", "n", n);
            validate_non_negative_index("day_of_week_simplex", "week_effect", week_effect);
            context__.validate_dims("data initialization", "day_of_week_simplex", "double", context__.to_vec(n,week_effect));
            day_of_week_simplex = std::vector<std::vector<double> >(n, std::vector<double>(week_effect, double(0)));
            vals_r__ = context__.vals_r("day_of_week_simplex");
            pos__ = 0;
            size_t day_of_week_simplex_k_0_max__ = n;
            size_t day_of_week_simplex_k_1_max__ = week_effect;
            for (size_t k_1__ = 0; k_1__ < day_of_week_simplex_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < day_of_week_simplex_k_0_max__; ++k_0__) {
                    day_of_week_simplex[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t day_of_week_simplex_i_0_max__ = n;
            size_t day_of_week_simplex_i_1_max__ = week_effect;
            for (size_t i_0__ = 0; i_0__ < day_of_week_simplex_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < day_of_week_simplex_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "day_of_week_simplex[i_0__][i_1__]", day_of_week_simplex[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 344;
            context__.validate_dims("data initialization", "obs_scale", "int", context__.to_vec());
            obs_scale = int(0);
            vals_i__ = context__.vals_i("obs_scale");
            pos__ = 0;
            obs_scale = vals_i__[pos__++];
            current_statement_begin__ = 345;
            validate_non_negative_index("frac_obs", "n", n);
            validate_non_negative_index("frac_obs", "obs_scale", obs_scale);
            context__.validate_dims("data initialization", "frac_obs", "double", context__.to_vec(n,obs_scale));
            frac_obs = std::vector<std::vector<double> >(n, std::vector<double>(obs_scale, double(0)));
            vals_r__ = context__.vals_r("frac_obs");
            pos__ = 0;
            size_t frac_obs_k_0_max__ = n;
            size_t frac_obs_k_1_max__ = obs_scale;
            for (size_t k_1__ = 0; k_1__ < frac_obs_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
                    frac_obs[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t frac_obs_i_0_max__ = n;
            size_t frac_obs_i_1_max__ = obs_scale;
            for (size_t i_0__ = 0; i_0__ < frac_obs_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < frac_obs_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "frac_obs[i_0__][i_1__]", frac_obs[i_0__][i_1__], 0);
                    check_less_or_equal(function__, "frac_obs[i_0__][i_1__]", frac_obs[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 346;
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            current_statement_begin__ = 347;
            validate_non_negative_index("rep_phi", "n", n);
            validate_non_negative_index("rep_phi", "model_type", model_type);
            context__.validate_dims("data initialization", "rep_phi", "double", context__.to_vec(n,model_type));
            rep_phi = std::vector<std::vector<double> >(n, std::vector<double>(model_type, double(0)));
            vals_r__ = context__.vals_r("rep_phi");
            pos__ = 0;
            size_t rep_phi_k_0_max__ = n;
            size_t rep_phi_k_1_max__ = model_type;
            for (size_t k_1__ = 0; k_1__ < rep_phi_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
                    rep_phi[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t rep_phi_i_0_max__ = n;
            size_t rep_phi_i_1_max__ = model_type;
            for (size_t i_0__ = 0; i_0__ < rep_phi_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rep_phi_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "rep_phi[i_0__][i_1__]", rep_phi[i_0__][i_1__], 0);
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 351;
            delay_max_total = int(0);
            stan::math::fill(delay_max_total, std::numeric_limits<int>::min());
            stan::math::assign(delay_max_total,((sum(delay_max) - num_elements(delay_max)) + 1));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_simulate_secondary() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sim_secondary");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back((all_dates ? t : h ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_simulate_secondary_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 355;
            validate_non_negative_index("sim_secondary", "n", n);
            validate_non_negative_index("sim_secondary", "(all_dates ? t : h )", (all_dates ? t : h ));
            std::vector<std::vector<int> > sim_secondary(n, std::vector<int>((all_dates ? t : h ), int(0)));
            stan::math::fill(sim_secondary, std::numeric_limits<int>::min());
            // generated quantities statements
            current_statement_begin__ = 356;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 357;
                validate_non_negative_index("secondary", "t", t);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> secondary(t);
                stan::math::initialize(secondary, DUMMY_VAR__);
                stan::math::fill(secondary, DUMMY_VAR__);
                current_statement_begin__ = 358;
                validate_non_negative_index("delay_rev_pmf", "delay_max_total", delay_max_total);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delay_rev_pmf(delay_max_total);
                stan::math::initialize(delay_rev_pmf, DUMMY_VAR__);
                stan::math::fill(delay_rev_pmf, DUMMY_VAR__);
                current_statement_begin__ = 359;
                stan::math::assign(delay_rev_pmf, combine_pmfs(to_vector(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).array())), get_base1(delay_mean, i, "delay_mean", 1), get_base1(delay_sd, i, "delay_sd", 1), delay_max, delay_dist, delay_max_total, 0, 1, pstream__));
                current_statement_begin__ = 365;
                stan::math::assign(secondary, calculate_secondary(to_vector(get_base1(primary, i, "primary", 1)), obs, get_base1(frac_obs, i, "frac_obs", 1), delay_rev_pmf, cumulative, historic, primary_hist_additive, current, primary_current_additive, ((t - h) + 1), pstream__));
                current_statement_begin__ = 372;
                if (as_bool(logical_gt(week_effect, 1))) {
                    current_statement_begin__ = 373;
                    stan::math::assign(secondary, day_of_week_effect(secondary, day_of_week, to_vector(get_base1(day_of_week_simplex, i, "day_of_week_simplex", 1)), pstream__));
                }
                current_statement_begin__ = 376;
                stan::model::assign(sim_secondary, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            report_rng(tail(secondary, (all_dates ? t : h )), get_base1(rep_phi, i, "rep_phi", 1), model_type, base_rng__, pstream__), 
                            "assigning variable sim_secondary");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 355;
            size_t sim_secondary_k_0_max__ = n;
            size_t sim_secondary_k_1_max__ = (all_dates ? t : h );
            for (size_t k_1__ = 0; k_1__ < sim_secondary_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                    vars__.push_back(sim_secondary[k_0__][k_1__]);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_simulate_secondary";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t sim_secondary_k_0_max__ = n;
        size_t sim_secondary_k_1_max__ = (all_dates ? t : h );
        for (size_t k_1__ = 0; k_1__ < sim_secondary_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sim_secondary" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t sim_secondary_k_0_max__ = n;
        size_t sim_secondary_k_1_max__ = (all_dates ? t : h );
        for (size_t k_1__ = 0; k_1__ < sim_secondary_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sim_secondary" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_simulate_secondary_namespace::model_simulate_secondary stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
