% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{delay_opts}
\alias{delay_opts}
\title{Delay Distribution Options}
\usage{
delay_opts(dist = dist_spec(), ..., fixed = FALSE)
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions generated
using \code{\link[=dist_spec]{dist_spec()}}. Default is an empty call to \code{\link[=dist_spec]{dist_spec()}}, i.e. no delay}

\item{...}{deprecated; use \code{dist} instead}

\item{fixed}{deprecated; use \code{dist} instead}
}
\value{
A list summarising the input delay distributions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns delay distributions formatted for usage by downstream
functions.
}
\examples{
# no delays
delay_opts()

# A single delay that has uncertainty
delay <- dist_spec(mean = 1, mean_sd = 0.2, sd = 0.5, sd_sd = 0.1, max = 15)
delay_opts(delay)

# A single delay without uncertainty
delay <- dist_spec(mean = 1, sd = 0.5, max = 15)
delay_opts(delay)

# Multiple delays (in this case twice the same)
delay_opts(delay + delay)
}
\seealso{
convert_to_logmean convert_to_logsd bootstrapped_dist_fit dist_spec
}
\author{
Sam Abbott

Sebastian Funk
}
