% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{apply_tolerance}
\alias{apply_tolerance}
\title{Applies a threshold to all nonparametric distributions in a <dist_spec>}
\usage{
apply_tolerance(x, tolerance)
}
\arguments{
\item{x}{A \verb{<dist_spec>}}

\item{tolerance}{Numeric; the desired tolerance level.}
}
\value{
A \verb{<dist_spec>} where probability masses below the threshold level
have been removed
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This removes any part of the tail of the nonparametric distributions in the
<dist_spec> where the probability mass is below the threshold level.
}
\examples{
dist <- discretise(Gamma(mean = 5, sd = 1, max = 20))
apply_tolerance(dist, 0.01)
}
