% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_OrderBook.Chart.R
\name{EN_OrderBook.Chart}
\alias{EN_OrderBook.Chart}
\title{Plot Order Book Chart for a Given Ticker}
\usage{
EN_OrderBook.Chart(
  ticker,
  stock_type = "Equity",
  bid.col = "darkgreen",
  ask.col = "#FF0000",
  plot_type = "depth"
)
}
\arguments{
\item{ticker}{The ticker symbol for which the order book chart will be plotted.}

\item{stock_type}{The type of the ticker: 'Equity' for Stocks and 'Etf' for EFTs.}

\item{bid.col}{Color for bid prices in the chart. Default is '#00FF00' (green).}

\item{ask.col}{Color for ask prices in the chart. Default is '#FF0000' (red).}

\item{plot_type}{Type of visualization (‘depth’ or ‘barh’).}
}
\value{
A Highchart plot displaying the order book for the provided ticker.
}
\description{
This function plots an order book chart for a given ticker. It retrieves the order book data using the \code{EN_Get_OB} function and then creates a Highchart plot displaying bid and ask prices along with their respective quantities.
}
\examples{

\donttest{

# Notes : Usually , the function will work perfectly if the ticker is an Equity,
library(httr)
library(highcharter)
library(jsonlite)
library(dplyr)
library(magrittr)
library(rvest)
library(grDevices)
library(stringr)

# Plot ABC ARBITRAGE ticker Order Book BarH chart by providing ISIN
ABCA_OB.chart = EN_OrderBook.Chart("FR0004040608", plot_type = 'barh') #using default colors
ABCA_OB.chart

# Plot LEBON ticker Order Book Chart
ALBON_OB.chart = EN_OrderBook.Chart("ALBON", bid.col = 'cyan', ask.col ='gold')
ALBON_OB.chart

# Order Book depth chart of 'AAPL' Etf
AAPL_OB.chart = EN_OrderBook.Chart("XS2337099563", stock_type = 'Etf')

# Order Book bar chart of 'LEVERAGE SHARES PLC' Etf
LEV_OB.chart = EN_OrderBook.Chart("XS2663694847", stock_type = 'Etf', plot_type = 'barh')


# The following code Will return an error because the "Ticker" is invalid
# EN_OrderBook.Chart("ALBONgdg")

}

}
\seealso{
\code{\link{EN_Get_OB}} to retrieve the Order Book of a given ticker.

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Plot: 
\code{\link{EN_Overview_plot}()},
\code{\link{EN_plot}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{Data Retrieval}
\concept{Euronext}
\concept{Plot}
