% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Performers.Settings.R
\name{EN_Performers.Settings}
\alias{EN_Performers.Settings}
\title{Retrieve settings for stock performers.}
\usage{
EN_Performers.Settings(stock_choice)
}
\arguments{
\item{stock_choice}{A character string specifying the stock market. Allowed values: 'All', 'Amsterdam' (or 'A'), 'Brussels' (or 'B'), 'Dublin' (or 'D'), 'Lisbon' (or 'L'), 'Milan' (or 'M'), 'Paris' (or 'P'), 'Oslo' (or 'O').}
}
\value{
A list containing two data frames: 'belongs_to' and 'eligibility'. Each data frame has two columns: 'Information' (the text of the option) and 'Code' (the value of the attribute).
}
\description{
This function retrieves settings for stock performers, including the acceptable values for 'belongs_to' and 'eligibility' attributes.
}
\examples{

library(httr)
library(jsonlite)
library(stringr)
library(magrittr)

# Amsterdam stock setting:
amsterdam_settings <- EN_Performers.Settings("a")
print(amsterdam_settings)

# Brussels stock setting:
b_settings <- EN_Performers.Settings("b")
print(b_settings)

# To get all acceptable 'belongs_to' attribute code of Brussels stock
EN_Performers.Settings("b")$belongs_to$Code

# To get all acceptable 'eligibility' Code of Brussels stock
EN_Performers.Settings("b")$eligibility$Code

# To get all acceptable 'belongs_to' attribute code of Paris stock
EN_Performers.Settings("p")$belongs_to$Code

# To get all acceptable 'eligibility' Code of Paris stock
EN_Performers.Settings("p")$eligibility$Code


}
\seealso{
\code{\link{EN_Stock.Performers}} for retrieving performance data for stocks.
}
