% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortMethod.R
\name{plotCovariateBalances}
\alias{plotCovariateBalances}
\title{Plot covariate balances}
\usage{
plotCovariateBalances(
  balances,
  labels,
  threshold = 0,
  beforeLabel = "Before matching",
  afterLabel = "After matching",
  fileName = NULL
)
}
\arguments{
\item{balances}{A list of covariate balance objects as created using the
\code{computeCovariateBalance()} function in the \code{CohortMethod} package. Each
balance object is expected to be a data frame with at least these two columns:
\code{beforeMatchingStdDiff} and \code{afterMatchingStdDiff}.}

\item{labels}{A vector containing the labels for the various sources.}

\item{threshold}{Show a threshold value for the standardized difference.}

\item{beforeLabel}{Label for before matching / stratification / trimming.}

\item{afterLabel}{Label for after matching / stratification / trimming.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See
the function \link[ggplot2:ggsave]{ggplot2::ggsave} for supported file formats.}
}
\value{
A Ggplot object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave}.
}
\description{
Plots the covariate balance before and after matching for multiple data sources.
}
\details{
Creates a plot showing the covariate balance before and after matching. Balance distributions are
displayed as box plots combined with scatterplots.
}
\examples{
# Some example data:
balance1 <- data.frame(beforeMatchingStdDiff = rnorm(1000, 0.1, 0.1),
                       afterMatchingStdDiff = rnorm(1000, 0, 0.01))
balance2 <- data.frame(beforeMatchingStdDiff = rnorm(1000, 0.2, 0.1),
                       afterMatchingStdDiff = rnorm(1000, 0, 0.05))
balance3 <- data.frame(beforeMatchingStdDiff = rnorm(1000, 0, 0.1),
                       afterMatchingStdDiff = rnorm(1000, 0, 0.03))
plotCovariateBalances(balances = list(balance1, balance2, balance3),
                      labels = c("Site A", "Site B", "Site C"))

}
