% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treesWoffset.R
\name{offset.to.dummy.metadata}
\alias{offset.to.dummy.metadata}
\title{Convert trees produced by a BEAST2 FBD analysis with offset to trees with correct ages,
accounting for possible metadata on the tips.}
\usage{
offset.to.dummy.metadata(
  trees.file,
  log.file,
  output.file = NULL,
  dummy.name = "dummy"
)
}
\arguments{
\item{trees.file}{path to BEAST2 output file containing posterior trees}

\item{log.file}{path to BEAST2 trace log file containing offset values}

\item{output.file}{path to file to write converted trees. If \code{NULL} (default), trees are simply returned.}

\item{dummy.name}{name of the added dummy tip, default \code{dummy}.}
}
\value{
list of converted trees (as treedata)
}
\description{
This method adds a dummy tip at the present (t = 0) to fully extinct trees with offsets,
in order to have correct ages (otherwise the most recent tip is assumed to be at 0).
This is a workaround to get the proper ages of the trees into other tools such as TreeAnnotator.
}
\examples{
# Convert trees with offset to trees with dummy tip
trees_file = system.file("extdata", "ex_offset.trees", package = "EvoPhylo")
log_file = system.file("extdata", "ex_offset.log", package = "EvoPhylo")
converted_trees = offset.to.dummy.metadata(trees_file, log_file)

# Do something with the converted trees - for instance, calculate the MCC summary tree
# Then remove the dummy tip from the MCC tree
final_tree = drop.dummy.beast(system.file("extdata", "ex_offset.MCC.tre", package = "EvoPhylo"))

}
\seealso{
\code{\link[=offset.to.dummy]{offset.to.dummy()}} (faster version discarding metadata)
}
