

starting.values <- function(MODEL){
      if(MODEL == "BM_null"){
         p_matrix <- c(
            0.00001,
            0.0001,
            0.001,
            0.01,
            0.02,
            0.04,
            0.06,
            0.08,
            0.1,
            0.2,
            0.3,
            0.4,
            0.5,
            0.6,
            0.7,
            0.8,
            0.9,
            1.0,
            2.0,
            5.0,
            10.0,
            100.0,
            1000,
            10000
         )
         p_starting <- matrix(p_matrix, length(p_matrix), 1, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 3)
         result_matrix[,1] <- p_starting
      }
      if(MODEL == "BM_linear"){
         p_matrix <- c(
            0.01, 0.01,
            0.01, 0.1,
            0.01, 0.5,
            0.01,-0.01,
            0.01, -0.1,
            0.01, -0.5,
            0.1, 0.01,
            0.1, 0.1,
            0.1, 0.5,
            0.1,-0.01,
            0.1, -0.1,
            0.1, -0.5,
            0.5, 0.01,
            0.5, 0.1,
            0.5, 0.5,
            0.5,-0.01,
            0.5, -0.1,
            0.5, -0.5,
            1.0, 0.01,
            1.0, 0.1,
            1.0, 0.5,
            1.0,-0.01,
            1.0, -0.1,
            1.0, -0.5,
            10.0, 0.01,
            10.0, 0.1,
            10.0, 0.5,
            10.0,-0.01,
            10.0, -0.1,
            10.0, -0.5,
            100.0, 0.01,
            100.0, 0.1,
            100.0, 0.5,
            100.0,-0.01,
            100.0, -0.1,
            100.0, -0.5,
            1.0, 1,
            1.0, 5,
            1.0, 10,
            1.0,-1,
            1.0, -5,
            1.0, -10,
            10.0, 1,
            10.0, 5,
            10.0, 10,
            10.0,-1,
            10.0, -5,
            10.0, -10,
            100.0, 1,
            100.0, 5,
            100.0, 10,
            100.0,-1,
            100.0, -5,
            100.0, -10
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/2, 2, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 3)
         result_matrix[,1:2] <- p_starting
      }

      if(MODEL == "OU_null"){
         p_matrix <- c(
            100,	0.001,
            100,	0.01,
            100,	0.1,
            100,	1,
            100,	10,
            10,	0.001,
            10,	0.01,
            10,	0.1,
            10,	1,
            1,	0.001,
            1,	0.01,
            1,	0.1,
            1,	1,
            0.5,	0.001,
            0.5,	0.01,
            0.5,	0.1,
            0.5,	1,
            0.1,	0.001,
            0.1,	0.01,
            0.1,	0.1,
            0.1,	1,	
            0.01,	0.001,
            0.01,	0.01,
            0.01,	0.1,
            0.01,	1
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/2, 2, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 3)
         result_matrix[,1:2] <- p_starting
      }


      if(MODEL == "OU_linear_beta"){
         p_matrix <- c(
		            0.01,	0.001,	0.001,
		            0.01,	0.001,	0.01,
		            0.01,	0.001,	0.1,
		            0.01,	0.001,	0.5,
		            0.01,	0.001,	1,
		            0.01,	0.001,	5,
		            0.01,	0.001,	10,
		            0.01,	-0.001,	0.001,
		            0.01,	-0.001,	0.01,
		            0.01,	-0.001,	0.1,
		            0.01,	-0.001,	0.5,
		            0.01,	-0.001,	1,
		            0.01,	-0.001,	5,
		            0.01,	-0.001,	10,
		            0.01,	0.01,	0.001,
		            0.01,	0.01,	0.01,
		            0.01,	0.01,	0.1,
		            0.01,	0.01,	0.5,
		            0.01,	0.01,	1,
		            0.01,	0.01,	5,
		            0.01,	0.01,	10,
		            0.01,	-0.01,	0.001,
		            0.01,	-0.01,	0.01,
		            0.01,	-0.01,	0.1,
		            0.01,	-0.01,	0.5,
		            0.01,	-0.01,	1,
		            0.01,	-0.01,	5,
		            0.01,	-0.01,	10,
		            0.01,	0.1,	0.001,
		            0.01,	0.1,	0.01,
		            0.01,	0.1,	0.1,
		            0.01,	0.1,	0.5,
		            0.01,	0.1,	1,
		            0.01,	0.1,	5,
		            0.01,	0.1,	10,
		            0.01,	-0.1,	0.001,
		            0.01,	-0.1,	0.01,
		            0.01,	-0.1,	0.1,
		            0.01,	-0.1,	0.5,
		            0.01,	-0.1,	1,
		            0.01,	-0.1,	5,
		            0.01,	-0.1,	10,
		            0.1,	0.001,	0.001,
		            0.1,	0.001,	0.01,
		            0.1,	0.001,	0.1,
		            0.1,	0.001,	0.5,
		            0.1,	0.001,	1,
		            0.1,	0.001,	5,
		            0.1,	0.001,	10,
		            0.1,	-0.001,	0.001,
		            0.1,	-0.001,	0.01,
		            0.1,	-0.001,	0.1,
		            0.1,	-0.001,	0.5,
		            0.1,	-0.001,	1,
		            0.1,	-0.001,	5,
		            0.1,	-0.001,	10,
		            0.1,	0.01,	0.001,
		            0.1,	0.01,	0.01,
		            0.1,	0.01,	0.1,
		            0.1,	0.01,	0.5,
		            0.1,	0.01,	1,
		            0.1,	0.01,	5,
		            0.1,	0.01,	10,
		            0.1,	-0.01,	0.001,
		            0.1,	-0.01,	0.01,
		            0.1,	-0.01,	0.1,
		            0.1,	-0.01,	0.5,
		            0.1,	-0.01,	1,
		            0.1,	-0.01,	5,
		            0.1,	-0.01,	10,
		            0.1,	0.1,	0.001,
		            0.1,	0.1,	0.01,
		            0.1,	0.1,	0.1,
		            0.1,	0.1,	0.5,
		            0.1,	0.1,	1,
		            0.1,	0.1,	5,
		            0.1,	0.1,	10,
		            0.1,	-0.1,	0.001,
		            0.1,	-0.1,	0.01,
		            0.1,	-0.1,	0.1,
		            0.1,	-0.1,	0.5,
		            0.1,	-0.1,	1,
		            0.1,	-0.1,	5,
		            0.5,	-0.1,	10,
		            0.5,	0.001,	0.001,
		            0.5,	0.001,	0.01,
		            0.5,	0.001,	0.1,
		            0.5,	0.001,	0.5,
		            0.5,	0.001,	1,
		            0.5,	0.001,	5,
		            0.5,	0.001,	10,
		            0.5,	-0.001,	0.001,
		            0.5,	-0.001,	0.01,
		            0.5,	-0.001,	0.1,
		            0.5,	-0.001,	0.5,
		            0.5,	-0.001,	1,
		            0.5,	-0.001,	5,
		            0.5,	-0.001,	10,
		            0.5,	0.01,	0.001,
		            0.5,	0.01,	0.01,
		            0.5,	0.01,	0.1,
		            0.5,	0.01,	0.5,
		            0.5,	0.01,	1,
		            0.5,	0.01,	5,
		            0.5,	0.01,	10,
		            0.5,	-0.01,	0.001,
		            0.5,	-0.01,	0.01,
		            0.5,	-0.01,	0.1,
		            0.5,	-0.01,	0.5,
		            0.5,	-0.01,	1,
		            0.5,	-0.01,	5,
		            0.5,	-0.01,	10,
		            0.5,	0.1,	0.001,
		            0.5,	0.1,	0.01,
		            0.5,	0.1,	0.1,
		            0.5,	0.1,	0.5,
		            0.5,	0.1,	1,
		            0.5,	0.1,	5,
		            0.5,	0.1,	10,
		            0.5,	-0.1,	0.001,
		            0.5,	-0.1,	0.01,
		            0.5,	-0.1,	0.1,
		            0.5,	-0.1,	0.5,
		            0.5,	-0.1,	1,
		            0.5,	-0.1,	5,
		            0.5,	-0.1,	10,
		            1,	0.001,	0.001,
		            1,	0.001,	0.01,
		            1,	0.001,	0.1,
		            1,	0.001,	0.5,
		            1,	0.001,	1,
		            1,	0.001,	5,
		            1,	0.001,	10,
		            1,	-0.001,	0.001,
		            1,	-0.001,	0.01,
		            1,	-0.001,	0.1,
		            1,	-0.001,	0.5,
		            1,	-0.001,	1,
		            1,	-0.001,	5,
		            1,	-0.001,	10,
		            1,	0.01,	0.001,
		            1,	0.01,	0.01,
		            1,	0.01,	0.1,
		            1,	0.01,	0.5,
		            1,	0.01,	1,
		            1,	0.01,	5,
		            1,	0.01,	10,
		            1,	-0.01,	0.001,
		            1,	-0.01,	0.01,
		            1,	-0.01,	0.1,
		            1,	-0.01,	0.5,
		            1,	-0.01,	1,
		            1,	-0.01,	5,
		            1,	-0.01,	10,
		            1,	0.1,	0.001,
		            1,	0.1,	0.01,
		            1,	0.1,	0.1,
		            1,	0.1,	0.5,
		            1,	0.1,	1,
		            1,	0.1,	5,
		            1,	0.1,	10,
		            1,	-0.1,	0.001,
		            1,	-0.1,	0.01,
		            1,	-0.1,	0.1,
		            1,	-0.1,	0.5,
		            1,	-0.1,	1,
		            1,	-0.1,	5,
		            1,	-0.1,	10,
		10,	0.001,	0.001,
		10,	0.001,	0.01,
		10,	0.001,	0.1,
		10,	0.001,	0.5,
		10,	0.001,	1,
		10,	0.001,	5,
		10,	0.001,	10,
		10,	-0.001,	0.001,
		10,	-0.001,	0.01,
		10,	-0.001,	0.1,
		10,	-0.001,	0.5,
		10,	-0.001,	1,
		10,	-0.001,	5,
		10,	-0.001,	10,
		10,	0.01,	0.001,
		10,	0.01,	0.01,
		10,	0.01,	0.1,
		10,	0.01,	0.5,
		10,	0.01,	1,
		10,	0.01,	5,
		10,	0.01,	10,
		10,	-0.01,	0.001,
		10,	-0.01,	0.01,
		10,	-0.01,	0.1,
		10,	-0.01,	0.5,
		10,	-0.01,	1,
		10,	-0.01,	5,
		10,	-0.01,	10,
		10,	0.1,	0.001,
		10,	0.1,	0.01,
		10,	0.1,	0.1,
		10,	0.1,	0.5,
		10,	0.1,	1,
		10,	0.1,	5,
		10,	0.1,	10,
		10,	-0.1,	0.001,
		10,	-0.1,	0.01,
		10,	-0.1,	0.1,
		10,	-0.1,	0.5,
		10,	-0.1,	1,
		10,	-0.1,	5,
		10,	-0.1,	10
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/3, 3, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 4)
         result_matrix[,1:3] <- p_starting
      }
 


      if(MODEL == "OU_linear"){
         p_matrix <- c(
            10,	0.01,	0.01,	0.01,
            10,	0.01,	0.1,	0.01,
            10,	0.01,	0.5,	0.01,
            10,	0.01,	1,	0.01,
            10,	0.01,	5,	0.01,
            10,	0.01,	10,	0.01,
            10,	0.1,	0.01,	0.01,
            10,	0.1,	0.1,	0.01,
            10,	0.1,	0.5,	0.01,
            10,	0.1,	1,	0.01,
            10,	0.1,	5,	0.01,
            10,	0.1,	10,	0.01,
            10,	0.01,	0.01,	0.1,
            10,	0.01,	0.1,	0.1,
            10,	0.01,	0.5,	0.1,
            10,	0.01,	1,	0.1,
            10,	0.01,	5,	0.1,
            10,	0.01,	10,	0.1,
            10,	0.001,	0.01,	0.001,
            10,	0.001,	0.1,	0.001,
            10,	0.001,	0.5,	0.001,
            10,	0.001,	1,	0.001,
            10,	0.001,	5,	0.001,
            10,	0.001,	10,	0.001,

            10,	-0.01,	0.01,	0.01,
            10,	-0.01,	0.1,	0.01,
            10,	-0.01,	0.5,	0.01,
            10,	-0.01,	1,	0.01,
            10,	-0.01,	5,	0.01,
            10,	-0.01,	10,	0.01,
            10,	-0.1,	0.01,	0.01,
            10,	-0.1,	0.1,	0.01,
            10,	-0.1,	0.5,	0.01,
            10,	-0.1,	1,	0.01,
            10,	-0.1,	5,	0.01,
            10,	-0.1,	10,	0.01,
            10,	-0.01,	0.01,	0.1,
            10,	-0.01,	0.1,	0.1,
            10,	-0.01,	0.5,	0.1,
            10,	-0.01,	1,	0.1,
            10,	-0.01,	5,	0.1,
            10,	-0.01,	10,	0.1,
            10,	-0.001,	0.01,	0.001,
            10,	-0.001,	0.1,	0.001,
            10,	-0.001,	0.5,	0.001,
            10,	-0.001,	1,	0.001,
            10,	-0.001,	5,	0.001,
            10,	-0.001,	10,	0.001,

            10,	0.01,	0.01,	-0.01,
            10,	0.01,	0.1,	-0.01,
            10,	0.01,	0.5,	-0.01,
            10,	0.01,	1,	-0.01,
            10,	0.01,	5,	-0.01,
            10,	0.01,	10,	-0.01,
            10,	0.1,	0.01,	-0.01,
            10,	0.1,	0.1,	-0.01,
            10,	0.1,	0.5,	-0.01,
            10,	0.1,	1,	-0.01,
            10,	0.1,	5,	-0.01,
            10,	0.1,	10,	-0.01,
            10,	0.01,	0.01,	-0.1,
            10,	0.01,	0.1,	-0.1,
            10,	0.01,	0.5,	-0.1,
            10,	0.01,	1,	-0.1,
            10,	0.01,	5,	-0.1,
            10,	0.01,	10,	-0.1,
            10,	0.001,	0.01,	-0.001,
            10,	0.001,	0.1,	-0.001,
            10,	0.001,	0.5,	-0.001,
            10,	0.001,	1,	-0.001,
            10,	0.001,	5,	-0.001,
            10,	0.001,	10,	-0.001,


            10,	-0.01,	0.01,	-0.01,
            10,	-0.01,	0.1,	-0.01,
            10,	-0.01,	0.5,	-0.01,
            10,	-0.01,	1,	-0.01,
            10,	-0.01,	5,	-0.01,
            10,	-0.01,	10,	-0.01,
            10,	-0.1,	0.01,	-0.01,
            10,	-0.1,	0.1,	-0.01,
            10,	-0.1,	0.5,	-0.01,
            10,	-0.1,	1,	-0.01,
            10,	-0.1,	5,	-0.01,
            10,	-0.1,	10,	-0.01,
            10,	-0.01,	0.01,	-0.1,
            10,	-0.01,	0.1,	-0.1,
            10,	-0.01,	0.5,	-0.1,
            10,	-0.01,	1,	-0.1,
            10,	-0.01,	5,	-0.1,
            10,	-0.01,	10,	-0.1,
            10,	-0.001,	0.01,	-0.001,
            10,	-0.001,	0.1,	-0.001,
            10,	-0.001,	0.5,	-0.001,
            10,	-0.001,	1,	-0.001,
            10,	-0.001,	5,	-0.001,
            10,	-0.001,	10,	-0.001,

           10,	0.01,	0.01,	0.01,
            1,	0.01,	0.1,	0.01,
            1,	0.01,	0.5,	0.01,
            1,	0.01,	1,	0.01,
            1,	0.01,	5,	0.01,
            1,	0.01,	10,	0.01,
            1,	0.1,	0.01,	0.01,
            1,	0.1,	0.1,	0.01,
            1,	0.1,	0.5,	0.01,
            1,	0.1,	1,	0.01,
            1,	0.1,	5,	0.01,
            1,	0.1,	10,	0.01,
            1,	0.01,	0.01,	0.1,
            1,	0.01,	0.1,	0.1,
            1,	0.01,	0.5,	0.1,
            1,	0.01,	1,	0.1,
            1,	0.01,	5,	0.1,
            1,	0.01,	10,	0.1,
            1,	0.001,	0.01,	0.001,
            1,	0.001,	0.1,	0.001,
            1,	0.001,	0.5,	0.001,
            1,	0.001,	1,	0.001,
            1,	0.001,	5,	0.001,
            1,	0.001,	10,	0.001,

            1,	-0.01,	0.01,	0.01,
            1,	-0.01,	0.1,	0.01,
            1,	-0.01,	0.5,	0.01,
            1,	-0.01,	1,	0.01,
            1,	-0.01,	5,	0.01,
            1,	-0.01,	10,	0.01,
            1,	-0.1,	0.01,	0.01,
            1,	-0.1,	0.1,	0.01,
            1,	-0.1,	0.5,	0.01,
            1,	-0.1,	1,	0.01,
            1,	-0.1,	5,	0.01,
            1,	-0.1,	10,	0.01,
            1,	-0.01,	0.01,	0.1,
            1,	-0.01,	0.1,	0.1,
            1,	-0.01,	0.5,	0.1,
            1,	-0.01,	1,	0.1,
            1,	-0.01,	5,	0.1,
            1,	-0.01,	10,	0.1,
            1,	-0.001,	0.01,	0.001,
            1,	-0.001,	0.1,	0.001,
            1,	-0.001,	0.5,	0.001,
            1,	-0.001,	1,	0.001,
            1,	-0.001,	5,	0.001,
            1,	-0.001,	10,	0.001,

            1,	0.01,	0.01,	-0.01,
            1,	0.01,	0.1,	-0.01,
            1,	0.01,	0.5,	-0.01,
            1,	0.01,	1,	-0.01,
            1,	0.01,	5,	-0.01,
            1,	0.01,	10,	-0.01,
            1,	0.1,	0.01,	-0.01,
            1,	0.1,	0.1,	-0.01,
            1,	0.1,	0.5,	-0.01,
            1,	0.1,	1,	-0.01,
            1,	0.1,	5,	-0.01,
            1,	0.1,	10,	-0.01,
            1,	0.01,	0.01,	-0.1,
            1,	0.01,	0.1,	-0.1,
            1,	0.01,	0.5,	-0.1,
            1,	0.01,	1,	-0.1,
            1,	0.01,	5,	-0.1,
            1,	0.01,	10,	-0.1,
            1,	0.001,	0.01,	-0.001,
            1,	0.001,	0.1,	-0.001,
            1,	0.001,	0.5,	-0.001,
            1,	0.001,	1,	-0.001,
            1,	0.001,	5,	-0.001,
            1,	0.001,	10,	-0.001,


            1,	-0.01,	0.01,	-0.01,
            1,	-0.01,	0.1,	-0.01,
            1,	-0.01,	0.5,	-0.01,
            1,	-0.01,	1,	-0.01,
            1,	-0.01,	5,	-0.01,
            1,	-0.01,	10,	-0.01,
            1,	-0.1,	0.01,	-0.01,
            1,	-0.1,	0.1,	-0.01,
            1,	-0.1,	0.5,	-0.01,
            1,	-0.1,	1,	-0.01,
            1,	-0.1,	5,	-0.01,
            1,	-0.1,	10,	-0.01,
            1,	-0.01,	0.01,	-0.1,
            1,	-0.01,	0.1,	-0.1,
            1,	-0.01,	0.5,	-0.1,
            1,	-0.01,	1,	-0.1,
            1,	-0.01,	5,	-0.1,
            1,	-0.01,	10,	-0.1,
            1,	-0.001,	0.01,	-0.001,
            1,	-0.001,	0.1,	-0.001,
            1,	-0.001,	0.5,	-0.001,
            1,	-0.001,	1,	-0.001,
            1,	-0.001,	5,	-0.001,
            1,	-0.001,	10,	-0.001, 


            0.01,	0.01,	0.001,	0.01,
            0.01,	0.01,	0.1,	0.01,
            0.01,	0.01,	0.5,	0.01,
            0.1,	0.01,	0.01,	0.01,
            0.1,	0.01,	0.1,	0.01,
            0.1,	0.01,	0.5,	0.01,
            0.5,	0.01,	0.01,	0.01,
            0.5,	0.01,	0.1,	0.01,
            0.5,	0.01,	0.5,	0.01,
            0.01,	0.1,	0.01,	0.1,
            0.01,	0.1,	0.1,	0.1,
            0.01,	0.1,	0.5,	0.1,
            0.1,	0.1,	0.01,	0.1,
            0.1,	0.1,	0.1,	0.1,
            0.1,	0.1,	0.5,	0.1,
            0.5,	0.1,	0.01,	0.1,
            0.5,	0.1,	0.1,	0.1,
            0.5,	0.1,	0.5,	0.1,
            0.01,	0.1,	0.01,	0.01,
            0.01,	0.1,	0.1,	0.01,
            0.01,	0.1,	0.5,	0.01,
            0.1,	0.1,	0.01,	0.01,
            0.1,	0.1,	0.1,	0.01,
            0.1,	0.1,	0.5,	0.01,
            0.5,	0.1,	0.01,	0.01,
            0.5,	0.1,	0.1,	0.01,
            0.5,	0.1,	0.5,	0.01,
            0.01,	0.1,	0.01,	0.01,
            0.01,	0.1,	0.1,	0.01,
            0.01,	0.1,	0.5,	0.01,
            0.1,	0.1,	0.01,	0.01,
            0.1,	0.1,	0.1,	0.01,
            0.1,	0.1,	0.5,	0.01,
            0.5,	0.1,	0.01,	0.01,
            0.5,	0.1,	0.1,	0.01,
            0.5,	0.1,	0.5,	0.01,
            0.01,	-0.01,	0.01,	-0.01,
            0.01,	-0.01,	0.1,	-0.01,
            0.01,	-0.01,	0.5,	-0.01,
            0.1,	-0.01,	0.01,	-0.01,
            0.1,	-0.01,	0.1,	-0.01,
            0.1,	-0.01,	0.5,	-0.01,
            0.5,	-0.01,	0.01,	-0.01,
            0.5,	-0.01,	0.1,	-0.01,
            0.5,	-0.01,	0.5,	-0.01,
            0.01,	-0.1,	0.01,	-0.1,
            0.01,	-0.1,	0.1,	-0.1,
            0.01,	-0.1,	0.5,	-0.1,
            0.1,	-0.1,	0.01,	-0.1,
            0.1,	-0.1,	0.1,	-0.1,
            0.1,	-0.1,	0.5,	-0.1,
            0.5,	-0.1,	0.01,	-0.1,
            0.5,	-0.1,	0.1,	-0.1,
            0.5,	-0.1,	0.5,	-0.1,
            0.01,	-0.1,	0.01,	-0.01,
            0.01,	-0.1,	0.1,	-0.01,
            0.01,	-0.1,	0.5,	-0.01,
            0.1,	-0.1,	0.01,	-0.01,
            0.1,	-0.1,	0.1,	-0.01,
            0.1,	-0.1,	0.5,	-0.01,
            0.5,	-0.1,	0.01,	-0.01,
            0.5,	-0.1,	0.1,	-0.01,
            0.5,	-0.1,	0.5,	-0.01,
            0.01,	-0.1,	0.01,	-0.01,
            0.01,	-0.1,	0.1,	-0.01,
            0.01,	-0.1,	0.5,	-0.01,
            0.1,	-0.1,	0.01,	-0.01,
            0.1,	-0.1,	0.1,	-0.01,
            0.1,	-0.1,	0.5,	-0.01,
            0.5,	-0.1,	0.01,	-0.01,
            0.5,	-0.1,	0.1,	-0.01,
            0.5,	-0.1,	0.5,	-0.01,
            0.01,	0.01,	0.01,	-0.01,
            0.01,	0.01,	0.1,	-0.01,
            0.01,	0.01,	0.5,	-0.01,
            0.1,	0.01,	0.01,	-0.01,
            0.1,	0.01,	0.1,	-0.01,
            0.1,	0.01,	0.5,	-0.01,
            0.5,	0.01,	0.01,	-0.01,
            0.5,	0.01,	0.1,	-0.01,
            0.5,	0.01,	0.5,	-0.01,
            0.01,	0.1,	0.01,	-0.1,
            0.01,	0.1,	0.1,	-0.1,
            0.01,	0.1,	0.5,	-0.1,
            0.1,	0.1,	0.01,	-0.1,
            0.1,	0.1,	0.1,	-0.1,
            0.1,	0.1,	0.5,	-0.1,
            0.5,	0.1,	0.01,	-0.1,
            0.5,	0.1,	0.1,	-0.1,
            0.5,	0.1,	0.5,	-0.1,
            0.01,	0.1,	0.01,	-0.01,
            0.01,	0.1,	0.1,	-0.01,
            0.01,	0.1,	0.5,	-0.01,
            0.1,	0.1,	0.01,	-0.01,
            0.1,	0.1,	0.1,	-0.01,
            0.1,	0.1,	0.5,	-0.01,
            0.5,	0.1,	0.01,	-0.01,
            0.5,	0.1,	0.1,	-0.01,
            0.5,	0.1,	0.5,	-0.01,
            0.01,	0.1,	0.01,	-0.01,
            0.01,	0.1,	0.1,	-0.01,
            0.01,	0.1,	0.5,	-0.01,
            0.1,	0.1,	0.01,	-0.01,
            0.1,	0.1,	0.1,	-0.01,
            0.1,	0.1,	0.5,	-0.01,
            0.5,	0.1,	0.01,	-0.01,
            0.5,	0.1,	0.1,	-0.01,
            0.5,	0.1,	0.5,	-0.01,
            0.01,	-0.01,	0.01,	0.01,
            0.01,	-0.01,	0.1,	0.01,
            0.01,	-0.01,	0.5,	0.01,
            0.1,	-0.01,	0.01,	0.01,
            0.1,	-0.01,	0.1,	0.01,
            0.1,	-0.01,	0.5,	0.01,
            0.5,	-0.01,	0.01,	0.01,
            0.5,	-0.01,	0.1,	0.01,
            0.5,	-0.01,	0.5,	0.01,
            0.01,	-0.1,	0.01,	0.1,
            0.01,	-0.1,	0.1,	0.1,
            0.01,	-0.1,	0.5,	0.1,
            0.1,	-0.1,	0.01,	0.1,
            0.1,	-0.1,	0.1,	0.1,
            0.1,	-0.1,	0.5,	0.1,
            0.5,	-0.1,	0.01,	0.1,
            0.5,	-0.1,	0.1,	0.1,
            0.5,	-0.1,	0.5,	0.1,
            0.01,	-0.1,	0.01,	0.01,
            0.01,	-0.1,	0.1,	0.01,
            0.01,	-0.1,	0.5,	0.01,
            0.1,	-0.1,	0.01,	0.01,
            0.1,	-0.1,	0.1,	0.01,
            0.1,	-0.1,	0.5,	0.01,
            0.5,	-0.1,	0.01,	0.01,
            0.5,	-0.1,	0.1,	0.01,
            0.5,	-0.1,	0.5,	0.01,
            0.01,	-0.1,	0.01,	0.01,
            0.01,	-0.1,	0.1,	0.01,
            0.01,	-0.1,	0.5,	0.01,
            0.1,	-0.1,	0.01,	0.01,
            0.1,	-0.1,	0.1,	0.01,
            0.1,	-0.1,	0.5,	0.01,
            0.5,	-0.1,	0.01,	0.01,
            0.5,	-0.1,	0.1,	0.01,
            0.5,	-0.1,	0.5,	0.01
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/4, 4, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 5)
         result_matrix[,1:4] <- p_starting
      }

      if(MODEL == "BM_linear_breakpoint"){
         p_matrix <- c(
            0.0001,	0.0001,	20,	0.0001,
            0.1,	0.0001,	20,	0.0001,
            1,	0.0001,	20,	0.0001,
            10,	0.0001,	20,	0.0001,
            100,	0.0001,	20,	0.0001,
            0.0001,	0.01,	20,	0.0001,
            0.1,	0.01,	20,	0.0001,
            1,	0.01,	20,	0.0001,
            10,	0.01,	20,	0.0001,
            100,	0.01,	20,	0.0001,
            0.0001,	0.1,	20,	0.0001,
            0.1,	0.1,	20,	0.0001,
            1,	0.1,	20,	0.0001,
            10,	0.1,	20,	0.0001,
            100,	0.1,	20,	0.0001,
            0.0001,	1,	20,	0.0001,
            0.1,	1,	20,	0.0001,
            1,	1,	20,	0.0001,
            10,	1,	20,	0.0001,
            100,	1,	20,	0.0001,
            0.0001,	-0.0001,	20,	0.0001,
            0.1,	-0.0001,	20,	0.0001,
            1,	-0.0001,	20,	0.0001,
            10,	-0.0001,	20,	0.0001,
            100,	-0.0001,	20,	0.0001,
            0.0001,	-0.01,	20,	0.0001,
            0.1,	-0.01,	20,	0.0001,
            1,	-0.01,	20,	0.0001,
            10,	-0.01,	20,	0.0001,
            100,	-0.01,	20,	0.0001,
            0.0001,	-0.1,	20,	0.0001,
            0.1,	-0.1,	20,	0.0001,
            1,	-0.1,	20,	0.0001,
            10,	-0.1,	20,	0.0001,
            100,	-0.1,	20,	0.0001,
            0.0001,	-1,	20,	0.0001,
            0.1,	-1,	20,	0.0001,
            1,	-1,	20,	0.0001,
            10,	-1,	20,	0.0001,
            100,	-1,	20,	0.0001,
            0.0001,	0.0001,	20,	0.01,
            0.1,	0.0001,	20,	0.01,
            1,	0.0001,	20,	0.01,
            10,	0.0001,	20,	0.01,
            100,	0.0001,	20,	0.01,
            0.0001,	0.01,	20,	0.01,
            0.1,	0.01,	20,	0.01,
            1,	0.01,	20,	0.01,
            10,	0.01,	20,	0.01,
            100,	0.01,	20,	0.01,
            0.0001,	0.1,	20,	0.01,
            0.1,	0.1,	20,	0.01,
            1,	0.1,	20,	0.01,
            10,	0.1,	20,	0.01,
            100,	0.1,	20,	0.01,
            0.0001,	1,	20,	0.01,
            0.1,	1,	20,	0.01,
            1,	1,	20,	0.01,
            10,	1,	20,	0.01,
            100,	1,	20,	0.01,
            0.0001,	-0.0001,	20,	0.01,
            0.1,	-0.0001,	20,	0.01,
            1,	-0.0001,	20,	0.01,
            10,	-0.0001,	20,	0.01,
            100,	-0.0001,	20,	0.01,
            0.0001,	-0.01,	20,	0.01,
            0.1,	-0.01,	20,	0.01,
            1,	-0.01,	20,	0.01,
            10,	-0.01,	20,	0.01,
            100,	-0.01,	20,	0.01,
            0.0001,	-0.1,	20,	0.01,
            0.1,	-0.1,	20,	0.01,
            1,	-0.1,	20,	0.01,
            10,	-0.1,	20,	0.01,
            100,	-0.1,	20,	0.01,
            0.0001,	-1,	20,	0.01,
            0.1,	-1,	20,	0.01,
            1,	-1,	20,	0.01,
            10,	-1,	20,	0.01,
            100,	-1,	20,	0.01,
            0.0001,	0.0001,	20,	0.1,
            0.1,	0.0001,	20,	0.1,
            1,	0.0001,	20,	0.1,
            10,	0.0001,	20,	0.1,
            100,	0.0001,	20,	0.1,
            0.0001,	0.01,	20,	0.1,
            0.1,	0.01,	20,	0.1,
            1,	0.01,	20,	0.1,
            10,	0.01,	20,	0.1,
            100,	0.01,	20,	0.1,
            0.0001,	0.1,	20,	0.1,
            0.1,	0.1,	20,	0.1,
            1,	0.1,	20,	0.1,
            10,	0.1,	20,	0.1,
            100,	0.1,	20,	0.1,
            0.0001,	1,	20,	0.1,
            0.1,	1,	20,	0.1,
            1,	1,	20,	0.1,
            10,	1,	20,	0.1,
            100,	1,	20,	0.1,
            0.0001,	-0.0001,	20,	0.1,
            0.1,	-0.0001,	20,	0.1,
            1,	-0.0001,	20,	0.1,
            10,	-0.0001,	20,	0.1,
            100,	-0.0001,	20,	0.1,
            0.0001,	-0.01,	20,	0.1,
            0.1,	-0.01,	20,	0.1,
            1,	-0.01,	20,	0.1,
            10,	-0.01,	20,	0.1,
            100,	-0.01,	20,	0.1,
            0.0001,	-0.1,	20,	0.1,
            0.1,	-0.1,	20,	0.1,
            1,	-0.1,	20,	0.1,
            10,	-0.1,	20,	0.1,
            100,	-0.1,	20,	0.1,
            0.0001,	-1,	20,	0.1,
            0.1,	-1,	20,	0.1,
            1,	-1,	20,	0.1,
            10,	-1,	20,	0.1,
            100,	-1,	20,	0.1,
            0.0001,	0.0001,	20,	0.0001,
            0.1,	0.0001,	20,	0.0001,
            1,	0.0001,	20,	0.0001,
            10,	0.0001,	20,	0.0001,
            100,	0.0001,	20,	0.0001,
            0.0001,	0.01,	20,	0.0001,
            0.1,	0.01,	20,	0.0001,
            1,	0.01,	20,	0.0001,
            10,	0.01,	20,	0.0001,
            100,	0.01,	20,	0.0001,
            0.0001,	0.1,	20,	0.0001,
            0.1,	0.1,	20,	0.0001,
            1,	0.1,	20,	0.0001,
            10,	0.1,	20,	0.0001,
            100,	0.1,	20,	0.0001,
            0.0001,	1,	20,	0.0001,
            0.1,	1,	20,	0.0001,
            1,	1,	20,	0.0001,
            10,	1,	20,	0.0001,
            100,	1,	20,	0.0001,
            0.0001,	-0.0001,	20,	0.0001,
            0.1,	-0.0001,	20,	0.0001,
            1,	-0.0001,	20,	0.0001,
            10,	-0.0001,	20,	0.0001,
            100,	-0.0001,	20,	0.0001,
            0.0001,	-0.01,	20,	0.0001,
            0.1,	-0.01,	20,	0.0001,
            1,	-0.01,	20,	0.0001,
            10,	-0.01,	20,	0.0001,
            100,	-0.01,	20,	0.0001,
            0.0001,	-0.1,	20,	0.0001,
            0.1,	-0.1,	20,	0.0001,
            1,	-0.1,	20,	0.0001,
            10,	-0.1,	20,	0.0001,
            100,	-0.1,	20,	0.0001,
            0.0001,	-1,	20,	0.0001,
            0.1,	-1,	20,	0.0001,
            1,	-1,	20,	0.0001,
            10,	-1,	20,	0.0001,
            100,	-1,	20,	0.0001,
            0.0001,	0.0001,	20,	-0.0001,
            0.1,	0.0001,	20,	-0.0001,
            1,	0.0001,	20,	-0.0001,
            10,	0.0001,	20,	-0.0001,
            100,	0.0001,	20,	-0.0001,
            0.0001,	0.01,	20,	-0.0001,
            0.1,	0.01,	20,	-0.0001,
            1,	0.01,	20,	-0.0001,
            10,	0.01,	20,	-0.0001,
            100,	0.01,	20,	-0.0001,
            0.0001,	0.1,	20,	-0.0001,
            0.1,	0.1,	20,	-0.0001,
            1,	0.1,	20,	-0.0001,
            10,	0.1,	20,	-0.0001,
            100,	0.1,	20,	-0.0001,
            0.0001,	1,	20,	-0.0001,
            0.1,	1,	20,	-0.0001,
            1,	1,	20,	-0.0001,
            10,	1,	20,	-0.0001,
            100,	1,	20,	-0.0001,
            0.0001,	-0.0001,	20,	-0.0001,
            0.1,	-0.0001,	20,	-0.0001,
            1,	-0.0001,	20,	-0.0001,
            10,	-0.0001,	20,	-0.0001,
            100,	-0.0001,	20,	-0.0001,
            0.0001,	-0.01,	20,	-0.0001,
            0.1,	-0.01,	20,	-0.0001,
            1,	-0.01,	20,	-0.0001,
            10,	-0.01,	20,	-0.0001,
            100,	-0.01,	20,	-0.0001,
            0.0001,	-0.1,	20,	-0.0001,
            0.1,	-0.1,	20,	-0.0001,
            1,	-0.1,	20,	-0.0001,
            10,	-0.1,	20,	-0.0001,
            100,	-0.1,	20,	-0.0001,
            0.0001,	-1,	20,	-0.0001,
            0.1,	-1,	20,	-0.0001,
            1,	-1,	20,	-0.0001,
            10,	-1,	20,	-0.0001,
            100,	-1,	20,	-0.0001,
            0.0001,	0.0001,	20,	-0.01,
            0.1,	0.0001,	20,	-0.01,
            1,	0.0001,	20,	-0.01,
            10,	0.0001,	20,	-0.01,
            100,	0.0001,	20,	-0.01,
            0.0001,	0.01,	20,	-0.01,
            0.1,	0.01,	20,	-0.01,
            1,	0.01,	20,	-0.01,
            10,	0.01,	20,	-0.01,
            100,	0.01,	20,	-0.01,
            0.0001,	0.1,	20,	-0.01,
            0.1,	0.1,	20,	-0.01,
            1,	0.1,	20,	-0.01,
            10,	0.1,	20,	-0.01,
            100,	0.1,	20,	-0.01,
            0.0001,	1,	20,	-0.01,
            0.1,	1,	20,	-0.01,
            1,	1,	20,	-0.01,
            10,	1,	20,	-0.01,
            100,	1,	20,	-0.01,
            0.0001,	-0.0001,	20,	-0.01,
            0.1,	-0.0001,	20,	-0.01,
            1,	-0.0001,	20,	-0.01,
            10,	-0.0001,	20,	-0.01,
            100,	-0.0001,	20,	-0.01,
            0.0001,	-0.01,	20,	-0.01,
            0.1,	-0.01,	20,	-0.01,
            1,	-0.01,	20,	-0.01,
            10,	-0.01,	20,	-0.01,
            100,	-0.01,	20,	-0.01,
            0.0001,	-0.1,	20,	-0.01,
            0.1,	-0.1,	20,	-0.01,
            1,	-0.1,	20,	-0.01,
            10,	-0.1,	20,	-0.01,
            100,	-0.1,	20,	-0.01,
            0.0001,	-1,	20,	-0.01,
            0.1,	-1,	20,	-0.01,
            1,	-1,	20,	-0.01,
            10,	-1,	20,	-0.01,
            100,	-1,	20,	-0.01,
            0.0001,	0.0001,	20,	-0.1,
            0.1,	0.0001,	20,	-0.1,
            1,	0.0001,	20,	-0.1,
            10,	0.0001,	20,	-0.1,
            100,	0.0001,	20,	-0.1,
            0.0001,	0.01,	20,	-0.1,
            0.1,	0.01,	20,	-0.1,
            1,	0.01,	20,	-0.1,
            10,	0.01,	20,	-0.1,
            100,	0.01,	20,	-0.1,
            0.0001,	0.1,	20,	-0.1,
            0.1,	0.1,	20,	-0.1,
            1,	0.1,	20,	-0.1,
            10,	0.1,	20,	-0.1,
            100,	0.1,	20,	-0.1,
            0.0001,	1,	20,	-0.1,
            0.1,	1,	20,	-0.1,
            1,	1,	20,	-0.1,
            10,	1,	20,	-0.1,
            100,	1,	20,	-0.1,
            0.0001,	-0.0001,	20,	-0.1,
            0.1,	-0.0001,	20,	-0.1,
            1,	-0.0001,	20,	-0.1,
            10,	-0.0001,	20,	-0.1,
            100,	-0.0001,	20,	-0.1,
            0.0001,	-0.01,	20,	-0.1,
            0.1,	-0.01,	20,	-0.1,
            1,	-0.01,	20,	-0.1,
            10,	-0.01,	20,	-0.1,
            100,	-0.01,	20,	-0.1,
            0.0001,	-0.1,	20,	-0.1,
            0.1,	-0.1,	20,	-0.1,
            1,	-0.1,	20,	-0.1,
            10,	-0.1,	20,	-0.1,
            100,	-0.1,	20,	-0.1,
            0.0001,	-1,	20,	-0.1,
            0.1,	-1,	20,	-0.1,
            1,	-1,	20,	-0.1,
            10,	-1,	20,	-0.1,
            100,	-1,	20,	-0.1,
            0.0001,	0.0001,	20,	-0.0001,
            0.1,	0.0001,	20,	-0.0001,
            1,	0.0001,	20,	-0.0001,
            10,	0.0001,	20,	-0.0001,
            100,	0.0001,	20,	-0.0001,
            0.0001,	0.01,	20,	-0.0001,
            0.1,	0.01,	20,	-0.0001,
            1,	0.01,	20,	-0.0001,
            10,	0.01,	20,	-0.0001,
            100,	0.01,	20,	-0.0001,
            0.0001,	0.1,	20,	-0.0001,
            0.1,	0.1,	20,	-0.0001,
            1,	0.1,	20,	-0.0001,
            10,	0.1,	20,	-0.0001,
            100,	0.1,	20,	-0.0001,
            0.0001,	1,	20,	-0.0001,
            0.1,	1,	20,	-0.0001,
            1,	1,	20,	-0.0001,
            10,	1,	20,	-0.0001,
            100,	1,	20,	-0.0001,
            0.0001,	-0.0001,	20,	-0.0001,
            0.1,	-0.0001,	20,	-0.0001,
            1,	-0.0001,	20,	-0.0001,
            10,	-0.0001,	20,	-0.0001,
            100,	-0.0001,	20,	-0.0001,
            0.0001,	-0.01,	20,	-0.0001,
            0.1,	-0.01,	20,	-0.0001,
            1,	-0.01,	20,	-0.0001,
            10,	-0.01,	20,	-0.0001,
            100,	-0.01,	20,	-0.0001,
            0.0001,	-0.1,	20,	-0.0001,
            0.1,	-0.1,	20,	-0.0001,
            1,	-0.1,	20,	-0.0001,
            10,	-0.1,	20,	-0.0001,
            100,	-0.1,	20,	-0.0001,
            0.0001,	-1,	20,	-0.0001,
            0.1,	-1,	20,	-0.0001,
            1,	-1,	20,	-0.0001,
            10,	-1,	20,	-0.0001,
            100,	-1,	20,	-0.0001,
            0.0001,	0.0001,	30,	0.0001,
            0.1,	0.0001,	30,	0.0001,
            1,	0.0001,	30,	0.0001,
            10,	0.0001,	30,	0.0001,
            100,	0.0001,	30,	0.0001,
            0.0001,	0.01,	30,	0.0001,
            0.1,	0.01,	30,	0.0001,
            1,	0.01,	30,	0.0001,
            10,	0.01,	30,	0.0001,
            100,	0.01,	30,	0.0001,
            0.0001,	0.1,	30,	0.0001,
            0.1,	0.1,	30,	0.0001,
            1,	0.1,	30,	0.0001,
            10,	0.1,	30,	0.0001,
            100,	0.1,	30,	0.0001,
            0.0001,	1,	30,	0.0001,
            0.1,	1,	30,	0.0001,
            1,	1,	30,	0.0001,
            10,	1,	30,	0.0001,
            100,	1,	30,	0.0001,
            0.0001,	-0.0001,	30,	0.0001,
            0.1,	-0.0001,	30,	0.0001,
            1,	-0.0001,	30,	0.0001,
            10,	-0.0001,	30,	0.0001,
            100,	-0.0001,	30,	0.0001,
            0.0001,	-0.01,	30,	0.0001,
            0.1,	-0.01,	30,	0.0001,
            1,	-0.01,	30,	0.0001,
            10,	-0.01,	30,	0.0001,
            100,	-0.01,	30,	0.0001,
            0.0001,	-0.1,	30,	0.0001,
            0.1,	-0.1,	30,	0.0001,
            1,	-0.1,	30,	0.0001,
            10,	-0.1,	30,	0.0001,
            100,	-0.1,	30,	0.0001,
            0.0001,	-1,	30,	0.0001,
            0.1,	-1,	30,	0.0001,
            1,	-1,	30,	0.0001,
            10,	-1,	30,	0.0001,
            100,	-1,	30,	0.0001,
            0.0001,	0.0001,	30,	0.01,
            0.1,	0.0001,	30,	0.01,
            1,	0.0001,	30,	0.01,
            10,	0.0001,	30,	0.01,
            100,	0.0001,	30,	0.01,
            0.0001,	0.01,	30,	0.01,
            0.1,	0.01,	30,	0.01,
            1,	0.01,	30,	0.01,
            10,	0.01,	30,	0.01,
            100,	0.01,	30,	0.01,
            0.0001,	0.1,	30,	0.01,
            0.1,	0.1,	30,	0.01,
            1,	0.1,	30,	0.01,
            10,	0.1,	30,	0.01,
            100,	0.1,	30,	0.01,
            0.0001,	1,	30,	0.01,
            0.1,	1,	30,	0.01,
            1,	1,	30,	0.01,
            10,	1,	30,	0.01,
            100,	1,	30,	0.01,
            0.0001,	-0.0001,	30,	0.01,
            0.1,	-0.0001,	30,	0.01,
            1,	-0.0001,	30,	0.01,
            10,	-0.0001,	30,	0.01,
            100,	-0.0001,	30,	0.01,
            0.0001,	-0.01,	30,	0.01,
            0.1,	-0.01,	30,	0.01,
            1,	-0.01,	30,	0.01,
            10,	-0.01,	30,	0.01,
            100,	-0.01,	30,	0.01,
            0.0001,	-0.1,	30,	0.01,
            0.1,	-0.1,	30,	0.01,
            1,	-0.1,	30,	0.01,
            10,	-0.1,	30,	0.01,
            100,	-0.1,	30,	0.01,
            0.0001,	-1,	30,	0.01,
            0.1,	-1,	30,	0.01,
            1,	-1,	30,	0.01,
            10,	-1,	30,	0.01,
            100,	-1,	30,	0.01,
            0.0001,	0.0001,	30,	0.1,
            0.1,	0.0001,	30,	0.1,
            1,	0.0001,	30,	0.1,
            10,	0.0001,	30,	0.1,
            100,	0.0001,	30,	0.1,
            0.0001,	0.01,	30,	0.1,
            0.1,	0.01,	30,	0.1,
            1,	0.01,	30,	0.1,
            10,	0.01,	30,	0.1,
            100,	0.01,	30,	0.1,
            0.0001,	0.1,	30,	0.1,
            0.1,	0.1,	30,	0.1,
            1,	0.1,	30,	0.1,
            10,	0.1,	30,	0.1,
            100,	0.1,	30,	0.1,
            0.0001,	1,	30,	0.1,
            0.1,	1,	30,	0.1,
            1,	1,	30,	0.1,
            10,	1,	30,	0.1,
            100,	1,	30,	0.1,
            0.0001,	-0.0001,	30,	0.1,
            0.1,	-0.0001,	30,	0.1,
            1,	-0.0001,	30,	0.1,
            10,	-0.0001,	30,	0.1,
            100,	-0.0001,	30,	0.1,
            0.0001,	-0.01,	30,	0.1,
            0.1,	-0.01,	30,	0.1,
            1,	-0.01,	30,	0.1,
            10,	-0.01,	30,	0.1,
            100,	-0.01,	30,	0.1,
            0.0001,	-0.1,	30,	0.1,
            0.1,	-0.1,	30,	0.1,
            1,	-0.1,	30,	0.1,
            10,	-0.1,	30,	0.1,
            100,	-0.1,	30,	0.1,
            0.0001,	-1,	30,	0.1,
            0.1,	-1,	30,	0.1,
            1,	-1,	30,	0.1,
            10,	-1,	30,	0.1,
            100,	-1,	30,	0.1,
            0.0001,	0.0001,	30,	0.0001,
            0.1,	0.0001,	30,	0.0001,
            1,	0.0001,	30,	0.0001,
            10,	0.0001,	30,	0.0001,
            100,	0.0001,	30,	0.0001,
            0.0001,	0.01,	30,	0.0001,
            0.1,	0.01,	30,	0.0001,
            1,	0.01,	30,	0.0001,
            10,	0.01,	30,	0.0001,
            100,	0.01,	30,	0.0001,
            0.0001,	0.1,	30,	0.0001,
            0.1,	0.1,	30,	0.0001,
            1,	0.1,	30,	0.0001,
            10,	0.1,	30,	0.0001,
            100,	0.1,	30,	0.0001,
            0.0001,	1,	30,	0.0001,
            0.1,	1,	30,	0.0001,
            1,	1,	30,	0.0001,
            10,	1,	30,	0.0001,
            100,	1,	30,	0.0001,
            0.0001,	-0.0001,	30,	0.0001,
            0.1,	-0.0001,	30,	0.0001,
            1,	-0.0001,	30,	0.0001,
            10,	-0.0001,	30,	0.0001,
            100,	-0.0001,	30,	0.0001,
            0.0001,	-0.01,	30,	0.0001,
            0.1,	-0.01,	30,	0.0001,
            1,	-0.01,	30,	0.0001,
            10,	-0.01,	30,	0.0001,
            100,	-0.01,	30,	0.0001,
            0.0001,	-0.1,	30,	0.0001,
            0.1,	-0.1,	30,	0.0001,
            1,	-0.1,	30,	0.0001,
            10,	-0.1,	30,	0.0001,
            100,	-0.1,	30,	0.0001,
            0.0001,	-1,	30,	0.0001,
            0.1,	-1,	30,	0.0001,
            1,	-1,	30,	0.0001,
            10,	-1,	30,	0.0001,
            100,	-1,	30,	0.0001,
            0.0001,	0.0001,	30,	-0.0001,
            0.1,	0.0001,	30,	-0.0001,
            1,	0.0001,	30,	-0.0001,
            10,	0.0001,	30,	-0.0001,
            100,	0.0001,	30,	-0.0001,
            0.0001,	0.01,	30,	-0.0001,
            0.1,	0.01,	30,	-0.0001,
            1,	0.01,	30,	-0.0001,
            10,	0.01,	30,	-0.0001,
            100,	0.01,	30,	-0.0001,
            0.0001,	0.1,	30,	-0.0001,
            0.1,	0.1,	30,	-0.0001,
            1,	0.1,	30,	-0.0001,
            10,	0.1,	30,	-0.0001,
            100,	0.1,	30,	-0.0001,
            0.0001,	1,	30,	-0.0001,
            0.1,	1,	30,	-0.0001,
            1,	1,	30,	-0.0001,
            10,	1,	30,	-0.0001,
            100,	1,	30,	-0.0001,
            0.0001,	-0.0001,	30,	-0.0001,
            0.1,	-0.0001,	30,	-0.0001,
            1,	-0.0001,	30,	-0.0001,
            10,	-0.0001,	30,	-0.0001,
            100,	-0.0001,	30,	-0.0001,
            0.0001,	-0.01,	30,	-0.0001,
            0.1,	-0.01,	30,	-0.0001,
            1,	-0.01,	30,	-0.0001,
            10,	-0.01,	30,	-0.0001,
            100,	-0.01,	30,	-0.0001,
            0.0001,	-0.1,	30,	-0.0001,
            0.1,	-0.1,	30,	-0.0001,
            1,	-0.1,	30,	-0.0001,
            10,	-0.1,	30,	-0.0001,
            100,	-0.1,	30,	-0.0001,
            0.0001,	-1,	30,	-0.0001,
            0.1,	-1,	30,	-0.0001,
            1,	-1,	30,	-0.0001,
            10,	-1,	30,	-0.0001,
            100,	-1,	30,	-0.0001,
            0.0001,	0.0001,	30,	-0.01,
            0.1,	0.0001,	30,	-0.01,
            1,	0.0001,	30,	-0.01,
            10,	0.0001,	30,	-0.01,
            100,	0.0001,	30,	-0.01,
            0.0001,	0.01,	30,	-0.01,
            0.1,	0.01,	30,	-0.01,
            1,	0.01,	30,	-0.01,
            10,	0.01,	30,	-0.01,
            100,	0.01,	30,	-0.01,
            0.0001,	0.1,	30,	-0.01,
            0.1,	0.1,	30,	-0.01,
            1,	0.1,	30,	-0.01,
            10,	0.1,	30,	-0.01,
            100,	0.1,	30,	-0.01,
            0.0001,	1,	30,	-0.01,
            0.1,	1,	30,	-0.01,
            1,	1,	30,	-0.01,
            10,	1,	30,	-0.01,
            100,	1,	30,	-0.01,
            0.0001,	-0.0001,	30,	-0.01,
            0.1,	-0.0001,	30,	-0.01,
            1,	-0.0001,	30,	-0.01,
            10,	-0.0001,	30,	-0.01,
            100,	-0.0001,	30,	-0.01,
            0.0001,	-0.01,	30,	-0.01,
            0.1,	-0.01,	30,	-0.01,
            1,	-0.01,	30,	-0.01,
            10,	-0.01,	30,	-0.01,
            100,	-0.01,	30,	-0.01,
            0.0001,	-0.1,	30,	-0.01,
            0.1,	-0.1,	30,	-0.01,
            1,	-0.1,	30,	-0.01,
            10,	-0.1,	30,	-0.01,
            100,	-0.1,	30,	-0.01,
            0.0001,	-1,	30,	-0.01,
            0.1,	-1,	30,	-0.01,
            1,	-1,	30,	-0.01,
            10,	-1,	30,	-0.01,
            100,	-1,	30,	-0.01,
            0.0001,	0.0001,	30,	-0.1,
            0.1,	0.0001,	30,	-0.1,
            1,	0.0001,	30,	-0.1,
            10,	0.0001,	30,	-0.1,
            100,	0.0001,	30,	-0.1,
            0.0001,	0.01,	30,	-0.1,
            0.1,	0.01,	30,	-0.1,
            1,	0.01,	30,	-0.1,
            10,	0.01,	30,	-0.1,
            100,	0.01,	30,	-0.1,
            0.0001,	0.1,	30,	-0.1,
            0.1,	0.1,	30,	-0.1,
            1,	0.1,	30,	-0.1,
            10,	0.1,	30,	-0.1,
            100,	0.1,	30,	-0.1,
            0.0001,	1,	30,	-0.1,
            0.1,	1,	30,	-0.1,
            1,	1,	30,	-0.1,
            10,	1,	30,	-0.1,
            100,	1,	30,	-0.1,
            0.0001,	-0.0001,	30,	-0.1,
            0.1,	-0.0001,	30,	-0.1,
            1,	-0.0001,	30,	-0.1,
            10,	-0.0001,	30,	-0.1,
            100,	-0.0001,	30,	-0.1,
            0.0001,	-0.01,	30,	-0.1,
            0.1,	-0.01,	30,	-0.1,
            1,	-0.01,	30,	-0.1,
            10,	-0.01,	30,	-0.1,
            100,	-0.01,	30,	-0.1,
            0.0001,	-0.1,	30,	-0.1,
            0.1,	-0.1,	30,	-0.1,
            1,	-0.1,	30,	-0.1,
            10,	-0.1,	30,	-0.1,
            100,	-0.1,	30,	-0.1,
            0.0001,	-1,	30,	-0.1,
            0.1,	-1,	30,	-0.1,
            1,	-1,	30,	-0.1,
            10,	-1,	30,	-0.1,
            100,	-1,	30,	-0.1,
            0.0001,	0.0001,	30,	-0.0001,
            0.1,	0.0001,	30,	-0.0001,
            1,	0.0001,	30,	-0.0001,
            10,	0.0001,	30,	-0.0001,
            100,	0.0001,	30,	-0.0001,
            0.0001,	0.01,	30,	-0.0001,
            0.1,	0.01,	30,	-0.0001,
            1,	0.01,	30,	-0.0001,
            10,	0.01,	30,	-0.0001,
            100,	0.01,	30,	-0.0001,
            0.0001,	0.1,	30,	-0.0001,
            0.1,	0.1,	30,	-0.0001,
            1,	0.1,	30,	-0.0001,
            10,	0.1,	30,	-0.0001,
            100,	0.1,	30,	-0.0001,
            0.0001,	1,	30,	-0.0001,
            0.1,	1,	30,	-0.0001,
            1,	1,	30,	-0.0001,
            10,	1,	30,	-0.0001,
            100,	1,	30,	-0.0001,
            0.0001,	-0.0001,	30,	-0.0001,
            0.1,	-0.0001,	30,	-0.0001,
            1,	-0.0001,	30,	-0.0001,
            10,	-0.0001,	30,	-0.0001,
            100,	-0.0001,	30,	-0.0001,
            0.0001,	-0.01,	30,	-0.0001,
            0.1,	-0.01,	30,	-0.0001,
            1,	-0.01,	30,	-0.0001,
            10,	-0.01,	30,	-0.0001,
            100,	-0.01,	30,	-0.0001,
            0.0001,	-0.1,	30,	-0.0001,
            0.1,	-0.1,	30,	-0.0001,
            1,	-0.1,	30,	-0.0001,
            10,	-0.1,	30,	-0.0001,
            100,	-0.1,	30,	-0.0001,
            0.0001,	-1,	30,	-0.0001,
            0.1,	-1,	30,	-0.0001,
            1,	-1,	30,	-0.0001,
            10,	-1,	30,	-0.0001,
            100,	-1,	30,	-0.0001,
            0.0001,	0.0001,	40,	0.0001,
            0.1,	0.0001,	40,	0.0001,
            1,	0.0001,	40,	0.0001,
            10,	0.0001,	40,	0.0001,
            100,	0.0001,	40,	0.0001,
            0.0001,	0.01,	40,	0.0001,
            0.1,	0.01,	40,	0.0001,
            1,	0.01,	40,	0.0001,
            10,	0.01,	40,	0.0001,
            100,	0.01,	40,	0.0001,
            0.0001,	0.1,	40,	0.0001,
            0.1,	0.1,	40,	0.0001,
            1,	0.1,	40,	0.0001,
            10,	0.1,	40,	0.0001,
            100,	0.1,	40,	0.0001,
            0.0001,	1,	40,	0.0001,
            0.1,	1,	40,	0.0001,
            1,	1,	40,	0.0001,
            10,	1,	40,	0.0001,
            100,	1,	40,	0.0001,
            0.0001,	-0.0001,	40,	0.0001,
            0.1,	-0.0001,	40,	0.0001,
            1,	-0.0001,	40,	0.0001,
            10,	-0.0001,	40,	0.0001,
            100,	-0.0001,	40,	0.0001,
            0.0001,	-0.01,	40,	0.0001,
            0.1,	-0.01,	40,	0.0001,
            1,	-0.01,	40,	0.0001,
            10,	-0.01,	40,	0.0001,
            100,	-0.01,	40,	0.0001,
            0.0001,	-0.1,	40,	0.0001,
            0.1,	-0.1,	40,	0.0001,
            1,	-0.1,	40,	0.0001,
            10,	-0.1,	40,	0.0001,
            100,	-0.1,	40,	0.0001,
            0.0001,	-1,	40,	0.0001,
            0.1,	-1,	40,	0.0001,
            1,	-1,	40,	0.0001,
            10,	-1,	40,	0.0001,
            100,	-1,	40,	0.0001,
            0.0001,	0.0001,	40,	0.01,
            0.1,	0.0001,	40,	0.01,
            1,	0.0001,	40,	0.01,
            10,	0.0001,	40,	0.01,
            100,	0.0001,	40,	0.01,
            0.0001,	0.01,	40,	0.01,
            0.1,	0.01,	40,	0.01,
            1,	0.01,	40,	0.01,
            10,	0.01,	40,	0.01,
            100,	0.01,	40,	0.01,
            0.0001,	0.1,	40,	0.01,
            0.1,	0.1,	40,	0.01,
            1,	0.1,	40,	0.01,
            10,	0.1,	40,	0.01,
            100,	0.1,	40,	0.01,
            0.0001,	1,	40,	0.01,
            0.1,	1,	40,	0.01,
            1,	1,	40,	0.01,
            10,	1,	40,	0.01,
            100,	1,	40,	0.01,
            0.0001,	-0.0001,	40,	0.01,
            0.1,	-0.0001,	40,	0.01,
            1,	-0.0001,	40,	0.01,
            10,	-0.0001,	40,	0.01,
            100,	-0.0001,	40,	0.01,
            0.0001,	-0.01,	40,	0.01,
            0.1,	-0.01,	40,	0.01,
            1,	-0.01,	40,	0.01,
            10,	-0.01,	40,	0.01,
            100,	-0.01,	40,	0.01,
            0.0001,	-0.1,	40,	0.01,
            0.1,	-0.1,	40,	0.01,
            1,	-0.1,	40,	0.01,
            10,	-0.1,	40,	0.01,
            100,	-0.1,	40,	0.01,
            0.0001,	-1,	40,	0.01,
            0.1,	-1,	40,	0.01,
            1,	-1,	40,	0.01,
            10,	-1,	40,	0.01,
            100,	-1,	40,	0.01,
            0.0001,	0.0001,	40,	0.1,
            0.1,	0.0001,	40,	0.1,
            1,	0.0001,	40,	0.1,
            10,	0.0001,	40,	0.1,
            100,	0.0001,	40,	0.1,
            0.0001,	0.01,	40,	0.1,
            0.1,	0.01,	40,	0.1,
            1,	0.01,	40,	0.1,
            10,	0.01,	40,	0.1,
            100,	0.01,	40,	0.1,
            0.0001,	0.1,	40,	0.1,
            0.1,	0.1,	40,	0.1,
            1,	0.1,	40,	0.1,
            10,	0.1,	40,	0.1,
            100,	0.1,	40,	0.1,
            0.0001,	1,	40,	0.1,
            0.1,	1,	40,	0.1,
            1,	1,	40,	0.1,
            10,	1,	40,	0.1,
            100,	1,	40,	0.1,
            0.0001,	-0.0001,	40,	0.1,
            0.1,	-0.0001,	40,	0.1,
            1,	-0.0001,	40,	0.1,
            10,	-0.0001,	40,	0.1,
            100,	-0.0001,	40,	0.1,
            0.0001,	-0.01,	40,	0.1,
            0.1,	-0.01,	40,	0.1,
            1,	-0.01,	40,	0.1,
            10,	-0.01,	40,	0.1,
            100,	-0.01,	40,	0.1,
            0.0001,	-0.1,	40,	0.1,
            0.1,	-0.1,	40,	0.1,
            1,	-0.1,	40,	0.1,
            10,	-0.1,	40,	0.1,
            100,	-0.1,	40,	0.1,
            0.0001,	-1,	40,	0.1,
            0.1,	-1,	40,	0.1,
            1,	-1,	40,	0.1,
            10,	-1,	40,	0.1,
            100,	-1,	40,	0.1,
            0.0001,	0.0001,	40,	0.0001,
            0.1,	0.0001,	40,	0.0001,
            1,	0.0001,	40,	0.0001,
            10,	0.0001,	40,	0.0001,
            100,	0.0001,	40,	0.0001,
            0.0001,	0.01,	40,	0.0001,
            0.1,	0.01,	40,	0.0001,
            1,	0.01,	40,	0.0001,
            10,	0.01,	40,	0.0001,
            100,	0.01,	40,	0.0001,
            0.0001,	0.1,	40,	0.0001,
            0.1,	0.1,	40,	0.0001,
            1,	0.1,	40,	0.0001,
            10,	0.1,	40,	0.0001,
            100,	0.1,	40,	0.0001,
            0.0001,	1,	40,	0.0001,
            0.1,	1,	40,	0.0001,
            1,	1,	40,	0.0001,
            10,	1,	40,	0.0001,
            100,	1,	40,	0.0001,
            0.0001,	-0.0001,	40,	0.0001,
            0.1,	-0.0001,	40,	0.0001,
            1,	-0.0001,	40,	0.0001,
            10,	-0.0001,	40,	0.0001,
            100,	-0.0001,	40,	0.0001,
            0.0001,	-0.01,	40,	0.0001,
            0.1,	-0.01,	40,	0.0001,
            1,	-0.01,	40,	0.0001,
            10,	-0.01,	40,	0.0001,
            100,	-0.01,	40,	0.0001,
            0.0001,	-0.1,	40,	0.0001,
            0.1,	-0.1,	40,	0.0001,
            1,	-0.1,	40,	0.0001,
            10,	-0.1,	40,	0.0001,
            100,	-0.1,	40,	0.0001,
            0.0001,	-1,	40,	0.0001,
            0.1,	-1,	40,	0.0001,
            1,	-1,	40,	0.0001,
            10,	-1,	40,	0.0001,
            100,	-1,	40,	0.0001,
            0.0001,	0.0001,	40,	-0.0001,
            0.1,	0.0001,	40,	-0.0001,
            1,	0.0001,	40,	-0.0001,
            10,	0.0001,	40,	-0.0001,
            100,	0.0001,	40,	-0.0001,
            0.0001,	0.01,	40,	-0.0001,
            0.1,	0.01,	40,	-0.0001,
            1,	0.01,	40,	-0.0001,
            10,	0.01,	40,	-0.0001,
            100,	0.01,	40,	-0.0001,
            0.0001,	0.1,	40,	-0.0001,
            0.1,	0.1,	40,	-0.0001,
            1,	0.1,	40,	-0.0001,
            10,	0.1,	40,	-0.0001,
            100,	0.1,	40,	-0.0001,
            0.0001,	1,	40,	-0.0001,
            0.1,	1,	40,	-0.0001,
            1,	1,	40,	-0.0001,
            10,	1,	40,	-0.0001,
            100,	1,	40,	-0.0001,
            0.0001,	-0.0001,	40,	-0.0001,
            0.1,	-0.0001,	40,	-0.0001,
            1,	-0.0001,	40,	-0.0001,
            10,	-0.0001,	40,	-0.0001,
            100,	-0.0001,	40,	-0.0001,
            0.0001,	-0.01,	40,	-0.0001,
            0.1,	-0.01,	40,	-0.0001,
            1,	-0.01,	40,	-0.0001,
            10,	-0.01,	40,	-0.0001,
            100,	-0.01,	40,	-0.0001,
            0.0001,	-0.1,	40,	-0.0001,
            0.1,	-0.1,	40,	-0.0001,
            1,	-0.1,	40,	-0.0001,
            10,	-0.1,	40,	-0.0001,
            100,	-0.1,	40,	-0.0001,
            0.0001,	-1,	40,	-0.0001,
            0.1,	-1,	40,	-0.0001,
            1,	-1,	40,	-0.0001,
            10,	-1,	40,	-0.0001,
            100,	-1,	40,	-0.0001,
            0.0001,	0.0001,	40,	-0.01,
            0.1,	0.0001,	40,	-0.01,
            1,	0.0001,	40,	-0.01,
            10,	0.0001,	40,	-0.01,
            100,	0.0001,	40,	-0.01,
            0.0001,	0.01,	40,	-0.01,
            0.1,	0.01,	40,	-0.01,
            1,	0.01,	40,	-0.01,
            10,	0.01,	40,	-0.01,
            100,	0.01,	40,	-0.01,
            0.0001,	0.1,	40,	-0.01,
            0.1,	0.1,	40,	-0.01,
            1,	0.1,	40,	-0.01,
            10,	0.1,	40,	-0.01,
            100,	0.1,	40,	-0.01,
            0.0001,	1,	40,	-0.01,
            0.1,	1,	40,	-0.01,
            1,	1,	40,	-0.01,
            10,	1,	40,	-0.01,
            100,	1,	40,	-0.01,
            0.0001,	-0.0001,	40,	-0.01,
            0.1,	-0.0001,	40,	-0.01,
            1,	-0.0001,	40,	-0.01,
            10,	-0.0001,	40,	-0.01,
            100,	-0.0001,	40,	-0.01,
            0.0001,	-0.01,	40,	-0.01,
            0.1,	-0.01,	40,	-0.01,
            1,	-0.01,	40,	-0.01,
            10,	-0.01,	40,	-0.01,
            100,	-0.01,	40,	-0.01,
            0.0001,	-0.1,	40,	-0.01,
            0.1,	-0.1,	40,	-0.01,
            1,	-0.1,	40,	-0.01,
            10,	-0.1,	40,	-0.01,
            100,	-0.1,	40,	-0.01,
            0.0001,	-1,	40,	-0.01,
            0.1,	-1,	40,	-0.01,
            1,	-1,	40,	-0.01,
            10,	-1,	40,	-0.01,
            100,	-1,	40,	-0.01,
            0.0001,	0.0001,	40,	-0.1,
            0.1,	0.0001,	40,	-0.1,
            1,	0.0001,	40,	-0.1,
            10,	0.0001,	40,	-0.1,
            100,	0.0001,	40,	-0.1,
            0.0001,	0.01,	40,	-0.1,
            0.1,	0.01,	40,	-0.1,
            1,	0.01,	40,	-0.1,
            10,	0.01,	40,	-0.1,
            100,	0.01,	40,	-0.1,
            0.0001,	0.1,	40,	-0.1,
            0.1,	0.1,	40,	-0.1,
            1,	0.1,	40,	-0.1,
            10,	0.1,	40,	-0.1,
            100,	0.1,	40,	-0.1,
            0.0001,	1,	40,	-0.1,
            0.1,	1,	40,	-0.1,
            1,	1,	40,	-0.1,
            10,	1,	40,	-0.1,
            100,	1,	40,	-0.1,
            0.0001,	-0.0001,	40,	-0.1,
            0.1,	-0.0001,	40,	-0.1,
            1,	-0.0001,	40,	-0.1,
            10,	-0.0001,	40,	-0.1,
            100,	-0.0001,	40,	-0.1,
            0.0001,	-0.01,	40,	-0.1,
            0.1,	-0.01,	40,	-0.1,
            1,	-0.01,	40,	-0.1,
            10,	-0.01,	40,	-0.1,
            100,	-0.01,	40,	-0.1,
            0.0001,	-0.1,	40,	-0.1,
            0.1,	-0.1,	40,	-0.1,
            1,	-0.1,	40,	-0.1,
            10,	-0.1,	40,	-0.1,
            100,	-0.1,	40,	-0.1,
            0.0001,	-1,	40,	-0.1,
            0.1,	-1,	40,	-0.1,
            1,	-1,	40,	-0.1,
            10,	-1,	40,	-0.1,
            100,	-1,	40,	-0.1,
            0.0001,	0.0001,	40,	-0.0001,
            0.1,	0.0001,	40,	-0.0001,
            1,	0.0001,	40,	-0.0001,
            10,	0.0001,	40,	-0.0001,
            100,	0.0001,	40,	-0.0001,
            0.0001,	0.01,	40,	-0.0001,
            0.1,	0.01,	40,	-0.0001,
            1,	0.01,	40,	-0.0001,
            10,	0.01,	40,	-0.0001,
            100,	0.01,	40,	-0.0001,
            0.0001,	0.1,	40,	-0.0001,
            0.1,	0.1,	40,	-0.0001,
            1,	0.1,	40,	-0.0001,
            10,	0.1,	40,	-0.0001,
            100,	0.1,	40,	-0.0001,
            0.0001,	1,	40,	-0.0001,
            0.1,	1,	40,	-0.0001,
            1,	1,	40,	-0.0001,
            10,	1,	40,	-0.0001,
            100,	1,	40,	-0.0001,
            0.0001,	-0.0001,	40,	-0.0001,
            0.1,	-0.0001,	40,	-0.0001,
            1,	-0.0001,	40,	-0.0001,
            10,	-0.0001,	40,	-0.0001,
            100,	-0.0001,	40,	-0.0001,
            0.0001,	-0.01,	40,	-0.0001,
            0.1,	-0.01,	40,	-0.0001,
            1,	-0.01,	40,	-0.0001,
            10,	-0.01,	40,	-0.0001,
            100,	-0.01,	40,	-0.0001,
            0.0001,	-0.1,	40,	-0.0001,
            0.1,	-0.1,	40,	-0.0001,
            1,	-0.1,	40,	-0.0001,
            10,	-0.1,	40,	-0.0001,
            100,	-0.1,	40,	-0.0001,
            0.0001,	-1,	40,	-0.0001,
            0.1,	-1,	40,	-0.0001,
            1,	-1,	40,	-0.0001,
            10,	-1,	40,	-0.0001,
            100,	-1,	40,	-0.0001
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/4, 4, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 5)
         result_matrix[,1:4] <- p_starting
      }


     if(MODEL == "BM_quadratic"){
         p_matrix <- c( #order here is b, c, a b and a may be negative
             0.000000001,	100,	3,
            0.000000001,	10,	3,
            0.000000001,	1,	3,
            0.000000001,	0.1,	3,
            0.000000001,	0.0000001,	3,
            0.000000001,	-0.1,	3,
            0.000000001,	-1,	3,
            0.000000001,	-10,	3,
            0.000000001,	-100,	3,
            0.000000001,	-1000,	3,
            0.001,	100,	3,
            0.001,	10,	3,
            0.001,	1,	3,
            0.001,	0.1,	3,
            0.001,	0.0000001,	3,
            0.001,	-0.1,	3,
            0.001,	-1,	3,
            0.001,	-10,	3,
            0.001,	-100,	3,
            0.001,	-1000,	3,
            0.01,	100,	3,
            0.01,	10,	3,
            0.01,	1,	3,
            0.01,	0.1,	3,
            0.01,	0.0000001,	3,
            0.01,	-0.1,	3,
            0.01,	-1,	3,
            0.01,	-10,	3,
            0.01,	-100,	3,
            0.01,	-1000,	3,
            0.1,	100,	3,
            0.1,	10,	3,
            0.1,	1,	3,
            0.1,	0.1,	3,
            0.1,	0.0000001,	3,
            0.1,	-0.1,	3,
            0.1,	-1,	3,
            0.1,	-10,	3,
            0.1,	-100,	3,
            0.1,	-1000,	3,
            1,	100,	3,
            1,	10,	3,
            1,	1,	3,
            1,	0.1,	3,
            1,	0.0000001,	3,
            1,	-0.1,	3,
            1,	-1,	3,
            1,	-10,	3,
            1,	-100,	3,
            1,	-1000,	3,
            10,	100,	3,
            10,	10,	3,
            10,	1,	3,
            10,	0.1,	3,
            10,	0.0000001,	3,
            10,	-0.1,	3,
            10,	-1,	3,
            10,	-10,	3,
            10,	-100,	3,
            10,	-1000,	3,
            100,	100,	3,
            100,	10,	3,
            100,	1,	3,
            100,	0.1,	3,
            100,	0.0000001,	3,
            100,	-0.1,	3,
            100,	-1,	3,
            100,	-10,	3,
            100,	-100,	3,
            100,	-1000,	3,
            0.000000001,	100,	1,
            0.000000001,	10,	1,
            0.000000001,	1,	1,
            0.000000001,	0.1,	1,
            0.000000001,	0.0000001,	1,
            0.000000001,	-0.1,	1,
            0.000000001,	-1,	1,
            0.000000001,	-10,	1,
            0.000000001,	-100,	1,
            0.000000001,	-1000,	1,
            0.001,	100,	1,
            0.001,	10,	1,
            0.001,	1,	1,
            0.001,	0.1,	1,
            0.001,	0.0000001,	1,
            0.001,	-0.1,	1,
            0.001,	-1,	1,
            0.001,	-10,	1,
            0.001,	-100,	1,
            0.001,	-1000,	1,
            0.01,	100,	1,
            0.01,	10,	1,
            0.01,	1,	1,
            0.01,	0.1,	1,
            0.01,	0.0000001,	1,
            0.01,	-0.1,	1,
            0.01,	-1,	1,
            0.01,	-10,	1,
            0.01,	-100,	1,
            0.01,	-1000,	1,
            0.1,	100,	1,
            0.1,	10,	1,
            0.1,	1,	1,
            0.1,	0.1,	1,
            0.1,	0.0000001,	1,
            0.1,	-0.1,	1,
            0.1,	-1,	1,
            0.1,	-10,	1,
            0.1,	-100,	1,
            0.1,	-1000,	1,
            1,	100,	1,
            1,	10,	1,
            1,	1,	1,
            1,	0.1,	1,
            1,	0.0000001,	1,
            1,	-0.1,	1,
            1,	-1,	1,
            1,	-10,	1,
            1,	-100,	1,
            1,	-1000,	1,
            10,	100,	1,
            10,	10,	1,
            10,	1,	1,
            10,	0.1,	1,
            10,	0.0000001,	1,
            10,	-0.1,	1,
            10,	-1,	1,
            10,	-10,	1,
            10,	-100,	1,
            10,	-1000,	1,
            100,	100,	1,
            100,	10,	1,
            100,	1,	1,
            100,	0.1,	1,
            100,	0.0000001,	1,
            100,	-0.1,	1,
            100,	-1,	1,
            100,	-10,	1,
            100,	-100,	1,
            100,	-1000,	1,
            0.000000001,	100,	0.1,
            0.000000001,	10,	0.1,
            0.000000001,	1,	0.1,
            0.000000001,	0.1,	0.1,
            0.000000001,	0.0000001,	0.1,
            0.000000001,	-0.1,	0.1,
            0.000000001,	-1,	0.1,
            0.000000001,	-10,	0.1,
            0.000000001,	-100,	0.1,
            0.000000001,	-1000,	0.1,
            0.001,	100,	0.1,
            0.001,	10,	0.1,
            0.001,	1,	0.1,
            0.001,	0.1,	0.1,
            0.001,	0.0000001,	0.1,
            0.001,	-0.1,	0.1,
            0.001,	-1,	0.1,
            0.001,	-10,	0.1,
            0.001,	-100,	0.1,
            0.001,	-1000,	0.1,
            0.01,	100,	0.1,
            0.01,	10,	0.1,
            0.01,	1,	0.1,
            0.01,	0.1,	0.1,
            0.01,	0.0000001,	0.1,
            0.01,	-0.1,	0.1,
            0.01,	-1,	0.1,
            0.01,	-10,	0.1,
            0.01,	-100,	0.1,
            0.01,	-1000,	0.1,
            0.1,	100,	0.1,
            0.1,	10,	0.1,
            0.1,	1,	0.1,
            0.1,	0.1,	0.1,
            0.1,	0.0000001,	0.1,
            0.1,	-0.1,	0.1,
            0.1,	-1,	0.1,
            0.1,	-10,	0.1,
            0.1,	-100,	0.1,
            0.1,	-1000,	0.1,
            1,	100,	0.1,
            1,	10,	0.1,
            1,	1,	0.1,
            1,	0.1,	0.1,
            1,	0.0000001,	0.1,
            1,	-0.1,	0.1,
            1,	-1,	0.1,
            1,	-10,	0.1,
            1,	-100,	0.1,
            1,	-1000,	0.1,
            10,	100,	0.1,
            10,	10,	0.1,
            10,	1,	0.1,
            10,	0.1,	0.1,
            10,	0.0000001,	0.1,
            10,	-0.1,	0.1,
            10,	-1,	0.1,
            10,	-10,	0.1,
            10,	-100,	0.1,
            10,	-1000,	0.1,
            100,	100,	0.1,
            100,	10,	0.1,
            100,	1,	0.1,
            100,	0.1,	0.1,
            100,	0.0000001,	0.1,
            100,	-0.1,	0.1,
            100,	-1,	0.1,
            100,	-10,	0.1,
            100,	-100,	0.1,
            100,	-1000,	0.1,
            0.000000001,	100,	0.001,
            0.000000001,	10,	0.001,
            0.000000001,	1,	0.001,
            0.000000001,	0.1,	0.001,
            0.000000001,	0.0000001,	0.001,
            0.000000001,	-0.1,	0.001,
            0.000000001,	-1,	0.001,
            0.000000001,	-10,	0.001,
            0.000000001,	-100,	0.001,
            0.000000001,	-1000,	0.001,
            0.001,	100,	0.001,
            0.001,	10,	0.001,
            0.001,	1,	0.001,
            0.001,	0.1,	0.001,
            0.001,	0.0000001,	0.001,
            0.001,	-0.1,	0.001,
            0.001,	-1,	0.001,
            0.001,	-10,	0.001,
            0.001,	-100,	0.001,
            0.001,	-1000,	0.001,
            0.01,	100,	0.001,
            0.01,	10,	0.001,
            0.01,	1,	0.001,
            0.01,	0.1,	0.001,
            0.01,	0.0000001,	0.001,
            0.01,	-0.1,	0.001,
            0.01,	-1,	0.001,
            0.01,	-10,	0.001,
            0.01,	-100,	0.001,
            0.01,	-1000,	0.001,
            0.1,	100,	0.001,
            0.1,	10,	0.001,
            0.1,	1,	0.001,
            0.1,	0.1,	0.001,
            0.1,	0.0000001,	0.001,
            0.1,	-0.1,	0.001,
            0.1,	-1,	0.001,
            0.1,	-10,	0.001,
            0.1,	-100,	0.001,
            0.1,	-1000,	0.001,
            1,	100,	0.001,
            1,	10,	0.001,
            1,	1,	0.001,
            1,	0.1,	0.001,
            1,	0.0000001,	0.001,
            1,	-0.1,	0.001,
            1,	-1,	0.001,
            1,	-10,	0.001,
            1,	-100,	0.001,
            1,	-1000,	0.001,
            10,	100,	0.001,
            10,	10,	0.001,
            10,	1,	0.001,
            10,	0.1,	0.001,
            10,	0.0000001,	0.001,
            10,	-0.1,	0.001,
            10,	-1,	0.001,
            10,	-10,	0.001,
            10,	-100,	0.001,
            10,	-1000,	0.001,
            100,	100,	0.001,
            100,	10,	0.001,
            100,	1,	0.001,
            100,	0.1,	0.001,
            100,	0.0000001,	0.001,
            100,	-0.1,	0.001,
            100,	-1,	0.001,
            100,	-10,	0.001,
            100,	-100,	0.001,
            100,	-1000,	0.001,
            0.000000001,	100,	0.000000001,
            0.000000001,	10,	0.000000001,
            0.000000001,	1,	0.000000001,
            0.000000001,	0.1,	0.000000001,
            0.000000001,	0.0000001,	0.000000001,
            0.000000001,	-0.1,	0.000000001,
            0.000000001,	-1,	0.000000001,
            0.000000001,	-10,	0.000000001,
            0.000000001,	-100,	0.000000001,
            0.000000001,	-1000,	0.000000001,
            0.001,	100,	0.000000001,
            0.001,	10,	0.000000001,
            0.001,	1,	0.000000001,
            0.001,	0.1,	0.000000001,
            0.001,	0.0000001,	0.000000001,
            0.001,	-0.1,	0.000000001,
            0.001,	-1,	0.000000001,
            0.001,	-10,	0.000000001,
            0.001,	-100,	0.000000001,
            0.001,	-1000,	0.000000001,
            0.01,	100,	0.000000001,
            0.01,	10,	0.000000001,
            0.01,	1,	0.000000001,
            0.01,	0.1,	0.000000001,
            0.01,	0.0000001,	0.000000001,
            0.01,	-0.1,	0.000000001,
            0.01,	-1,	0.000000001,
            0.01,	-10,	0.000000001,
            0.01,	-100,	0.000000001,
            0.01,	-1000,	0.000000001,
            0.1,	100,	0.000000001,
            0.1,	10,	0.000000001,
            0.1,	1,	0.000000001,
            0.1,	0.1,	0.000000001,
            0.1,	0.0000001,	0.000000001,
            0.1,	-0.1,	0.000000001,
            0.1,	-1,	0.000000001,
            0.1,	-10,	0.000000001,
            0.1,	-100,	0.000000001,
            0.1,	-1000,	0.000000001,
            1,	100,	0.000000001,
            1,	10,	0.000000001,
            1,	1,	0.000000001,
            1,	0.1,	0.000000001,
            1,	0.0000001,	0.000000001,
            1,	-0.1,	0.000000001,
            1,	-1,	0.000000001,
            1,	-10,	0.000000001,
            1,	-100,	0.000000001,
            1,	-1000,	0.000000001,
            10,	100,	0.000000001,
            10,	10,	0.000000001,
            10,	1,	0.000000001,
            10,	0.1,	0.000000001,
            10,	0.0000001,	0.000000001,
            10,	-0.1,	0.000000001,
            10,	-1,	0.000000001,
            10,	-10,	0.000000001,
            10,	-100,	0.000000001,
            10,	-1000,	0.000000001,
            100,	100,	0.000000001,
            100,	10,	0.000000001,
            100,	1,	0.000000001,
            100,	0.1,	0.000000001,
            100,	0.0000001,	0.000000001,
            100,	-0.1,	0.000000001,
            100,	-1,	0.000000001,
            100,	-10,	0.000000001,
            100,	-100,	0.000000001,
            100,	-1000,	0.000000001,
            0.000000001,	100,	-0.001,
            0.000000001,	10,	-0.001,
            0.000000001,	1,	-0.001,
            0.000000001,	0.1,	-0.001,
            0.000000001,	0.0000001,	-0.001,
            0.000000001,	-0.1,	-0.001,
            0.000000001,	-1,	-0.001,
            0.000000001,	-10,	-0.001,
            0.000000001,	-100,	-0.001,
            0.000000001,	-1000,	-0.001,
            0.001,	100,	-0.001,
            0.001,	10,	-0.001,
            0.001,	1,	-0.001,
            0.001,	0.1,	-0.001,
            0.001,	0.0000001,	-0.001,
            0.001,	-0.1,	-0.001,
            0.001,	-1,	-0.001,
            0.001,	-10,	-0.001,
            0.001,	-100,	-0.001,
            0.001,	-1000,	-0.001,
            0.01,	100,	-0.001,
            0.01,	10,	-0.001,
            0.01,	1,	-0.001,
            0.01,	0.1,	-0.001,
            0.01,	0.0000001,	-0.001,
            0.01,	-0.1,	-0.001,
            0.01,	-1,	-0.001,
            0.01,	-10,	-0.001,
            0.01,	-100,	-0.001,
            0.01,	-1000,	-0.001,
            0.1,	100,	-0.001,
            0.1,	10,	-0.001,
            0.1,	1,	-0.001,
            0.1,	0.1,	-0.001,
            0.1,	0.0000001,	-0.001,
            0.1,	-0.1,	-0.001,
            0.1,	-1,	-0.001,
            0.1,	-10,	-0.001,
            0.1,	-100,	-0.001,
            0.1,	-1000,	-0.001,
            1,	100,	-0.001,
            1,	10,	-0.001,
            1,	1,	-0.001,
            1,	0.1,	-0.001,
            1,	0.0000001,	-0.001,
            1,	-0.1,	-0.001,
            1,	-1,	-0.001,
            1,	-10,	-0.001,
            1,	-100,	-0.001,
            1,	-1000,	-0.001,
            10,	100,	-0.001,
            10,	10,	-0.001,
            10,	1,	-0.001,
            10,	0.1,	-0.001,
            10,	0.0000001,	-0.001,
            10,	-0.1,	-0.001,
            10,	-1,	-0.001,
            10,	-10,	-0.001,
            10,	-100,	-0.001,
            10,	-1000,	-0.001,
            100,	100,	-0.001,
            100,	10,	-0.001,
            100,	1,	-0.001,
            100,	0.1,	-0.001,
            100,	0.0000001,	-0.001,
            100,	-0.1,	-0.001,
            100,	-1,	-0.001,
            100,	-10,	-0.001,
            100,	-100,	-0.001,
            100,	-1000,	-0.001,
            0.000000001,	100,	-0.01,
            0.000000001,	10,	-0.01,
            0.000000001,	1,	-0.01,
            0.000000001,	0.1,	-0.01,
            0.000000001,	0.0000001,	-0.01,
            0.000000001,	-0.1,	-0.01,
            0.000000001,	-1,	-0.01,
            0.000000001,	-10,	-0.01,
            0.000000001,	-100,	-0.01,
            0.000000001,	-1000,	-0.01,
            0.001,	100,	-0.01,
            0.001,	10,	-0.01,
            0.001,	1,	-0.01,
            0.001,	0.1,	-0.01,
            0.001,	0.0000001,	-0.01,
            0.001,	-0.1,	-0.01,
            0.001,	-1,	-0.01,
            0.001,	-10,	-0.01,
            0.001,	-100,	-0.01,
            0.001,	-1000,	-0.01,
            0.01,	100,	-0.01,
            0.01,	10,	-0.01,
            0.01,	1,	-0.01,
            0.01,	0.1,	-0.01,
            0.01,	0.0000001,	-0.01,
            0.01,	-0.1,	-0.01,
            0.01,	-1,	-0.01,
            0.01,	-10,	-0.01,
            0.01,	-100,	-0.01,
            0.01,	-1000,	-0.01,
            0.1,	100,	-0.01,
            0.1,	10,	-0.01,
            0.1,	1,	-0.01,
            0.1,	0.1,	-0.01,
            0.1,	0.0000001,	-0.01,
            0.1,	-0.1,	-0.01,
            0.1,	-1,	-0.01,
            0.1,	-10,	-0.01,
            0.1,	-100,	-0.01,
            0.1,	-1000,	-0.01,
            1,	100,	-0.01,
            1,	10,	-0.01,
            1,	1,	-0.01,
            1,	0.1,	-0.01,
            1,	0.0000001,	-0.01,
            1,	-0.1,	-0.01,
            1,	-1,	-0.01,
            1,	-10,	-0.01,
            1,	-100,	-0.01,
            1,	-1000,	-0.01,
            10,	100,	-0.01,
            10,	10,	-0.01,
            10,	1,	-0.01,
            10,	0.1,	-0.01,
            10,	0.0000001,	-0.01,
            10,	-0.1,	-0.01,
            10,	-1,	-0.01,
            10,	-10,	-0.01,
            10,	-100,	-0.01,
            10,	-1000,	-0.01,
            100,	100,	-0.01,
            100,	10,	-0.01,
            100,	1,	-0.01,
            100,	0.1,	-0.01,
            100,	0.0000001,	-0.01,
            100,	-0.1,	-0.01,
            100,	-1,	-0.01,
            100,	-10,	-0.01,
            100,	-100,	-0.01,
            100,	-1000,	-0.01,
            0.000000001,	100,	-0.1,
            0.000000001,	10,	-0.1,
            0.000000001,	1,	-0.1,
            0.000000001,	0.1,	-0.1,
            0.000000001,	0.0000001,	-0.1,
            0.000000001,	-0.1,	-0.1,
            0.000000001,	-1,	-0.1,
            0.000000001,	-10,	-0.1,
            0.000000001,	-100,	-0.1,
            0.000000001,	-1000,	-0.1,
            0.001,	100,	-0.1,
            0.001,	10,	-0.1,
            0.001,	1,	-0.1,
            0.001,	0.1,	-0.1,
            0.001,	0.0000001,	-0.1,
            0.001,	-0.1,	-0.1,
            0.001,	-1,	-0.1,
            0.001,	-10,	-0.1,
            0.001,	-100,	-0.1,
            0.001,	-1000,	-0.1,
            0.01,	100,	-0.1,
            0.01,	10,	-0.1,
            0.01,	1,	-0.1,
            0.01,	0.1,	-0.1,
            0.01,	0.0000001,	-0.1,
            0.01,	-0.1,	-0.1,
            0.01,	-1,	-0.1,
            0.01,	-10,	-0.1,
            0.01,	-100,	-0.1,
            0.01,	-1000,	-0.1,
            0.1,	100,	-0.1,
            0.1,	10,	-0.1,
            0.1,	1,	-0.1,
            0.1,	0.1,	-0.1,
            0.1,	0.0000001,	-0.1,
            0.1,	-0.1,	-0.1,
            0.1,	-1,	-0.1,
            0.1,	-10,	-0.1,
            0.1,	-100,	-0.1,
            0.1,	-1000,	-0.1,
            1,	100,	-0.1,
            1,	10,	-0.1,
            1,	1,	-0.1,
            1,	0.1,	-0.1,
            1,	0.0000001,	-0.1,
            1,	-0.1,	-0.1,
            1,	-1,	-0.1,
            1,	-10,	-0.1,
            1,	-100,	-0.1,
            1,	-1000,	-0.1,
            10,	100,	-0.1,
            10,	10,	-0.1,
            10,	1,	-0.1,
            10,	0.1,	-0.1,
            10,	0.0000001,	-0.1,
            10,	-0.1,	-0.1,
            10,	-1,	-0.1,
            10,	-10,	-0.1,
            10,	-100,	-0.1,
            10,	-1000,	-0.1,
            100,	100,	-0.1,
            100,	10,	-0.1,
            100,	1,	-0.1,
            100,	0.1,	-0.1,
            100,	0.0000001,	-0.1,
            100,	-0.1,	-0.1,
            100,	-1,	-0.1,
            100,	-10,	-0.1,
            100,	-100,	-0.1,
            100,	-1000,	-0.1,
            0.000000001,	100,	-1,
            0.000000001,	10,	-1,
            0.000000001,	1,	-1,
            0.000000001,	0.1,	-1,
            0.000000001,	0.0000001,	-1,
            0.000000001,	-0.1,	-1,
            0.000000001,	-1,	-1,
            0.000000001,	-10,	-1,
            0.000000001,	-100,	-1,
            0.000000001,	-1000,	-1,
            0.001,	100,	-1,
            0.001,	10,	-1,
            0.001,	1,	-1,
            0.001,	0.1,	-1,
            0.001,	0.0000001,	-1,
            0.001,	-0.1,	-1,
            0.001,	-1,	-1,
            0.001,	-10,	-1,
            0.001,	-100,	-1,
            0.001,	-1000,	-1,
            0.01,	100,	-1,
            0.01,	10,	-1,
            0.01,	1,	-1,
            0.01,	0.1,	-1,
            0.01,	0.0000001,	-1,
            0.01,	-0.1,	-1,
            0.01,	-1,	-1,
            0.01,	-10,	-1,
            0.01,	-100,	-1,
            0.01,	-1000,	-1,
            0.1,	100,	-1,
            0.1,	10,	-1,
            0.1,	1,	-1,
            0.1,	0.1,	-1,
            0.1,	0.0000001,	-1,
            0.1,	-0.1,	-1,
            0.1,	-1,	-1,
            0.1,	-10,	-1,
            0.1,	-100,	-1,
            0.1,	-1000,	-1,
            1,	100,	-1,
            1,	10,	-1,
            1,	1,	-1,
            1,	0.1,	-1,
            1,	0.0000001,	-1,
            1,	-0.1,	-1,
            1,	-1,	-1,
            1,	-10,	-1,
            1,	-100,	-1,
            1,	-1000,	-1,
            10,	100,	-1,
            10,	10,	-1,
            10,	1,	-1,
            10,	0.1,	-1,
            10,	0.0000001,	-1,
            10,	-0.1,	-1,
            10,	-1,	-1,
            10,	-10,	-1,
            10,	-100,	-1,
            10,	-1000,	-1,
            100,	100,	-1,
            100,	10,	-1,
            100,	1,	-1,
            100,	0.1,	-1,
            100,	0.0000001,	-1,
            100,	-0.1,	-1,
            100,	-1,	-1,
            100,	-10,	-1,
            100,	-100,	-1,
            100,	-1000,	-1,
            0.000000001,	100,	-3,
            0.000000001,	10,	-3,
            0.000000001,	1,	-3,
            0.000000001,	0.1,	-3,
            0.000000001,	0.0000001,	-3,
            0.000000001,	-0.1,	-3,
            0.000000001,	-1,	-3,
            0.000000001,	-10,	-3,
            0.000000001,	-100,	-3,
            0.000000001,	-1000,	-3,
            0.001,	100,	-3,
            0.001,	10,	-3,
            0.001,	1,	-3,
            0.001,	0.1,	-3,
            0.001,	0.0000001,	-3,
            0.001,	-0.1,	-3,
            0.001,	-1,	-3,
            0.001,	-10,	-3,
            0.001,	-100,	-3,
            0.001,	-1000,	-3,
            0.01,	100,	-3,
            0.01,	10,	-3,
            0.01,	1,	-3,
            0.01,	0.1,	-3,
            0.01,	0.0000001,	-3,
            0.01,	-0.1,	-3,
            0.01,	-1,	-3,
            0.01,	-10,	-3,
            0.01,	-100,	-3,
            0.01,	-1000,	-3,
            0.1,	100,	-3,
            0.1,	10,	-3,
            0.1,	1,	-3,
            0.1,	0.1,	-3,
            0.1,	0.0000001,	-3,
            0.1,	-0.1,	-3,
            0.1,	-1,	-3,
            0.1,	-10,	-3,
            0.1,	-100,	-3,
            0.1,	-1000,	-3,
            1,	100,	-3,
            1,	10,	-3,
            1,	1,	-3,
            1,	0.1,	-3,
            1,	0.0000001,	-3,
            1,	-0.1,	-3,
            1,	-1,	-3,
            1,	-10,	-3,
            1,	-100,	-3,
            1,	-1000,	-3,
            10,	100,	-3,
            10,	10,	-3,
            10,	1,	-3,
            10,	0.1,	-3,
            10,	0.0000001,	-3,
            10,	-0.1,	-3,
            10,	-1,	-3,
            10,	-10,	-3,
            10,	-100,	-3,
            10,	-1000,	-3,
            100,	100,	-3,
            100,	10,	-3,
            100,	1,	-3,
            100,	0.1,	-3,
            100,	0.0000001,	-3,
            100,	-0.1,	-3,
            100,	-1,	-3,
            100,	-10,	-3,
            100,	-100,	-3,
            100,	-1000,	-3
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/3, 3, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 4)
         result_matrix[,1:3] <- p_starting
      }



     if(MODEL == "OU_linear_breakpoint"){
         p_matrix <- c(
	0.0001,	0.000001,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.1,	0.000001,	20,	0.000001,	0.1,	0.000001,	0.000001,
	1,	0.000001,	20,	0.000001,	0.1,	0.000001,	0.000001,
	10,	0.000001,	20,	0.000001,	0.1,	0.000001,	0.000001,
	100,	0.000001,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.0001,	0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.1,	0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	1,	0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	10,	0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	100,	0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.0001,	1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.1,	1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	1,	1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	10,	1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	100,	1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.0001,	-0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.1,	-0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	1,	-0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	10,	-0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	100,	-0.01,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.0001,	-1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.1,	-1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	1,	-1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	10,	-1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	100,	-1,	20,	0.000001,	0.1,	0.000001,	0.000001,
	0.0001,	0.000001,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.1,	0.000001,	20,	0.01,	0.1,	0.000001,	0.000001,
	1,	0.000001,	20,	0.01,	0.1,	0.000001,	0.000001,
	10,	0.000001,	20,	0.01,	0.1,	0.000001,	0.000001,
	100,	0.000001,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.0001,	0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.1,	0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	1,	0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	10,	0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	100,	0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.0001,	1,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.1,	1,	20,	0.01,	0.1,	0.000001,	0.000001,
	1,	1,	20,	0.01,	0.1,	0.000001,	0.000001,
	10,	1,	20,	0.01,	0.1,	0.000001,	0.000001,
	100,	1,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.0001,	-0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.1,	-0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	1,	-0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	10,	-0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	100,	-0.01,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.0001,	-1,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.1,	-1,	20,	0.01,	0.1,	0.000001,	0.000001,
	1,	-1,	20,	0.01,	0.1,	0.000001,	0.000001,
	10,	-1,	20,	0.01,	0.1,	0.000001,	0.000001,
	100,	-1,	20,	0.01,	0.1,	0.000001,	0.000001,
	0.0001,	0.000001,	20,	1,	0.1,	0.000001,	0.000001,
	0.1,	0.000001,	20,	1,	0.1,	0.000001,	0.000001,
	1,	0.000001,	20,	1,	0.1,	0.000001,	0.000001,
	10,	0.000001,	20,	1,	0.1,	0.000001,	0.000001,
	100,	0.000001,	20,	1,	0.1,	0.000001,	0.000001,
	0.0001,	0.01,	20,	1,	0.1,	0.000001,	0.000001,
	0.1,	0.01,	20,	1,	0.1,	0.000001,	0.000001,
	1,	0.01,	20,	1,	0.1,	0.000001,	0.000001,
	10,	0.01,	20,	1,	0.1,	0.000001,	0.000001,
	100,	0.01,	20,	1,	0.1,	0.000001,	0.000001,
	0.0001,	1,	20,	1,	0.1,	0.000001,	0.000001,
	0.1,	1,	20,	1,	0.1,	0.000001,	0.000001,
	1,	1,	20,	1,	0.1,	0.000001,	0.000001,
	10,	1,	20,	1,	0.1,	0.000001,	0.000001,
	100,	1,	20,	1,	0.1,	0.000001,	0.000001,
	0.0001,	-0.01,	20,	1,	0.1,	0.000001,	0.000001,
	0.1,	-0.01,	20,	1,	0.1,	0.000001,	0.000001,
	1,	-0.01,	20,	1,	0.1,	0.000001,	0.000001,
	10,	-0.01,	20,	1,	0.1,	0.000001,	0.000001,
	100,	-0.01,	20,	1,	0.1,	0.000001,	0.000001,
	0.0001,	-1,	20,	1,	0.1,	0.000001,	0.000001,
	0.1,	-1,	20,	1,	0.1,	0.000001,	0.000001,
	1,	-1,	20,	1,	0.1,	0.000001,	0.000001,
	10,	-1,	20,	1,	0.1,	0.000001,	0.000001,
	100,	-1,	20,	1,	0.1,	0.000001,	0.000001,
	0.0001,	0.000001,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.1,	0.000001,	20,	-0.01,	0.1,	0.000001,	0.000001,
	1,	0.000001,	20,	-0.01,	0.1,	0.000001,	0.000001,
	10,	0.000001,	20,	-0.01,	0.1,	0.000001,	0.000001,
	100,	0.000001,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.0001,	0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.1,	0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	1,	0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	10,	0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	100,	0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.0001,	1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.1,	1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	1,	1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	10,	1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	100,	1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.0001,	-0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.1,	-0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	1,	-0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	10,	-0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	100,	-0.01,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.0001,	-1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.1,	-1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	1,	-1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	10,	-1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	100,	-1,	20,	-0.01,	0.1,	0.000001,	0.000001,
	0.0001,	0.000001,	20,	-1,	0.1,	0.000001,	0.000001,
	0.1,	0.000001,	20,	-1,	0.1,	0.000001,	0.000001,
	1,	0.000001,	20,	-1,	0.1,	0.000001,	0.000001,
	10,	0.000001,	20,	-1,	0.1,	0.000001,	0.000001,
	100,	0.000001,	20,	-1,	0.1,	0.000001,	0.000001,
	0.0001,	0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	0.1,	0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	1,	0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	10,	0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	100,	0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	0.0001,	1,	20,	-1,	0.1,	0.000001,	0.000001,
	0.1,	1,	20,	-1,	0.1,	0.000001,	0.000001,
	1,	1,	20,	-1,	0.1,	0.000001,	0.000001,
	10,	1,	20,	-1,	0.1,	0.000001,	0.000001,
	100,	1,	20,	-1,	0.1,	0.000001,	0.000001,
	0.0001,	-0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	0.1,	-0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	1,	-0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	10,	-0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	100,	-0.01,	20,	-1,	0.1,	0.000001,	0.000001,
	0.0001,	-1,	20,	-1,	0.1,	0.000001,	0.000001,
	0.1,	-1,	20,	-1,	0.1,	0.000001,	0.000001,
	1,	-1,	20,	-1,	0.1,	0.000001,	0.000001,
	10,	-1,	20,	-1,	0.1,	0.000001,	0.000001,
	100,	-1,	20,	-1,	0.1,	0.000001,	0.000001,
	0.0001,	0.000001,	20,	0.000001,	0.1,	0.01,	0.01,
	0.1,	0.000001,	20,	0.000001,	0.1,	0.01,	0.01,
	1,	0.000001,	20,	0.000001,	0.1,	0.01,	0.01,
	10,	0.000001,	20,	0.000001,	0.1,	0.01,	0.01,
	100,	0.000001,	20,	0.000001,	0.1,	0.01,	0.01,
	0.0001,	0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	0.1,	0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	1,	0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	10,	0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	100,	0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	0.0001,	1,	20,	0.000001,	0.1,	0.01,	0.01,
	0.1,	1,	20,	0.000001,	0.1,	0.01,	0.01,
	1,	1,	20,	0.000001,	0.1,	0.01,	0.01,
	10,	1,	20,	0.000001,	0.1,	0.01,	0.01,
	100,	1,	20,	0.000001,	0.1,	0.01,	0.01,
	0.0001,	-0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	0.1,	-0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	1,	-0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	10,	-0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	100,	-0.01,	20,	0.000001,	0.1,	0.01,	0.01,
	0.0001,	-1,	20,	0.000001,	0.1,	0.01,	0.01,
	0.1,	-1,	20,	0.000001,	0.1,	0.01,	0.01,
	1,	-1,	20,	0.000001,	0.1,	0.01,	0.01,
	10,	-1,	20,	0.000001,	0.1,	0.01,	0.01,
	100,	-1,	20,	0.000001,	0.1,	0.01,	0.01,
	0.0001,	0.000001,	20,	0.01,	0.1,	0.01,	0.01,
	0.1,	0.000001,	20,	0.01,	0.1,	0.01,	0.01,
	1,	0.000001,	20,	0.01,	0.1,	0.01,	0.01,
	10,	0.000001,	20,	0.01,	0.1,	0.01,	0.01,
	100,	0.000001,	20,	0.01,	0.1,	0.01,	0.01,
	0.0001,	0.01,	20,	0.01,	0.1,	0.01,	0.01,
	0.1,	0.01,	20,	0.01,	0.1,	0.01,	0.01,
	1,	0.01,	20,	0.01,	0.1,	0.01,	0.01,
	10,	0.01,	20,	0.01,	0.1,	0.01,	0.01,
	100,	0.01,	20,	0.01,	0.1,	0.01,	0.01,
	0.0001,	1,	20,	0.01,	0.1,	0.01,	0.01,
	0.1,	1,	20,	0.01,	0.1,	0.01,	0.01,
	1,	1,	20,	0.01,	0.1,	0.01,	0.01,
	10,	1,	20,	0.01,	0.1,	0.01,	0.01,
	100,	1,	20,	0.01,	0.1,	0.01,	0.01,
	0.0001,	-0.01,	20,	0.01,	0.1,	0.01,	0.01,
	0.1,	-0.01,	20,	0.01,	0.1,	0.01,	0.01,
	1,	-0.01,	20,	0.01,	0.1,	0.01,	0.01,
	10,	-0.01,	20,	0.01,	0.1,	0.01,	0.01,
	100,	-0.01,	20,	0.01,	0.1,	0.01,	0.01,
	0.0001,	-1,	20,	0.01,	0.1,	0.01,	0.01,
	0.1,	-1,	20,	0.01,	0.1,	0.01,	0.01,
	1,	-1,	20,	0.01,	0.1,	0.01,	0.01,
	10,	-1,	20,	0.01,	0.1,	0.01,	0.01,
	100,	-1,	20,	0.01,	0.1,	0.01,	0.01,
	0.0001,	0.000001,	20,	1,	0.1,	0.01,	0.01,
	0.1,	0.000001,	20,	1,	0.1,	0.01,	0.01,
	1,	0.000001,	20,	1,	0.1,	0.01,	0.01,
	10,	0.000001,	20,	1,	0.1,	0.01,	0.01,
	100,	0.000001,	20,	1,	0.1,	0.01,	0.01,
	0.0001,	0.01,	20,	1,	0.1,	0.01,	0.01,
	0.1,	0.01,	20,	1,	0.1,	0.01,	0.01,
	1,	0.01,	20,	1,	0.1,	0.01,	0.01,
	10,	0.01,	20,	1,	0.1,	0.01,	0.01,
	100,	0.01,	20,	1,	0.1,	0.01,	0.01,
	0.0001,	1,	20,	1,	0.1,	0.01,	0.01,
	0.1,	1,	20,	1,	0.1,	0.01,	0.01,
	1,	1,	20,	1,	0.1,	0.01,	0.01,
	10,	1,	20,	1,	0.1,	0.01,	0.01,
	100,	1,	20,	1,	0.1,	0.01,	0.01,
	0.0001,	-0.01,	20,	1,	0.1,	0.01,	0.01,
	0.1,	-0.01,	20,	1,	0.1,	0.01,	0.01,
	1,	-0.01,	20,	1,	0.1,	0.01,	0.01,
	10,	-0.01,	20,	1,	0.1,	0.01,	0.01,
	100,	-0.01,	20,	1,	0.1,	0.01,	0.01,
	0.0001,	-1,	20,	1,	0.1,	0.01,	0.01,
	0.1,	-1,	20,	1,	0.1,	0.01,	0.01,
	1,	-1,	20,	1,	0.1,	0.01,	0.01,
	10,	-1,	20,	1,	0.1,	0.01,	0.01,
	100,	-1,	20,	1,	0.1,	0.01,	0.01,
	0.0001,	0.000001,	20,	-0.01,	0.1,	0.01,	0.01,
	0.1,	0.000001,	20,	-0.01,	0.1,	0.01,	0.01,
	1,	0.000001,	20,	-0.01,	0.1,	0.01,	0.01,
	10,	0.000001,	20,	-0.01,	0.1,	0.01,	0.01,
	100,	0.000001,	20,	-0.01,	0.1,	0.01,	0.01,
	0.0001,	0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	0.1,	0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	1,	0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	10,	0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	100,	0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	0.0001,	1,	20,	-0.01,	0.1,	0.01,	0.01,
	0.1,	1,	20,	-0.01,	0.1,	0.01,	0.01,
	1,	1,	20,	-0.01,	0.1,	0.01,	0.01,
	10,	1,	20,	-0.01,	0.1,	0.01,	0.01,
	100,	1,	20,	-0.01,	0.1,	0.01,	0.01,
	0.0001,	-0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	0.1,	-0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	1,	-0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	10,	-0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	100,	-0.01,	20,	-0.01,	0.1,	0.01,	0.01,
	0.0001,	-1,	20,	-0.01,	0.1,	0.01,	0.01,
	0.1,	-1,	20,	-0.01,	0.1,	0.01,	0.01,
	1,	-1,	20,	-0.01,	0.1,	0.01,	0.01,
	10,	-1,	20,	-0.01,	0.1,	0.01,	0.01,
	100,	-1,	20,	-0.01,	0.1,	0.01,	0.01,
	0.0001,	0.000001,	20,	-1,	0.1,	0.01,	0.01,
	0.1,	0.000001,	20,	-1,	0.1,	0.01,	0.01,
	1,	0.000001,	20,	-1,	0.1,	0.01,	0.01,
	10,	0.000001,	20,	-1,	0.1,	0.01,	0.01,
	100,	0.000001,	20,	-1,	0.1,	0.01,	0.01,
	0.0001,	0.01,	20,	-1,	0.1,	0.01,	0.01,
	0.1,	0.01,	20,	-1,	0.1,	0.01,	0.01,
	1,	0.01,	20,	-1,	0.1,	0.01,	0.01,
	10,	0.01,	20,	-1,	0.1,	0.01,	0.01,
	100,	0.01,	20,	-1,	0.1,	0.01,	0.01,
	0.0001,	1,	20,	-1,	0.1,	0.01,	0.01,
	0.1,	1,	20,	-1,	0.1,	0.01,	0.01,
	1,	1,	20,	-1,	0.1,	0.01,	0.01,
	10,	1,	20,	-1,	0.1,	0.01,	0.01,
	100,	1,	20,	-1,	0.1,	0.01,	0.01,
	0.0001,	-0.01,	20,	-1,	0.1,	0.01,	0.01,
	0.1,	-0.01,	20,	-1,	0.1,	0.01,	0.01,
	1,	-0.01,	20,	-1,	0.1,	0.01,	0.01,
	10,	-0.01,	20,	-1,	0.1,	0.01,	0.01,
	100,	-0.01,	20,	-1,	0.1,	0.01,	0.01,
	0.0001,	-1,	20,	-1,	0.1,	0.01,	0.01,
	0.1,	-1,	20,	-1,	0.1,	0.01,	0.01,
	1,	-1,	20,	-1,	0.1,	0.01,	0.01,
	10,	-1,	20,	-1,	0.1,	0.01,	0.01,
	100,	-1,	20,	-1,	0.1,	0.01,	0.01,
	0.0001,	0.000001,	20,	0.000001,	0.1,	1,	1,
	0.1,	0.000001,	20,	0.000001,	0.1,	1,	1,
	1,	0.000001,	20,	0.000001,	0.1,	1,	1,
	10,	0.000001,	20,	0.000001,	0.1,	1,	1,
	100,	0.000001,	20,	0.000001,	0.1,	1,	1,
	0.0001,	0.01,	20,	0.000001,	0.1,	1,	1,
	0.1,	0.01,	20,	0.000001,	0.1,	1,	1,
	1,	0.01,	20,	0.000001,	0.1,	1,	1,
	10,	0.01,	20,	0.000001,	0.1,	1,	1,
	100,	0.01,	20,	0.000001,	0.1,	1,	1,
	0.0001,	1,	20,	0.000001,	0.1,	1,	1,
	0.1,	1,	20,	0.000001,	0.1,	1,	1,
	1,	1,	20,	0.000001,	0.1,	1,	1,
	10,	1,	20,	0.000001,	0.1,	1,	1,
	100,	1,	20,	0.000001,	0.1,	1,	1,
	0.0001,	-0.01,	20,	0.000001,	0.1,	1,	1,
	0.1,	-0.01,	20,	0.000001,	0.1,	1,	1,
	1,	-0.01,	20,	0.000001,	0.1,	1,	1,
	10,	-0.01,	20,	0.000001,	0.1,	1,	1,
	100,	-0.01,	20,	0.000001,	0.1,	1,	1,
	0.0001,	-1,	20,	0.000001,	0.1,	1,	1,
	0.1,	-1,	20,	0.000001,	0.1,	1,	1,
	1,	-1,	20,	0.000001,	0.1,	1,	1,
	10,	-1,	20,	0.000001,	0.1,	1,	1,
	100,	-1,	20,	0.000001,	0.1,	1,	1,
	0.0001,	0.000001,	20,	0.01,	0.1,	1,	1,
	0.1,	0.000001,	20,	0.01,	0.1,	1,	1,
	1,	0.000001,	20,	0.01,	0.1,	1,	1,
	10,	0.000001,	20,	0.01,	0.1,	1,	1,
	100,	0.000001,	20,	0.01,	0.1,	1,	1,
	0.0001,	0.01,	20,	0.01,	0.1,	1,	1,
	0.1,	0.01,	20,	0.01,	0.1,	1,	1,
	1,	0.01,	20,	0.01,	0.1,	1,	1,
	10,	0.01,	20,	0.01,	0.1,	1,	1,
	100,	0.01,	20,	0.01,	0.1,	1,	1,
	0.0001,	1,	20,	0.01,	0.1,	1,	1,
	0.1,	1,	20,	0.01,	0.1,	1,	1,
	1,	1,	20,	0.01,	0.1,	1,	1,
	10,	1,	20,	0.01,	0.1,	1,	1,
	100,	1,	20,	0.01,	0.1,	1,	1,
	0.0001,	-0.01,	20,	0.01,	0.1,	1,	1,
	0.1,	-0.01,	20,	0.01,	0.1,	1,	1,
	1,	-0.01,	20,	0.01,	0.1,	1,	1,
	10,	-0.01,	20,	0.01,	0.1,	1,	1,
	100,	-0.01,	20,	0.01,	0.1,	1,	1,
	0.0001,	-1,	20,	0.01,	0.1,	1,	1,
	0.1,	-1,	20,	0.01,	0.1,	1,	1,
	1,	-1,	20,	0.01,	0.1,	1,	1,
	10,	-1,	20,	0.01,	0.1,	1,	1,
	100,	-1,	20,	0.01,	0.1,	1,	1,
	0.0001,	0.000001,	20,	1,	0.1,	1,	1,
	0.1,	0.000001,	20,	1,	0.1,	1,	1,
	1,	0.000001,	20,	1,	0.1,	1,	1,
	10,	0.000001,	20,	1,	0.1,	1,	1,
	100,	0.000001,	20,	1,	0.1,	1,	1,
	0.0001,	0.01,	20,	1,	0.1,	1,	1,
	0.1,	0.01,	20,	1,	0.1,	1,	1,
	1,	0.01,	20,	1,	0.1,	1,	1,
	10,	0.01,	20,	1,	0.1,	1,	1,
	100,	0.01,	20,	1,	0.1,	1,	1,
	0.0001,	1,	20,	1,	0.1,	1,	1,
	0.1,	1,	20,	1,	0.1,	1,	1,
	1,	1,	20,	1,	0.1,	1,	1,
	10,	1,	20,	1,	0.1,	1,	1,
	100,	1,	20,	1,	0.1,	1,	1,
	0.0001,	-0.01,	20,	1,	0.1,	1,	1,
	0.1,	-0.01,	20,	1,	0.1,	1,	1,
	1,	-0.01,	20,	1,	0.1,	1,	1,
	10,	-0.01,	20,	1,	0.1,	1,	1,
	100,	-0.01,	20,	1,	0.1,	1,	1,
	0.0001,	-1,	20,	1,	0.1,	1,	1,
	0.1,	-1,	20,	1,	0.1,	1,	1,
	1,	-1,	20,	1,	0.1,	1,	1,
	10,	-1,	20,	1,	0.1,	1,	1,
	100,	-1,	20,	1,	0.1,	1,	1,
	0.0001,	0.000001,	20,	-0.01,	0.1,	1,	1,
	0.1,	0.000001,	20,	-0.01,	0.1,	1,	1,
	1,	0.000001,	20,	-0.01,	0.1,	1,	1,
	10,	0.000001,	20,	-0.01,	0.1,	1,	1,
	100,	0.000001,	20,	-0.01,	0.1,	1,	1,
	0.0001,	0.01,	20,	-0.01,	0.1,	1,	1,
	0.1,	0.01,	20,	-0.01,	0.1,	1,	1,
	1,	0.01,	20,	-0.01,	0.1,	1,	1,
	10,	0.01,	20,	-0.01,	0.1,	1,	1,
	100,	0.01,	20,	-0.01,	0.1,	1,	1,
	0.0001,	1,	20,	-0.01,	0.1,	1,	1,
	0.1,	1,	20,	-0.01,	0.1,	1,	1,
	1,	1,	20,	-0.01,	0.1,	1,	1,
	10,	1,	20,	-0.01,	0.1,	1,	1,
	100,	1,	20,	-0.01,	0.1,	1,	1,
	0.0001,	-0.01,	20,	-0.01,	0.1,	1,	1,
	0.1,	-0.01,	20,	-0.01,	0.1,	1,	1,
	1,	-0.01,	20,	-0.01,	0.1,	1,	1,
	10,	-0.01,	20,	-0.01,	0.1,	1,	1,
	100,	-0.01,	20,	-0.01,	0.1,	1,	1,
	0.0001,	-1,	20,	-0.01,	0.1,	1,	1,
	0.1,	-1,	20,	-0.01,	0.1,	1,	1,
	1,	-1,	20,	-0.01,	0.1,	1,	1,
	10,	-1,	20,	-0.01,	0.1,	1,	1,
	100,	-1,	20,	-0.01,	0.1,	1,	1,
	0.0001,	0.000001,	20,	-1,	0.1,	1,	1,
	0.1,	0.000001,	20,	-1,	0.1,	1,	1,
	1,	0.000001,	20,	-1,	0.1,	1,	1,
	10,	0.000001,	20,	-1,	0.1,	1,	1,
	100,	0.000001,	20,	-1,	0.1,	1,	1,
	0.0001,	0.01,	20,	-1,	0.1,	1,	1,
	0.1,	0.01,	20,	-1,	0.1,	1,	1,
	1,	0.01,	20,	-1,	0.1,	1,	1,
	10,	0.01,	20,	-1,	0.1,	1,	1,
	100,	0.01,	20,	-1,	0.1,	1,	1,
	0.0001,	1,	20,	-1,	0.1,	1,	1,
	0.1,	1,	20,	-1,	0.1,	1,	1,
	1,	1,	20,	-1,	0.1,	1,	1,
	10,	1,	20,	-1,	0.1,	1,	1,
	100,	1,	20,	-1,	0.1,	1,	1,
	0.0001,	-0.01,	20,	-1,	0.1,	1,	1,
	0.1,	-0.01,	20,	-1,	0.1,	1,	1,
	1,	-0.01,	20,	-1,	0.1,	1,	1,
	10,	-0.01,	20,	-1,	0.1,	1,	1,
	100,	-0.01,	20,	-1,	0.1,	1,	1,
	0.0001,	-1,	20,	-1,	0.1,	1,	1,
	0.1,	-1,	20,	-1,	0.1,	1,	1,
	1,	-1,	20,	-1,	0.1,	1,	1,
	10,	-1,	20,	-1,	0.1,	1,	1,
	100,	-1,	20,	-1,	0.1,	1,	1,
	0.0001,	0.000001,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.1,	0.000001,	20,	0.000001,	0.1,	-0.01,	-0.01,
	1,	0.000001,	20,	0.000001,	0.1,	-0.01,	-0.01,
	10,	0.000001,	20,	0.000001,	0.1,	-0.01,	-0.01,
	100,	0.000001,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.0001,	0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.1,	0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	1,	0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	10,	0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	100,	0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.0001,	1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.1,	1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	1,	1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	10,	1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	100,	1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.0001,	-0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.1,	-0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	1,	-0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	10,	-0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	100,	-0.01,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.0001,	-1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.1,	-1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	1,	-1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	10,	-1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	100,	-1,	20,	0.000001,	0.1,	-0.01,	-0.01,
	0.0001,	0.000001,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.1,	0.000001,	20,	0.01,	0.1,	-0.01,	-0.01,
	1,	0.000001,	20,	0.01,	0.1,	-0.01,	-0.01,
	10,	0.000001,	20,	0.01,	0.1,	-0.01,	-0.01,
	100,	0.000001,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.0001,	0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.1,	0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	1,	0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	10,	0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	100,	0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.0001,	1,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.1,	1,	20,	0.01,	0.1,	-0.01,	-0.01,
	1,	1,	20,	0.01,	0.1,	-0.01,	-0.01,
	10,	1,	20,	0.01,	0.1,	-0.01,	-0.01,
	100,	1,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.0001,	-0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.1,	-0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	1,	-0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	10,	-0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	100,	-0.01,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.0001,	-1,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.1,	-1,	20,	0.01,	0.1,	-0.01,	-0.01,
	1,	-1,	20,	0.01,	0.1,	-0.01,	-0.01,
	10,	-1,	20,	0.01,	0.1,	-0.01,	-0.01,
	100,	-1,	20,	0.01,	0.1,	-0.01,	-0.01,
	0.0001,	0.000001,	20,	1,	0.1,	-0.01,	-0.01,
	0.1,	0.000001,	20,	1,	0.1,	-0.01,	-0.01,
	1,	0.000001,	20,	1,	0.1,	-0.01,	-0.01,
	10,	0.000001,	20,	1,	0.1,	-0.01,	-0.01,
	100,	0.000001,	20,	1,	0.1,	-0.01,	-0.01,
	0.0001,	0.01,	20,	1,	0.1,	-0.01,	-0.01,
	0.1,	0.01,	20,	1,	0.1,	-0.01,	-0.01,
	1,	0.01,	20,	1,	0.1,	-0.01,	-0.01,
	10,	0.01,	20,	1,	0.1,	-0.01,	-0.01,
	100,	0.01,	20,	1,	0.1,	-0.01,	-0.01,
	0.0001,	1,	20,	1,	0.1,	-0.01,	-0.01,
	0.1,	1,	20,	1,	0.1,	-0.01,	-0.01,
	1,	1,	20,	1,	0.1,	-0.01,	-0.01,
	10,	1,	20,	1,	0.1,	-0.01,	-0.01,
	100,	1,	20,	1,	0.1,	-0.01,	-0.01,
	0.0001,	-0.01,	20,	1,	0.1,	-0.01,	-0.01,
	0.1,	-0.01,	20,	1,	0.1,	-0.01,	-0.01,
	1,	-0.01,	20,	1,	0.1,	-0.01,	-0.01,
	10,	-0.01,	20,	1,	0.1,	-0.01,	-0.01,
	100,	-0.01,	20,	1,	0.1,	-0.01,	-0.01,
	0.0001,	-1,	20,	1,	0.1,	-0.01,	-0.01,
	0.1,	-1,	20,	1,	0.1,	-0.01,	-0.01,
	1,	-1,	20,	1,	0.1,	-0.01,	-0.01,
	10,	-1,	20,	1,	0.1,	-0.01,	-0.01,
	100,	-1,	20,	1,	0.1,	-0.01,	-0.01,
	0.0001,	0.000001,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.1,	0.000001,	20,	-0.01,	0.1,	-0.01,	-0.01,
	1,	0.000001,	20,	-0.01,	0.1,	-0.01,	-0.01,
	10,	0.000001,	20,	-0.01,	0.1,	-0.01,	-0.01,
	100,	0.000001,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.0001,	0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.1,	0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	1,	0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	10,	0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	100,	0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.0001,	1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.1,	1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	1,	1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	10,	1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	100,	1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.0001,	-0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.1,	-0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	1,	-0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	10,	-0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	100,	-0.01,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.0001,	-1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.1,	-1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	1,	-1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	10,	-1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	100,	-1,	20,	-0.01,	0.1,	-0.01,	-0.01,
	0.0001,	0.000001,	20,	-1,	0.1,	-0.01,	-0.01,
	0.1,	0.000001,	20,	-1,	0.1,	-0.01,	-0.01,
	1,	0.000001,	20,	-1,	0.1,	-0.01,	-0.01,
	10,	0.000001,	20,	-1,	0.1,	-0.01,	-0.01,
	100,	0.000001,	20,	-1,	0.1,	-0.01,	-0.01,
	0.0001,	0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	0.1,	0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	1,	0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	10,	0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	100,	0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	0.0001,	1,	20,	-1,	0.1,	-0.01,	-0.01,
	0.1,	1,	20,	-1,	0.1,	-0.01,	-0.01,
	1,	1,	20,	-1,	0.1,	-0.01,	-0.01,
	10,	1,	20,	-1,	0.1,	-0.01,	-0.01,
	100,	1,	20,	-1,	0.1,	-0.01,	-0.01,
	0.0001,	-0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	0.1,	-0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	1,	-0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	10,	-0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	100,	-0.01,	20,	-1,	0.1,	-0.01,	-0.01,
	0.0001,	-1,	20,	-1,	0.1,	-0.01,	-0.01,
	0.1,	-1,	20,	-1,	0.1,	-0.01,	-0.01,
	1,	-1,	20,	-1,	0.1,	-0.01,	-0.01,
	10,	-1,	20,	-1,	0.1,	-0.01,	-0.01,
	100,	-1,	20,	-1,	0.1,	-0.01,	-0.01
         )
         p_starting <- matrix(p_matrix, length(p_matrix)/7, 7, byrow=TRUE)
         result_matrix <- matrix(NA, nrow(p_starting), 8)
         result_matrix[,1:7] <- p_starting
      }
   return(result_matrix)
 }



sisterContinuous_logSpace<- function(parameters, model,breakpoint="NULL", E, T, L, transformation_beta="NULL", transformation_alpha="NULL", transformation_beta1 = "NULL", transformation_beta2 = "NULL", transformation_b = "NULL", transformation_a = "NULL", transformation_alpha1 = "NULL", transformation_alpha2 = "NULL")
 {
  if (model == "BM_null") {
     Cstart_B     <- exp(parameters[1])
     Slope_B      <- 0
     B <- Slope_B * L + Cstart_B
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(Cstart_B <= 0) negLogL = 1e20 
    if(is.nan(negLogL)) negLogL = 1e20
  }
  
  if (model == "BM_2rate") {
     c1     <- exp(parameters[1])
     c2      <- exp(parameters[2])
     B <- (c1)*(L <= breakpoint)    +    (c2) * (L > breakpoint)
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
    if(is.nan(negLogL)) negLogL = 1e20
    if(min(B) <= 0 | is.nan(min(B))) negLogL = 1e20
  }
  
  else if (model == "BM_linear") {
     Cstart_B     <- exp(parameters[1] )
     if(transformation_beta != "NULL"){
        Slope_B      <- exp(parameters[2]) - transformation_beta
     }
     if(transformation_beta == "NULL"){
        Slope_B      <- exp(parameters[2] )
     }
     B <- Slope_B * L + Cstart_B
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(Cstart_B <= 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
   }


  else if (model == "BM_linear_breakpoint") {
     #This backtransforms variables
     c1  <- exp(parameters[1] )     #Cstart_B intercept
     breakpoint <- exp(parameters[3] ) #breakpoint latitude
     if(transformation_beta1 != "NULL"){
        b1      <- exp(parameters[2]) - transformation_beta1
     }
     if(transformation_beta1 == "NULL"){
        b1      <- exp(parameters[2] )
     }
     if(transformation_beta2 != "NULL"){
        b2      <- exp(parameters[4]) - transformation_beta2
     }
     if(transformation_beta2 == "NULL"){
        b2      <- exp(parameters[4] )
     }
     c2 = breakpoint * b1 + c1 - breakpoint * b2
     B <- (b1 * L + c1)*(L <= breakpoint)    +    (b2 * L + c2) * (L > breakpoint)
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(c1 < 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
   }


  else if (model == "BM_quadratic") {
     #This now works well
     #where y = c + bX + aX^2 a > 0 parabola curves upward, a < 0 downward. a != 0
     #This backtransforms variables
     c      <- exp(parameters[1] )     #Cstart_B intercept
     if(transformation_b != "NULL"){
         b      <- exp(parameters[2])  - transformation_b     
     }
     if(transformation_b == "NULL"){
         b      <- exp(parameters[2] )     #coefficient
     }
     if(transformation_a != "NULL"){
         a      <- exp(parameters[3])  - transformation_a     
     }
     if(transformation_a == "NULL"){
         a      <- exp(parameters[3] )     #coefficient
     }
     B <- c + b*L + a*L^2
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     #if(a == 0) negLogL = 1e20 
     if(c < 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
   }

  else if (model == "OU_null") {  
    Cstart_B     <- exp(parameters[1] )
    Slope_B      <- 0
    Cstart_A     <- exp(parameters[2] )
    Slope_A      <- 0
    Alpha <- Slope_A * L + Cstart_A
     B     <- Slope_B * L + Cstart_B
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T/2))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) ) #new new
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(is.nan(negLogL)) negLogL = 1e20
     if(Cstart_A <= 0) negLogL = 1e20
     if(Cstart_B <= 0) negLogL = 1e20
   }
   
 else if (model == "OU_linear_beta") {  
   #Only Beta changes linearly with latitude
    Cstart_B     <- exp(parameters[1]) 
    Cstart_A     <- exp(parameters[3]) 
    if(transformation_beta != "NULL"){
        Slope_B      <- exp(parameters[2]) - transformation_beta
    }
    if(transformation_beta == "NULL"){
        Slope_B      <- exp(parameters[2] )
    }
    Slope_A      <- 0
     Alpha <- Slope_A * L + Cstart_A
     B     <- Slope_B * L + Cstart_B
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) ) #new new
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(is.nan(negLogL)) negLogL = 1e20
     if(Cstart_A <= (0)) negLogL = 1e20
     if(Cstart_B <= (0)) negLogL = 1e20
     if(min(Alpha) <= (0)) negLogL = 1e20
     if(min(B) <= (0)) negLogL = 1e20
   }

  else if (model == "OU_linear") {  
    Cstart_B     <- exp(parameters[1]) 
    Cstart_A     <- exp(parameters[3]) 
    if(transformation_beta != "NULL"){
        Slope_B      <- exp(parameters[2]) - transformation_beta
    }
    if(transformation_beta == "NULL"){
        Slope_B      <- exp(parameters[2] )
    }

    if(transformation_alpha != "NULL"){
        Slope_A      <- exp(parameters[4]) - transformation_alpha
    }
    if(transformation_alpha == "NULL"){
        Slope_A      <- exp(parameters[4] )
    }
     Alpha <- Slope_A * L + Cstart_A
     B     <- Slope_B * L + Cstart_B
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) ) #new new
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(is.nan(negLogL)) negLogL = 1e20
     if(Cstart_A <= (0)) negLogL = 1e20
     if(Cstart_B <= (0)) negLogL = 1e20
     if(min(Alpha) <= (0)) negLogL = 1e20
     if(min(B) <= (0)) negLogL = 1e20
   }


  else if (model == "OU_linear_breakpoint") {
     c1  <- exp(parameters[1] )     #Cstart_B intercept
     breakpoint <- exp(parameters[3] ) #breakpoint latitude
     if(transformation_beta1 != "NULL"){
        b1      <- exp(parameters[2]) - transformation_beta1
     }
     if(transformation_beta1 == "NULL"){
        b1      <- exp(parameters[2] )
     }
     if(transformation_beta2 != "NULL"){
        b2      <- exp(parameters[4]) - transformation_beta2
     }
     if(transformation_beta2 == "NULL"){
        b2      <- exp(parameters[4] )
     }

     c1_alpha  <- exp(parameters[5] )     #Cstart_B intercept
     if(transformation_alpha1 != "NULL"){
        b1_alpha      <- exp(parameters[6]) - transformation_alpha1
     }
     if(transformation_alpha1 == "NULL"){
        b1_alpha      <- exp(parameters[6] )
     }
     if(transformation_alpha2 != "NULL"){
        b2_alpha      <- exp(parameters[7]) - transformation_alpha2
     }
     if(transformation_alpha2 == "NULL"){
        b2_alpha      <- exp(parameters[7] )
     }

     c2 = breakpoint * b1 + c1 - breakpoint * b2
     c2_alpha = breakpoint * b1_alpha + c1_alpha - breakpoint * b2_alpha

     B <- (b1 * L + c1)*(L <= breakpoint)    +    (b2 * L + c2) * (L > breakpoint)                         #Beta  for actual data
     Alpha <- (b1_alpha * L + c1_alpha)*(L <= breakpoint)    +    (b2_alpha * L + c2_alpha) * (L > breakpoint) #Alpha for actual data
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(c1 < 0) negLogL = 1e20 
     if(c1_alpha < 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
     if(min(Alpha) <= 0) negLogL = 1e20
   }

  if (model == "OU_2rate") {
     c1     <- exp(parameters[1])
     c2      <- exp(parameters[2])
     c3     <- exp(parameters[3])
     c4      <- exp(parameters[4])
     B <- (c1)*(L <= breakpoint)    +    (c2) * (L > breakpoint)
     Alpha <- (c3)*(L <= breakpoint)    +    (c4) * (L > breakpoint)
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
    if(is.nan(negLogL)) negLogL = 1e20
    if(min(B) <= 0 | is.nan(min(B))) negLogL = 1e20
    if(min(Alpha) <= 0 | is.nan(min(Alpha))) negLogL = 1e20
  }
  
   return(negLogL)
 }




sisterContinuous <- function(parameters, model = c("BM_null", "BM_2rate","BM_linear", "BM_linear_breakpoint",
   "BM_quadratic", "OU_null", "OU_2rate", "OU_linear", "OU_linear_beta", "OU_linear_breakpoint"), breakpoint="NULL", E, T, L)
 {
   #Parameters = a list of starting values for parameter estimates
   #model = "OU" or "BM"
   #range =  a list of the start and endpoints of the gradient over which to calculate rates. These must span the range of values in the dataset.
   #E = list of euclidean distance
   #T = list of ages of independent contrasts / sister pairs
   #L = list of gradient values
   
   #Code updated 12 Feb 2013 to exclude B and alpha values less than 0 (i.e. "if(min(Alpha) <= 0) negLogL = 1e20")
   #A second update to code by transforming parameters so that search in nlm is done in log parameter space, with parameter estimates back transformed after the nlm search
   #The transofrmation method results in much faster likelihood searches and allows us to find the true MLE much more readily than when not transformed for the OU model

  if (model == "BM_null") {
     Cstart_B     <- parameters[1]
     Slope_B      <- 0
     B <- Slope_B * L + Cstart_B
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(Cstart_B <= 0) negLogL = 1e20 
    if(is.nan(negLogL)) negLogL = 1e20
  }

  if (model == "BM_2rate") {
     c1     <- (parameters[1])
     c2      <- (parameters[2])
     B <- (c1)*(L <= breakpoint)    +    (c2) * (L > breakpoint)
     V <- B*T
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
    if(is.nan(negLogL)) negLogL = 1e20
    if(min(B) <= 0 | is.nan(min(B))) negLogL = 1e20
  }
  
  else if (model == "BM_linear") {
     Cstart_B     <- parameters[1] 
     Slope_B      <- parameters[2]
     B <- Slope_B * L + Cstart_B
     V <- B*T 
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(Cstart_B <= 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
   }


  else if (model == "BM_linear_breakpoint") {
     #where y = c + bX + aX^2 a > 0 parabola curves upward, a < 0 downward. a != 0
     #This backtransforms variables
     c1  <- parameters[1]     #Cstart_B intercept
     breakpoint <- parameters[3] #breakpoint latitude
     b1      <- parameters[2]
     b2      <- parameters[4]
     c2 = breakpoint * b1 + c1 - breakpoint * b2
     B <- (b1 * L + c1)*(L <= breakpoint)    +    (b2 * L + c2) * (L > breakpoint)
     V <- B*T
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(c1 < 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
   }


  else if (model == "BM_quadratic") {
     #This now works well
     #where y = c + bX + aX^2 a > 0 parabola curves upward, a < 0 downward. a != 0
     #This backtransforms variables
     c      <- parameters[1] 
     b      <- parameters[2]
     a      <- parameters[3] 
     B <- c + b*L + a*L^2
     V <- B*T
     SD = (V)^0.5 
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     #if(a == 0) negLogL = 1e20 
     if(c < 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
   }

  else if (model == "OU_null") {  
    Cstart_B     <- parameters[1]
    Slope_B      <- 0
    Cstart_A     <- parameters[2]
    Slope_A      <- 0
    Alpha <- Slope_A * L + Cstart_A
     B     <- Slope_B * L + Cstart_B
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) ) #new new
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(is.nan(negLogL)) negLogL = 1e20
     if(Cstart_A <= 0) negLogL = 1e20
     if(Cstart_B <= 0) negLogL = 1e20
   }
   
  else if (model == "OU_linear") {  
    Cstart_B     <- parameters[1]
    Cstart_A     <- parameters[3]
    Slope_B      <- parameters[2]
    Slope_A      <- parameters[4]
     Alpha <- Slope_A * L + Cstart_A
     B     <- Slope_B * L + Cstart_B
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) ) #new new
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(is.nan(negLogL)) negLogL = 1e20
     if(Cstart_A <= (0)) negLogL = 1e20
     if(Cstart_B <= (0)) negLogL = 1e20
     if(min(Alpha) <= (0)) negLogL = 1e20
     if(min(B) <= (0)) negLogL = 1e20
   }

 else if (model == "OU_linear_beta") {  
   #Only Beta changes linearly with latitude
    Cstart_B     <- parameters[1]
    Cstart_A     <- parameters[3] 
    Slope_B      <- parameters[2]
    Slope_A      <- 0
     Alpha <- Slope_A * L + Cstart_A
     B     <- Slope_B * L + Cstart_B
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) ) #new new
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(is.nan(negLogL)) negLogL = 1e20
     if(Cstart_A <= (0)) negLogL = 1e20
     if(Cstart_B <= (0)) negLogL = 1e20
     if(min(Alpha) <= (0)) negLogL = 1e20
     if(min(B) <= (0)) negLogL = 1e20
   }


  else if (model == "OU_linear_breakpoint") {
     c1  <- parameters[1]
     breakpoint <- parameters[3]
        b1      <- parameters[2]
        b2      <- parameters[4]
     c1_alpha  <- parameters[5]     #Cstart_B intercept
        b1_alpha      <- parameters[6]
        b2_alpha      <- parameters[7]
    
     c2 = breakpoint * b1 + c1 - breakpoint * b2
     c2_alpha = breakpoint * b1_alpha + c1_alpha - breakpoint * b2_alpha

     B <- (b1 * L + c1)*(L <= breakpoint)    +    (b2 * L + c2) * (L > breakpoint)                         #Beta  for actual data
     Alpha <- (b1_alpha * L + c1_alpha)*(L <= breakpoint)    +    (b2_alpha * L + c2_alpha) * (L > breakpoint) #Alpha for actual data
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
     if(c1 < 0) negLogL = 1e20 
     if(c1_alpha < 0) negLogL = 1e20 
     if(is.nan(negLogL)) negLogL = 1e20
     if(min(B) <= 0) negLogL = 1e20
     if(min(Alpha) <= 0) negLogL = 1e20
   }

  if (model == "OU_2rate") {
     c1     <- (parameters[1])
     c2      <- (parameters[2])
     c3     <- (parameters[3])
     c4      <- (parameters[4])
     B <- (c1)*(L <= breakpoint)    +    (c2) * (L > breakpoint)
     Alpha <- (c3)*(L <= breakpoint)    +    (c4) * (L > breakpoint)
     V <- (B / (2*Alpha)) * (1-exp(-2*Alpha*T))  #OU model
     VAR = V
     kk <- (1/((VAR*2*pi)^0.5))  * 2*( exp(-(E^2/(2*VAR))) )
     logL <- log(kk)
     LogL <- sum(logL)
     negLogL = -LogL
    if(is.nan(negLogL)) negLogL = 1e20
    if(min(B) <= 0 | is.nan(min(B))) negLogL = 1e20
    if(min(Alpha) <= 0 | is.nan(min(Alpha))) negLogL = 1e2
  }
   return(negLogL)
 }





find.mle.sister <- function(MODEL, p_starting="NULL", Beta_starting = "NULL", Alpha_starting = "NULL", E, T, L){
  #start BM_null
  if(MODEL == "BM_null"){
      if(MODEL == "BM_null" & p_starting[1] != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 3)
         result_matrix[,1] <- p_starting
         }
      if(MODEL == "BM_null" & p_starting[1] == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1]
         TRANSFORMATION = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1])), model=c("BM_null"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         try(if(is.numeric(res$code)<3) result_matrix[i,3] <- res$minimum else result_matrix[i,3] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,3]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1]
         TRANSFORMATION = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1])), model=c("BM_null"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]))
   }#End BM_null
  ################################### 
  #start BM_linear
  if(MODEL == "BM_linear"){
      if(MODEL == "BM_linear" & p_starting[1] != "NULL"){ 
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 3)
         result_matrix[,1:2] <- p_starting
      }
      if(MODEL == "BM_linear" & p_starting[1] == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:2]
         if(p[2] <= 0) {
            TRANSFORMATION  = 0- p[2] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION)), model=c("BM_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] > 0)  {
            TRANSFORMATION = "NULL"
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2])), model=c("BM_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         try(if(is.numeric(res$code)<3) result_matrix[i,3] <- res$minimum else result_matrix[i,3] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,3]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:2]
      if(p[2] <= 0) {
         TRANSFORMATION = 0 - p[2] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION)), model=c("BM_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), exp(res$estimate[2])-TRANSFORMATION)
      }
      if(p[2] > 0)  {
         TRANSFORMATION = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2])), model=c("BM_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]),exp(res$estimate[2]))
      }
   }#End BM_linear
   ##################################
  #start OU_NULL
  if(MODEL == "OU_null"){
      if(MODEL == "OU_null" & p_starting != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 3)
         result_matrix[,1:2] <- p_starting
      }
      if(MODEL == "OU_null" & p_starting == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:2]
         TRANSFORMATION = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("OU_null"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
         try(if(is.numeric(res$code)<3) result_matrix[i,3] <- res$minimum else result_matrix[i,3] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,3]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:2]
      TRANSFORMATION = "NULL"
      res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("OU_null"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION, hessian = FALSE, iterlim=50000)), silent = TRUE)
      res$estimate <- c(exp(res$estimate))
   }#End_OU_null


  ################################### 
  #start OU_linear_BETA
  if(MODEL == "OU_linear_beta"){
      if(MODEL == "OU_linear_beta" & p_starting != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 4)
         result_matrix[,1:4] <- p_starting
      }
      if(MODEL == "OU_linear_beta" & p_starting == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:3]

         if(p[2] <= 0){
            TRANSFORMATION_BETA  = 0 - p[2] + 0.0001
            TRANSFORMATION_ALPHA = "NULL"
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA), log(p[3])), model=c("OU_linear_beta"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION_BETA, transformation_alpha = "NULL", hessian = FALSE, iterlim=50000, ndigit = 25)), silent = TRUE)
         }
         if(p[2] >  0)  {
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("OU_linear_beta"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         try(if(is.numeric(res$code)<3) result_matrix[i,5] <- res$minimum else result_matrix[i,4] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,4]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:3]
      if(p[2] <= 0){
         TRANSFORMATION_BETA  = 0 - p[2] + 0.0001
         TRANSFORMATION_ALPHA = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA), log(p[3])), model=c("OU_linear_beta"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION_BETA, transformation_alpha = "NULL", hessian = FALSE, iterlim=50000, ndigit = 25)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2])-TRANSFORMATION_BETA), exp(res$estimate[3]))
      }
      if(p[2] >  0)  {
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("OU_linear_beta"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate))
      }
   }#End OU_linear_BETA

  ################################### 
  #start OU_linear
  if(MODEL == "OU_linear"){
      if(MODEL == "OU_linear" & p_starting != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 5)
         result_matrix[,1:4] <- p_starting
      }
      if(MODEL == "OU_linear" & p_starting == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:4]

         if(p[2] <= 0 & p[4] > 0) {
            TRANSFORMATION_BETA  = 0 - p[2] + 0.0001
            TRANSFORMATION_ALPHA = "NULL"
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA), log(p[3]), log(p[4])), model=c("OU_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION_BETA, transformation_alpha = "NULL", hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] >  0 & p[4] > 0)  {
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("OU_linear"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] > 0 & p[4] <= 0) {
            TRANSFORMATION_BETA  = "NULL"
            TRANSFORMATION_ALPHA = 0 - p[4] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]), log(p[3]), log(p[4]+TRANSFORMATION_ALPHA)), model=c("OU_linear"), E=E, T=T, L=L, transformation_beta = "NULL", transformation_alpha = TRANSFORMATION_ALPHA, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] <= 0 & p[4] <= 0) {
            TRANSFORMATION_BETA  = 0 - p[2] + 0.0001
            TRANSFORMATION_ALPHA = 0 - p[4] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA), log(p[3]), log(p[4]+TRANSFORMATION_ALPHA)), model=c("OU_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION_BETA, transformation_alpha = TRANSFORMATION_ALPHA, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         try(if(is.numeric(res$code)<3) result_matrix[i,5] <- res$minimum else result_matrix[i,5] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,5]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:4]
      if(p[2] <= 0 & p[4] > 0) {
         TRANSFORMATION_BETA  = 0 - p[2] + 0.0001
         TRANSFORMATION_ALPHA = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA), log(p[3]), log(p[4])), model=c("OU_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION_BETA, transformation_alpha = "NULL", hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2])-TRANSFORMATION_BETA), exp(res$estimate[3]), exp(res$estimate[4]))
      }
      if(p[2] >  0 & p[4] > 0)  {
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("OU_linear"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate))
      }
      if(p[2] > 0 & p[4] <= 0) {
         TRANSFORMATION_BETA  = "NULL"
         TRANSFORMATION_ALPHA = 0 - p[4] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]), log(p[3]), log(p[4]+TRANSFORMATION_ALPHA)), model=c("OU_linear"), E=E, T=T, L=L, transformation_beta = "NULL", transformation_alpha = TRANSFORMATION_ALPHA, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), exp(res$estimate[2]), exp(res$estimate[3]), (exp(res$estimate[4]) - TRANSFORMATION_ALPHA))
      }
      if(p[2] <= 0 & p[4] <= 0) {
         TRANSFORMATION_BETA  = 0 - p[2] + 0.0001
         TRANSFORMATION_ALPHA = 0 - p[4] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA), log(p[3]), log(p[4]+TRANSFORMATION_ALPHA)), model=c("OU_linear"), E=E, T=T, L=L, transformation_beta = TRANSFORMATION_BETA, transformation_alpha = TRANSFORMATION_ALPHA, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2]) - TRANSFORMATION_BETA), exp(res$estimate[3]), (exp(res$estimate[4]) - TRANSFORMATION_ALPHA))
      }
   }#End OU_linear
   ###########################################
  #start BM_linear_breakpoint
  if(MODEL == "BM_linear_breakpoint"){
      if(MODEL == "BM_linear_breakpoint" & p_starting != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 5)
         result_matrix[,1:4] <- p_starting
      }
      if(MODEL == "BM_linear_breakpoint" & p_starting == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:4]

         if(p[2] <= 0 & p[4] > 0) {
            TRANSFORMATION_BETA1  = 0 - p[2] + 0.0001
            TRANSFORMATION_BETA2 = "NULL"
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA1), log(p[3]), log(p[4])), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = TRANSFORMATION_BETA1, transformation_beta2 = "NULL", hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] >  0 & p[4] > 0)  {
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] > 0 & p[4] <= 0) {
            TRANSFORMATION_BETA1  = "NULL"
            TRANSFORMATION_BETA2 = 0 - p[4] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]), log(p[3]), log(p[4]+TRANSFORMATION_BETA2)), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = "NULL", transformation_beta2 = TRANSFORMATION_BETA2, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] <= 0 & p[4] <= 0) {
            TRANSFORMATION_BETA1  = 0 - p[2] + 0.0001
            TRANSFORMATION_BETA2 = 0 - p[4] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA1), log(p[3]), log(p[4]+TRANSFORMATION_BETA2)), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = TRANSFORMATION_BETA1, transformation_beta2 = TRANSFORMATION_BETA2, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         try(if(is.numeric(res$code)<3) result_matrix[i,5] <- res$minimum else result_matrix[i,5] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,5]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:4]
      if(p[2] <= 0 & p[4] > 0) {
         TRANSFORMATION_BETA1  = 0 - p[2] + 0.0001
         TRANSFORMATION_BETA2 = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA1), log(p[3]), log(p[4])), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = TRANSFORMATION_BETA1, transformation_beta2 = "NULL", hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2])-TRANSFORMATION_BETA1), exp(res$estimate[3]), exp(res$estimate[4]))
      }
      if(p[2] >  0 & p[4] > 0)  {
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate))
      }
      if(p[2] > 0 & p[4] <= 0) {
         TRANSFORMATION_BETA1  = "NULL"
         TRANSFORMATION_BETA2 = 0 - p[4] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]), log(p[3]), log(p[4]+TRANSFORMATION_BETA2)), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = "NULL", transformation_beta2 = TRANSFORMATION_BETA2, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), exp(res$estimate[2]), exp(res$estimate[3]), (exp(res$estimate[4]) - TRANSFORMATION_BETA2))
      }
      if(p[2] <= 0 & p[4] <= 0) {
         TRANSFORMATION_BETA1  = 0 - p[2] + 0.0001
         TRANSFORMATION_BETA2 = 0 - p[4] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_BETA1), log(p[3]), log(p[4]+TRANSFORMATION_BETA2)), model=c("BM_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = TRANSFORMATION_BETA1, transformation_beta2 = TRANSFORMATION_BETA2, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2]) - TRANSFORMATION_BETA1), exp(res$estimate[3]), (exp(res$estimate[4]) - TRANSFORMATION_BETA2))
      }
   }#End BM_linear_breakpoint
   ###########################################
  #start BM_quadratic
  if(MODEL == "BM_quadratic"){
      if(MODEL == "BM_quadratic" & p_starting != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 4)
         result_matrix[,1:3] <- p_starting
      }
      if(MODEL == "BM_quadratic" & p_starting == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:3]

         if(p[2] <= 0 & p[3] > 0) {
            TRANSFORMATION_b  = 0 - p[2] + 0.0001
            TRANSFORMATION_a = "NULL"
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_b), log(p[3])), model=c("BM_quadratic"), E=E, T=T, L=L, transformation_b = TRANSFORMATION_b, transformation_a = "NULL", hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] >  0 & p[3] > 0)  {
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("BM_quadratic"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] > 0 & p[3] <= 0) {
            TRANSFORMATION_b  = "NULL"
            TRANSFORMATION_a = 0 - p[3] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]), log(p[3]+TRANSFORMATION_a)), model=c("BM_quadratic"), E=E, T=T, L=L, transformation_b = "NULL", transformation_a = TRANSFORMATION_a, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         if(p[2] <= 0 & p[3] <= 0) {
            TRANSFORMATION_b  = 0 - p[2] + 0.0001
            TRANSFORMATION_a  = 0 - p[3] + 0.0001
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_b), log(p[3]+TRANSFORMATION_a)), model=c("BM_quadratic"), E=E, T=T, L=L, transformation_b = TRANSFORMATION_b, transformation_a = TRANSFORMATION_a, hessian = FALSE, iterlim=50000)), silent = TRUE)
         }
         try(if(is.numeric(res$code)<3) result_matrix[i,4] <- res$minimum else result_matrix[i,4] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,4]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:3]
      if(p[2] <= 0 & p[3] > 0) {
         TRANSFORMATION_b  = 0 - p[2] + 0.0001
         TRANSFORMATION_a = "NULL"
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_b), log(p[3])), model=c("BM_quadratic"), E=E, T=T, L=L, transformation_b = TRANSFORMATION_b, transformation_a = "NULL", hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2])-TRANSFORMATION_b), exp(res$estimate[3]))
      }
      if(p[2] >  0 & p[3] > 0)  {
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p)), model=c("BM_quadratic"), E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate))
      }
      if(p[2] > 0 & p[3] <= 0) {
         TRANSFORMATION_b  = "NULL"
         TRANSFORMATION_a = 0 - p[3] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]), log(p[3]+TRANSFORMATION_a)), model=c("BM_quadratic"), E=E, T=T, L=L, transformation_b = "NULL", transformation_a = TRANSFORMATION_a, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), exp(res$estimate[2]), (exp(res$estimate[3]) - TRANSFORMATION_a))
      }
      if(p[2] <= 0 & p[3] <= 0) {
         TRANSFORMATION_b  = 0 - p[2] + 0.0001
         TRANSFORMATION_a = 0 - p[3] + 0.0001
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p[1]), log(p[2]+TRANSFORMATION_b), log(p[3]+TRANSFORMATION_a)), model=c("BM_quadratic"), E=E, T=T, L=L, transformation_b = TRANSFORMATION_b, transformation_a = TRANSFORMATION_a, hessian = FALSE, iterlim=50000)), silent = TRUE)
         res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2]) - TRANSFORMATION_b), (exp(res$estimate[3]) - TRANSFORMATION_a))
      }
   }#End BM_quadratic

  ############################
  #start BM_2rate
  if(MODEL == "BM_2rate"){
      LS <- sort(L)
      N_LS <- length(LS)
      LS_acceptable <- LS[11:(N_LS - 10)]
      BREAKPOINTS <- LS_acceptable[-length(LS_acceptable)] + (LS_acceptable[-1] - LS_acceptable[-length(LS_acceptable)] ) / 2
      if(p_starting == "NULL"){
         RATE1 <- c(0.001, 0.01, 0.1, 1, 10, 100, 1000)
         RATE2 <- c(0.001, 0.01, 0.1, 1, 10, 100, 1000)
      }
      if(p_starting != "NULL"){
         RATE1 <- Beta_starting
         RATE2 <- Beta_starting
      }
      negLogL = 1e20
      for(a in 1:length(BREAKPOINTS)){
         BREAKPOINT_a <- BREAKPOINTS[a]
         for(b in 1:length(RATE1)){
            RATE1_b <- RATE1[b]
            for(c in 1:length(RATE2)){
               RATE2_c <- RATE2[c]
               parameters = c(RATE1_b, RATE2_c)
               res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(parameters)), model=c("BM_2rate"), breakpoint = BREAKPOINT_a, E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
               #try(if(is.numeric(res$code)<3) result_matrix[i,4] <- res$minimum else result_matrix[i,4] <- NA, silent = TRUE)
               if(res$minimum < negLogL){
                  negLogL <- res$minimum
                  breakpoint <- BREAKPOINT_a
                  best_result <- res
               }
            }
         }
      }
   best_result$estimate <- exp(best_result$estimate)
   res <- best_result
   res$estimate[3] <- breakpoint
   }#End BM_2rate

  ############################
  #start OU_2rate
  if(MODEL == "OU_2rate"){
      if(p_starting != "NULL"){
         RATE1_Beta <- Beta_starting
         RATE2_Beta <- Beta_starting
         RATE1_Alpha <- Alpha_starting
         RATE2_Alpha <- Alpha_starting
      }
      if(p_starting == "NULL"){
         RATE1_Beta <- c(0.01, 0.1, 1, 10, 100)
         RATE2_Beta <- c(0.01, 0.1, 1, 10, 100)
         RATE1_Alpha <- c(0.01, 0.1, 1, 10)
         RATE2_Alpha <- c(0.01, 0.1, 1, 10)
      }
      LS <- sort(L)
      N_LS <- length(LS)
      LS_acceptable <- LS[11:(N_LS - 10)]
      MaxL <- max(LS_acceptable)
      MinL <- min(LS_acceptable)
      RangeL <- MaxL - MinL
      Div <- RangeL/6
      Break1 <- MinL + Div
      Break2 <- Break1 + Div
      Break3 <- Break2 + Div
      Break4 <- Break3 + Div
      Break5 <- Break4 + Div
      BREAKPOINTS <- c(Break1, Break2, Break3, Break4, Break5)

      negLogL = 1e20
         for(a in 1:length(BREAKPOINTS)){
            BREAKPOINT_a <- BREAKPOINTS[a]
            for(b in 1:length(RATE1_Beta)){
               RATE1_Beta_b <- RATE1_Beta[b]
               for(c in 1:length(RATE2_Beta)){
                  RATE2_Beta_c <- RATE2_Beta[c]
                  for(d in 1:length(RATE1_Alpha)){
                     RATE1_Alpha_d <- RATE1_Alpha[d]
                     for(e in 1:length(RATE2_Alpha)){
                        RATE2_Alpha_e <- RATE2_Alpha[e]
                        parameters = c(RATE1_Beta_b, RATE2_Beta_c, RATE1_Alpha_d, RATE2_Alpha_e)
                        res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(parameters)), model=c("OU_2rate"), breakpoint = BREAKPOINT_a, E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
                        if(res$minimum < negLogL){
                           negLogL <- res$minimum
                           breakpoint <- BREAKPOINT_a
                           best_result <- res
                        }
                     }
                  }
               }
            }
         }
         best_result$estimate <- exp(best_result$estimate)

         #this bit now exhaustively searches arround the best of the 5 breakpoints above.
         MIN <- breakpoint - Div
         MAX <- breakpoint + Div
         LS <- sort(L[(L < MAX & L > MIN)])
         BREAKPOINTS <- LS[-length(LS)] + (LS[-1] - LS[-length(LS)] ) / 2
         RATE1_Beta <- c((best_result$estimate[1] / 10), best_result$estimate[1], (best_result$estimate[1] *10))
         RATE2_Beta <- c((best_result$estimate[2] / 10), best_result$estimate[2], (best_result$estimate[2] *10))
         RATE1_Alpha <- c((best_result$estimate[3] / 10), best_result$estimate[3], (best_result$estimate[3] *10))
         RATE2_Alpha <- c((best_result$estimate[4] / 10), best_result$estimate[4], (best_result$estimate[4] *10))
         negLogL = 1e20
         for(a in 1:length(BREAKPOINTS)){
            BREAKPOINT_a <- BREAKPOINTS[a]
            for(b in 1:length(RATE1_Beta)){
               RATE1_Beta_b <- RATE1_Beta[b]
               for(c in 1:length(RATE2_Beta)){
                  RATE2_Beta_c <- RATE2_Beta[c]
                  for(d in 1:length(RATE1_Alpha)){
                     RATE1_Alpha_d <- RATE1_Alpha[d]
                     for(e in 1:length(RATE2_Alpha)){
                        RATE2_Alpha_e <- RATE2_Alpha[e]
                        parameters = c(RATE1_Beta_b, RATE2_Beta_c, RATE1_Alpha_d, RATE2_Alpha_e)
                        res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(parameters)), model=c("OU_2rate"), breakpoint = BREAKPOINT_a, E=E, T=T, L=L, hessian = FALSE, iterlim=50000)), silent = TRUE)
                        if(res$minimum < negLogL){
                           negLogL <- res$minimum
                           breakpoint <- BREAKPOINT_a
                           best_result <- res
                        }
                     }
                  }
               }
            }
         }
         best_result$estimate <- exp(best_result$estimate)
         res = best_result
         res$estimate[5] <- breakpoint
      }

  ############################
  #start OU_linear_breakpoint
  if(MODEL == "OU_linear_breakpoint"){
      if(MODEL == "OU_linear_breakpoint" & p_starting != "NULL"){
         p_starting = p_starting
         result_matrix <- matrix(NA, nrow(p_starting), 8)
         result_matrix[,1:7] <- p_starting
      }
      if(MODEL == "OU_linear_breakpoint" & p_starting == "NULL"){result_matrix <- starting.values(MODEL)}
      for(i in 1:nrow(result_matrix)){
         res = "NA"
         p = result_matrix[i,1:7]

         TRANSFORMATION_BETA1 = 0
         TRANSFORMATION_BETA2 = 0
         TRANSFORMATION_ALPHA1 = 0
         TRANSFORMATION_ALPHA2 = 0
         if(p[2] <= 0){TRANSFORMATION_BETA1  = 0 - p[2] + 0.0001}
         if(p[4] <= 0){TRANSFORMATION_BETA2  = 0 - p[4] + 0.0001}
         if(p[6] <= 0){TRANSFORMATION_ALPHA1  = 0 - p[6] + 0.0001}
         if(p[7] <= 0){TRANSFORMATION_ALPHA2  = 0 - p[7] + 0.0001}
         p2 <- c(p[1], p[2]+TRANSFORMATION_BETA1, p[3], p[4]+TRANSFORMATION_BETA2, p[5], p[6]+ TRANSFORMATION_ALPHA1, p[7]+TRANSFORMATION_ALPHA1)
            res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p2)), model=c("OU_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = TRANSFORMATION_BETA1, transformation_beta2 = TRANSFORMATION_BETA2, transformation_alpha1 = TRANSFORMATION_ALPHA1, transformation_alpha2 = TRANSFORMATION_ALPHA2, hessian = FALSE, iterlim=50000)), silent = TRUE)
         try(if(is.numeric(res$code)<3) result_matrix[i,8] <- res$minimum else result_matrix[i,8] <- NA, silent = TRUE)
      }
      result_matrix_ordered <- result_matrix[order(as.numeric(result_matrix[,8]), decreasing = FALSE, na.last = TRUE),];
      p <- result_matrix_ordered[1,1:7]
        res = "NA"
         TRANSFORMATION_BETA1 = 0
         TRANSFORMATION_BETA2 = 0
         TRANSFORMATION_ALPHA1 = 0
         TRANSFORMATION_ALPHA2 = 0
         if(p[2] <= 0){TRANSFORMATION_BETA1  = 0 - p[2] + 0.0001}
         if(p[4] <= 0){TRANSFORMATION_BETA2  = 0 - p[4] + 0.0001}
         if(p[6] <= 0){TRANSFORMATION_ALPHA1  = 0 - p[6] + 0.0001}
         if(p[7] <= 0){TRANSFORMATION_ALPHA2  = 0 - p[7] + 0.0001}
         p2 <- c(p[1], p[2]+TRANSFORMATION_BETA1, p[3], p[4]+TRANSFORMATION_BETA2, p[5], p[6]+ TRANSFORMATION_ALPHA1, p[7]+TRANSFORMATION_ALPHA1)
         res = try(suppressWarnings(nlm(f = sisterContinuous_logSpace, p = c(log(p2)), model=c("OU_linear_breakpoint"), E=E, T=T, L=L, transformation_beta1 = TRANSFORMATION_BETA1, transformation_beta2 = TRANSFORMATION_BETA2, transformation_alpha1 = TRANSFORMATION_ALPHA1, transformation_alpha2 = TRANSFORMATION_ALPHA2, hessian = FALSE, iterlim=50000)), silent = TRUE)
       res$estimate <- c(exp(res$estimate[1]), (exp(res$estimate[2]) - TRANSFORMATION_BETA1), exp(res$estimate[3]), (exp(res$estimate[4]) - TRANSFORMATION_BETA2), exp(res$estimate[5]),exp(res$estimate[6])- TRANSFORMATION_ALPHA1,exp(res$estimate[3])- TRANSFORMATION_ALPHA2)
   }#End OU_linear_breakpoint

   return(res)
}




MScorrection <- function(nA,nB, VarA, VarB, E_actual){
	#Jason T. Weir June 6 2010 based on ideas of Trevor Price
	#Function corrects for finite sample size in Euclidean distances given known variances in each sample
	#nA = number individuals in species A
	#nB = number individuals in species B
	#VarA = variance species A
	#VarB = variance species B
	#E_actual = measured Euclidean distance

	k <- 2
	N <- nA +nB
	MSwithin <- ( VarA * (nA - 1) + VarB * (nB - 1) ) / ( N-k )
	GRAND_MEAN <- (nB*abs(E_actual)) / (nA+nB)
	MSbetween <- (nA * (0 - GRAND_MEAN)^2) + (nB * (abs(E_actual) - GRAND_MEAN)^2) #this is always correct
	#MSbetween <- (nA * (0 - 0.5*abs(E_actual))^2) + (nB * (abs(E_actual) - 0.5*abs(E_actual))^2) #This is correct only if nA=nB
	No <- (nA+nB) - (nA^2+nB^2)/(nA+nB)
	SA2 <- 2* (MSbetween - MSwithin) / No
	for(i in 1:length(SA2)){
		if(SA2[i] < 0) { SA2[i] <- 0 }
		}
	SA <- SA2^0.5
	return(SA)
}

MScorrection_MSwithin <- function(nA,nB, MSwithin, E_actual){
	#Jason T. Weir June 6 2010 based on ideas of Trevor Price
	#Function corrects for finite sample size in Euclidean distances given known variances in each sample
	#nA = number individuals in species A
	#nB = number individuals in species B
	#VarA = variance species A
	#VarB = variance species B
	#E_actual = measured Euclidean distance

	k <- 2
	N <- nA +nB
        MSwithin = MSwithin
	#MSwithin <- ( VarA * (nA - 1) + VarB * (nB - 1) ) / ( N-k )
	GRAND_MEAN <- (nB*abs(E_actual)) / (nA+nB)
	MSbetween <- (nA * (0 - GRAND_MEAN)^2) + (nB * (abs(E_actual) - GRAND_MEAN)^2) #this is always correct
	#MSbetween <- (nA * (0 - 0.5*abs(E_actual))^2) + (nB * (abs(E_actual) - 0.5*abs(E_actual))^2) #This is correct only if nA=nB
	No <- (nA+nB) - (nA^2+nB^2)/(nA+nB)
	SA2 <- 2* (MSbetween - MSwithin) / No
	for(i in 1:length(SA2)){
		if(SA2[i] < 0) { SA2[i] <- 0 }
		}
	SA <- SA2^0.5
	return(SA)
}



model.test.sisters <- function(E, T, L, models = c("BM_null", "BM_linear", "BM_2rate", "BM_linear_breakpoint", "BM_quadratic", "OU_null", "OU_linear_beta", "OU_linear", "OU_2rate", "OU_linear_breakpoint"), starting=list("NULL"), Beta_starting = "NULL", Alpha_starting = "NULL"){
   RESULTS_SUMMARY <- matrix(NA,length(models),32)
   colnames(RESULTS_SUMMARY) <- c("MODEL","logLik","n","AIC","AICc","b1","b1_slope","breakpoint","b2","b2_slope","quadratic_term","a1","a1_slope","a2",	"a2_slope","Quadratic_c","Quadratic_b","Quadratic_a","var_b1","var_b1_slope","var_breakpoint","var_b2","var_b2_slope","var_quadratic_term","var_a1","var_a1_slope","var_a2","var_a2_slope","var_Quadratic_c","var_Quadratic_b","var_Quadratic_a","CHECK") 
   if(length(starting) == 1){
      N <- length(models)
      gg <- "NULL"
      if(starting[1] == "NULL"){starting[1:N] <- "NULL"}
   }
  j = 1
  if(sum(models == "BM_null") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="BM_null", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="BM_null", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "BM_null"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 1
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("BM_null"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),1,1), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "BM_linear") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="BM_linear", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="BM_linear", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "BM_linear"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 2
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,7] <- res$estimate[2]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6,7)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("BM_linear"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),2,2), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 20)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "BM_2rate") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="BM_2rate", Beta_starting, E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="BM_2rate", Beta_starting = "NULL",  E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "BM_2rate"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 3
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,8] <- res$estimate[3]
    RESULTS_SUMMARY[j,9] <- res$estimate[2]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6, 8)]))
       breakpoint2 = RESULTS_SUMMARY[j,9]
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("BM_2rate"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),2,2), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 22)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "BM_linear_breakpoint") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="BM_linear_breakpoint", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="BM_linear_breakpoint", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "BM_linear_breakpoint"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 4
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,7] <- res$estimate[2]
    RESULTS_SUMMARY[j,8] <- res$estimate[3]
    RESULTS_SUMMARY[j,10] <- res$estimate[4]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6,7,8,10)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("BM_linear_breakpoint"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),4,4), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 20, 21, 23)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "BM_quadratic") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="BM_quadratic", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="BM_quadratic", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "BM_quadratic"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 3
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,16] <- res$estimate[1]
    RESULTS_SUMMARY[j,17] <- res$estimate[2]
    RESULTS_SUMMARY[j,18] <- res$estimate[3]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(16,17,18)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("BM_quadratic"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),3,3), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(29, 30, 31)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "OU_null") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="OU_null", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="OU_null", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "OU_null"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 2
    RESULTS_SUMMARY[j,4]  <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,12] <- res$estimate[2]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6,12)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("OU_null"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),2,2), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 25)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "OU_linear_beta") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="OU_linear_beta", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="OU_linear_beta", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "OU_linear_beta"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 3
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,7] <- res$estimate[2]
    RESULTS_SUMMARY[j,12] <- res$estimate[3]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6,7,12)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("OU_linear_beta"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),3,3), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 20, 25)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "OU_linear") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="OU_linear", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="OU_linear", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "OU_linear"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 4
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,7] <- res$estimate[2]
    RESULTS_SUMMARY[j,12] <- res$estimate[3]
    RESULTS_SUMMARY[j,13] <- res$estimate[4]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6,7,12,13)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("OU_linear"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),4,4), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 20, 25, 26)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "OU_2rate") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="OU_2rate", Beta_starting, Alpha_starting, E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="OU_2rate", Beta_starting = "NULL", Alpha_starting = "NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "OU_2rate"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 5
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,8] <- res$estimate[5]
    RESULTS_SUMMARY[j,9] <- res$estimate[2]
    RESULTS_SUMMARY[j,12] <- res$estimate[3]
    RESULTS_SUMMARY[j,14] <- res$estimate[4]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6, 9, 12, 14)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, breakpoint = res$estimate[5], model=c("OU_2rate"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),4,4), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19,22,25,27)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
  if(sum(models == "OU_linear_breakpoint") == 1){
   if(starting[[j]][1] != "NULL"){res <- find.mle.sister(MODEL="OU_linear_breakpoint", p_starting=starting[[j]], E=E, T=T, L=L)}
   if(starting[[j]][1] == "NULL"){res <- find.mle.sister(MODEL="OU_linear_breakpoint", p_starting="NULL", E=E, T=T, L=L)}
    RESULTS_SUMMARY[j,1] <- "OU_linear_breakpoint"
    RESULTS_SUMMARY[j,2] <- -res$minimum
    RESULTS_SUMMARY[j,3] <- 7
    RESULTS_SUMMARY[j,4] <- 2 * as.numeric(RESULTS_SUMMARY[j,3]) - 2*as.numeric(RESULTS_SUMMARY[j,2])
    RESULTS_SUMMARY[j,5] <- as.numeric(RESULTS_SUMMARY[j,4]) + (2 * as.numeric(RESULTS_SUMMARY[j,3])*(as.numeric(RESULTS_SUMMARY[j,3]) + 1)) / (length(L) - as.numeric(RESULTS_SUMMARY[j,3]) - 1)
    RESULTS_SUMMARY[j,6] <- res$estimate[1]
    RESULTS_SUMMARY[j,7] <- res$estimate[2]
    RESULTS_SUMMARY[j,8] <- res$estimate[3]
    RESULTS_SUMMARY[j,10] <- res$estimate[4]
    RESULTS_SUMMARY[j,12] <- res$estimate[5]
    RESULTS_SUMMARY[j,13] <- res$estimate[6]
    RESULTS_SUMMARY[j,15] <- res$estimate[7]
       p = as.numeric(c(RESULTS_SUMMARY[j,c(6,7,8,10,12,13,15)]))
       vcv = "NA"
       res2 = try(suppressWarnings(nlm(f = sisterContinuous, p = p, model=c("OU_linear_breakpoint"), E=E, T=T, L=L, hessian = TRUE, iterlim=50000)), silent = TRUE)
       try(if(is.numeric(res$code)<3) vcv=matrix(solve(res2$hessian),7,7), silent = TRUE)
       if(is.numeric(vcv)){
           RESULTS_SUMMARY[j,c(19, 20, 21, 23, 25, 26, 28)] <- diag(vcv)
           RESULTS_SUMMARY[j,32] <- (as.numeric(RESULTS_SUMMARY[j,2]) - -res2$minimum) < 0.00001 
       }
  j = j+1
  }
return(RESULTS_SUMMARY)
}

sim.sisters <- function(L, T, parameters, model, MULT=1)
{
   if(model=="BM_null"){
      B <- parameters[1]
      VAR_NORM = B*T
   }
   if(model=="BM_linear"){
      cB <- parameters[1]
      SlopeB <- parameters[2]
      B = L*SlopeB + cB
      VAR_NORM = B*T
   }
   if(model=="BM_2rate"){
      cB1 <- parameters[1]
      cB2 <- parameters[2]
      breakpoint <- parameters[3]
      B <- (cB1)*(L <= breakpoint)    +    (cB2) * (L > breakpoint)
      VAR_NORM = B*T
   }
   if(model=="BM_linear_breakpoint"){
      cB1        <- parameters[1]     
      breakpoint <- parameters[3] 
      SlopeB1    <- parameters[2]
      SlopeB2    <- parameters[4]
      cB2 = breakpoint * SlopeB1 + cB1 - breakpoint * SlopeB2
      B <- (SlopeB1 * L + cB1)*(L <= breakpoint)    +    (SlopeB2 * L + cB2) * (L > breakpoint)
      VAR_NORM = B*T
   }
   if(model=="BM_quadratic"){
       c      <- parameters[1] 
      b      <- parameters[2]
      a      <- parameters[3] 
      B <- c + b*L + a*L^2
      VAR_NORM = B*T
   }
   if(model=="OU_null"){
      B <- parameters[1]
      A <- parameters[2]
      VAR_NORM = (B / (2*A)) * (1-exp(-2*A*T))
   }
   if(model=="OU_linear_beta"){
      cB <- parameters[1]
      SlopeB <- parameters[2]
      A <- parameters[3]
      SlopeA <- 0
      B = L*SlopeB + cB
      VAR_NORM = (B / (2*A)) * (1-exp(-2*A*T))
   }
   if(model=="OU_linear"){
      cB <- parameters[1]
      SlopeB <- parameters[2]
      cA <- parameters[3]
      SlopeA <- parameters[4]
      B = L*SlopeB + cB
      A = L*SlopeA + cA
      VAR_NORM = (B / (2*A)) * (1-exp(-2*A*T))
   }
   if(model=="OU_2rate"){
      cB1 <- parameters[1]
      cB2 <- parameters[3]
      breakpoint <- parameters[2]
      cA1 <- parameters[4]
      cA2 <- parameters[5]
      B <- (cB1)*(L <= breakpoint)    +    (cB2) * (L > breakpoint)
      A <- (cA1)*(L <= breakpoint)    +    (cA2) * (L > breakpoint)
      VAR_NORM = (B / (2*A)) * (1-exp(-2*A*T))
   }
   if(model=="OU_linear_breakpoint"){
      cB1        <- parameters[1]     
      breakpoint <- parameters[3] 
      SlopeB1    <- parameters[2]
      SlopeB2    <- parameters[4]
      cA1        <- parameters[5]  
      SlopeA1    <- parameters[6]
      SlopeA2    <- parameters[7]
      cB2 = breakpoint * SlopeB1 + cB1 - breakpoint * SlopeB2
      B <- (SlopeB1 * L + cB1)*(L <= breakpoint)    +    (SlopeB2 * L + cB2) * (L > breakpoint)
      cA2 = breakpoint * SlopeA1 + cA1 - breakpoint * SlopeA2
      A <- (SlopeA1 * L + cA1)*(L <= breakpoint)    +    (SlopeA2 * L + cA2) * (L > breakpoint)
      VAR_NORM = (B / (2*A)) * (1-exp(-2*A*T))
   }
   SD_NORM = VAR_NORM^0.5
   dd <- rnorm(n=length(T)*MULT, mean = 0, sd = SD_NORM)
   ee <- abs(dd) #These are the simulated absolute euclidean distances under a half normal distribution
   results <- matrix(NA, length(T)*MULT, 3)
   colnames(results) <- c("L", "T", "E")
   results[,1] <- rep.int(L, times=MULT)
   results[,2] <- rep.int(T, times=MULT)
   results[,3] <- ee
   return(results)
}


expectation.time <- function(Beta, Alpha="NULL", time.span=c(0, 10), values=TRUE, plot=TRUE, quantile=FALSE){
   if(length(time.span)==1){T <- time.span}
   if(length(time.span) >2){T <- time.span}
   if(length(time.span)==2){
        N <- time.span[2] *1000
        T <- (0:N)*0.001
   }
   if(Alpha == "NULL"){
        V <- Beta*T 
        E <- ((2*V)/pi)^0.5
   }
   if(Alpha != "NULL"){
        V <- (Beta / (2*Alpha)) * (1-exp(-2*Alpha*T))
        E <- ((2*V)/pi)^0.5
   }
   if(quantile == TRUE){
        QUANTILE_95 <- qnorm(p=0.975, mean = 0, sd = V^0.5)
        QUANTILE_90 <- qnorm(p=0.95,  mean = 0, sd = V^0.5)
        QUANTILE_80 <- qnorm(p=0.90,  mean = 0, sd = V^0.5)
        QUANTILE_70 <- qnorm(p=0.85,  mean = 0, sd = V^0.5)
        QUANTILE_60 <- qnorm(p=0.80, mean = 0, sd = V^0.5)
        QUANTILE_50 <- qnorm(p=0.75, mean = 0, sd = V^0.5)
        QUANTILE_40 <- qnorm(p=0.70, mean = 0, sd = V^0.5)
        QUANTILE_30 <- qnorm(p=0.65, mean = 0, sd = V^0.5)
        QUANTILE_20 <- qnorm(p=0.60, mean = 0, sd = V^0.5)
        QUANTILE_10 <- qnorm(p=0.55, mean = 0, sd = V^0.5)
   }
   if(plot == TRUE){
        if(quantile == TRUE){
           plot(QUANTILE_95 ~ T, xlab="Genetic distance of sister pair", ylab = "Euclidean distance", type="l", lty = 2)
           lines(QUANTILE_90 ~ T, lty = 2)
           lines(QUANTILE_80 ~ T, lty = 2)
           lines(QUANTILE_70 ~ T, lty = 2)
           lines(QUANTILE_60 ~ T, lty = 2)
           lines(QUANTILE_50 ~ T, lty = 2)
           lines(QUANTILE_40 ~ T, lty = 2)
           lines(QUANTILE_30 ~ T, lty = 2)
           lines(QUANTILE_20 ~ T, lty = 2)
           lines(QUANTILE_10 ~ T, lty = 2)
           lines(E ~ T)
        }
        if(quantile == FALSE){plot(E ~ T, xlab="Genetic distance of sister pair", ylab = "Euclidean distance", type="l")}
   }
   if(values == TRUE){ 
        if(quantile == FALSE){
            RESULTS <- matrix(NA,length(T),2)
            colnames(RESULTS) <- c("T","Expectation")
            RESULTS[,1] <- T
            RESULTS[,2] <- E
        }
        if(quantile == TRUE){
            RESULTS <- matrix(NA,length(T),12)
            colnames(RESULTS) <- c("T","Expectation", "q10", "q20", "q30", "q40", "q50", "q60", "q70", "q80", "q90", "q95") 
            RESULTS[,1] <- T
            RESULTS[,2] <- E
            RESULTS[,3] <- QUANTILE_10
            RESULTS[,4] <- QUANTILE_20
            RESULTS[,5] <- QUANTILE_30
            RESULTS[,6] <- QUANTILE_40
            RESULTS[,7] <- QUANTILE_50
            RESULTS[,8] <- QUANTILE_60
            RESULTS[,9] <- QUANTILE_70
            RESULTS[,10] <- QUANTILE_80
            RESULTS[,11] <- QUANTILE_90
            RESULTS[,12] <- QUANTILE_95
        }
        return(RESULTS)
   }
}

expectation.gradient <- function(gradient.span = c(0, 10), model = c("BM_null", "BM_linear", "BM_2rate", "BM_linear_breakpoint", "BM_quadratic", "OU_null", "OU_linear_beta", "OU_linear", "OU_2rate", "OU_linear_breakpoint"), parameters, time=c(3), values=TRUE, plot=TRUE, quantile=FALSE){
   if(length(gradient.span) >2){L <- gradient.span}
   if(length(gradient.span)==2){
        START <- gradient.span[1] *1000
        END <- gradient.span[2] *1000
        L <- (START:END)*0.001
   }
   T = time
   if(model=="BM_null"){
      B <- parameters[1]
      V = B*T
      E <- ((2*V)/pi)^0.5
   }
   if(model=="BM_linear"){
      cB <- parameters[1]
      SlopeB <- parameters[2]
      B = L*SlopeB + cB
      V = B*T
      E <- ((2*V)/pi)^0.5
   }
    if(model=="BM_2rate"){
      cB1 <- parameters[1]
      cB2 <- parameters[2]
      breakpoint <- parameters[3]
      B <- (cB1)*(L <= breakpoint)    +    (cB2) * (L > breakpoint)
      V = B*T
      E <- ((2*V)/pi)^0.5
   }
   if(model=="BM_linear_breakpoint"){
      cB1        <- parameters[1]     
      breakpoint <- parameters[3] 
      SlopeB1    <- parameters[2]
      SlopeB2    <- parameters[4]
      cB2 = breakpoint * SlopeB1 + cB1 - breakpoint * SlopeB2
      B <- (SlopeB1 * L + cB1)*(L <= breakpoint)    +    (SlopeB2 * L + cB2) * (L > breakpoint)
      V = B*T
      E <- ((2*V)/pi)^0.5
   }
   if(model=="BM_quadratic"){
       c      <- parameters[1] 
      b      <- parameters[2]
      a      <- parameters[3] 
      B <- c + b*L + a*L^2
      V = B*T
      E <- ((2*V)/pi)^0.5
   }
   if(model=="OU_null"){
      B <- parameters[1]
      A <- parameters[2]
      V = (B / (2*A)) * (1-exp(-2*A*T))
      E <- ((2*V)/pi)^0.5
   }
   if(model=="OU_linear_beta"){
      cB <- parameters[1]
      SlopeB <- parameters[2]
      A <- parameters[3]
      SlopeA <- 0
      B = L*SlopeB + cB
      V = (B / (2*A)) * (1-exp(-2*A*T))
      E <- ((2*V)/pi)^0.5
   }
   if(model=="OU_linear"){
      cB <- parameters[1]
      SlopeB <- parameters[2]
      cA <- parameters[3]
      SlopeA <- parameters[4]
      B = L*SlopeB + cB
      A = L*SlopeA + cA
      V = (B / (2*A)) * (1-exp(-2*A*T))
      E <- ((2*V)/pi)^0.5
   }
   if(model=="OU_2rate"){
      cB1 <- parameters[1]
      cB2 <- parameters[3]
      breakpoint <- parameters[2]
      cA1 <- parameters[4]
      cA2 <- parameters[5]
      B <- (cB1)*(L <= breakpoint)    +    (cB2) * (L > breakpoint)
      A <- (cA1)*(L <= breakpoint)    +    (cA2) * (L > breakpoint)
      V = (B / (2*A)) * (1-exp(-2*A*T))
      E <- ((2*V)/pi)^0.5
   }
   if(model=="OU_linear_breakpoint"){
      cB1        <- parameters[1]     
      breakpoint <- parameters[3] 
      SlopeB1    <- parameters[2]
      SlopeB2    <- parameters[4]
      cA1        <- parameters[5]  
      SlopeA1    <- parameters[6]
      SlopeA2    <- parameters[7]
      cB2 = breakpoint * SlopeB1 + cB1 - breakpoint * SlopeB2
      B <- (SlopeB1 * L + cB1)*(L <= breakpoint)    +    (SlopeB2 * L + cB2) * (L > breakpoint)
      cA2 = breakpoint * SlopeA1 + cA1 - breakpoint * SlopeA2
      A <- (SlopeA1 * L + cA1)*(L <= breakpoint)    +    (SlopeA2 * L + cA2) * (L > breakpoint)
      V = (B / (2*A)) * (1-exp(-2*A*T))
      E <- ((2*V)/pi)^0.5
   }
   if(quantile == TRUE){
        QUANTILE_99 <- qnorm(p=0.995, mean = 0, sd = V^0.5)
        QUANTILE_95 <- qnorm(p=0.975, mean = 0, sd = V^0.5)
        QUANTILE_90 <- qnorm(p=0.95,  mean = 0, sd = V^0.5)
        QUANTILE_80 <- qnorm(p=0.90,  mean = 0, sd = V^0.5)
        QUANTILE_70 <- qnorm(p=0.85,  mean = 0, sd = V^0.5)
        QUANTILE_60 <- qnorm(p=0.80, mean = 0, sd = V^0.5)
        QUANTILE_50 <- qnorm(p=0.75, mean = 0, sd = V^0.5)
        QUANTILE_40 <- qnorm(p=0.70, mean = 0, sd = V^0.5)
        QUANTILE_30 <- qnorm(p=0.65, mean = 0, sd = V^0.5)
        QUANTILE_20 <- qnorm(p=0.60, mean = 0, sd = V^0.5)
        QUANTILE_10 <- qnorm(p=0.55, mean = 0, sd = V^0.5)
   }
   if(plot == TRUE){
        if(quantile == TRUE){
           X <- c(min(L), max(L))
           Y <- c(min(QUANTILE_10), max(QUANTILE_99))
           plot(Y ~ X, xlab="Gradient", ylab = "Euclidean distance", col="white", lty = 2)
           lines(QUANTILE_99 ~ L, lty = 2)
           lines(QUANTILE_95 ~ L, lty = 2)
           lines(QUANTILE_90 ~ L, lty = 2)
           lines(QUANTILE_80 ~ L, lty = 2)
           lines(QUANTILE_70 ~ L, lty = 2)
           lines(QUANTILE_60 ~ L, lty = 2)
           lines(QUANTILE_50 ~ L, lty = 2)
           lines(QUANTILE_40 ~ L, lty = 2)
           lines(QUANTILE_30 ~ L, lty = 2)
           lines(QUANTILE_20 ~ L, lty = 2)
           lines(QUANTILE_10 ~ L, lty = 2)
           lines(E ~ L)
        }
        if(quantile == FALSE){plot(E ~ L, xlab="Gradient", ylab = "Euclidean distance", type="l")}
   }
   if(values == TRUE){ 
        if(quantile == FALSE){
            RESULTS <- matrix(NA,length(L), 2)
            colnames(RESULTS) <- c("L","Expectation")
            RESULTS[,1] <- L
            RESULTS[,2] <- E
        }
        if(quantile == TRUE){
            RESULTS <- matrix(NA,length(L),13)
            colnames(RESULTS) <- c("L","Expectation", "q10", "q20", "q30", "q40", "q50", "q60", "q70", "q80", "q90", "q95", "q99") 
            RESULTS[,1] <- L
            RESULTS[,2] <- E
            RESULTS[,3] <- QUANTILE_10
            RESULTS[,4] <- QUANTILE_20
            RESULTS[,5] <- QUANTILE_30
            RESULTS[,6] <- QUANTILE_40
            RESULTS[,7] <- QUANTILE_50
            RESULTS[,8] <- QUANTILE_60
            RESULTS[,9] <- QUANTILE_70
            RESULTS[,10] <- QUANTILE_80
            RESULTS[,11] <- QUANTILE_90
            RESULTS[,12] <- QUANTILE_95
            RESULTS[,13] <- QUANTILE_99
        }
        return(RESULTS)
   }
}

bootstrap.test <- function(E, T, L, model, parameters, breakpoint = "NULL", N = c(1000), method = "FAST", starting=list("NULL")){
   BOOTSTRAP.OUTPUT <- matrix(data = NA, nrow = N, ncol = 13)
   BOOTSTRAP.OUTPUT_CV <- matrix(data = NA, nrow = length(E), ncol = 13)
   SUMMARY.OUTPUT <- matrix(data = NA, nrow = 8, ncol = 13)
   rownames(SUMMARY.OUTPUT) <- c("mean","median", "percentile_low_95CI", "percentile_high_95CI", "BCa_low_95CI","BCa_high_95CI", "boot_SE", "boot_var") 
   par_length <- length(parameters)
   pb <- txtProgressBar(min = 0, max = N, style = 3)
   for(i in 1:N){
      RANDOM_NUMEBRS <- sample(x=c(1:length(L)), size=length(L), replace = TRUE, prob = NULL)
      L_boot = L[RANDOM_NUMEBRS]
      T_boot = T[RANDOM_NUMEBRS] 
      E_boot = E[RANDOM_NUMEBRS]
      
         if(method == "FAST"){
            RESULT <- nlm(f = sisterContinuous, p = parameters, breakpoint=breakpoint, model=model, E=E_boot, T=T_boot, L=L_boot, iterlim=50000)
            BOOTSTRAP.OUTPUT[i,c(1:par_length)] <- as.numeric(RESULT$estimate[c(1:par_length)])
         }
         if(method == "SLOW"){
            RESULT <- model.test.sisters(E=E_boot, T=T_boot, L=L_boot, models=model, starting=starting)
            BOOTSTRAP.OUTPUT[i,c(1:13)] <- as.numeric(RESULT[1,c(6:18)])
         }

      Sys.sleep(0.1)
      setTxtProgressBar(pb, i)
   }
   close(pb)
   if(method == "FAST"){
      for (i in 1:length(E)) {
           RESULT2 <- nlm(f = sisterContinuous, p = parameters, breakpoint=breakpoint, model=model, E=E[-i], T=T[-i], L=L[-i], iterlim=50000)
           BOOTSTRAP.OUTPUT_CV[i,c(1:par_length)] <- as.numeric(RESULT2$estimate[c(1:par_length)])
      }
   }
   alpha <- c(0.025, 0.975)
   for(d in 1:ncol(BOOTSTRAP.OUTPUT)){
      boot_mean <- mean(BOOTSTRAP.OUTPUT[,d])
      boot_median <- median(BOOTSTRAP.OUTPUT[,d])
      QUANTILES <- quantile(x = BOOTSTRAP.OUTPUT[,d], probs = seq(0,1,0.025), na.rm=TRUE)
      percentile_CI95_low <- QUANTILES[2]
      percentile_CI95_high <- QUANTILES[40]
      boot_SE <- sqrt(1/(N-1) * sum((BOOTSTRAP.OUTPUT[,d] - 1/N * sum(BOOTSTRAP.OUTPUT[,d]))^2) )
      boot_var <- var(BOOTSTRAP.OUTPUT[,d])
      SUMMARY.OUTPUT[1,d] <- boot_mean
      SUMMARY.OUTPUT[2,d] <- boot_median
      SUMMARY.OUTPUT[3,d] <- percentile_CI95_low
      SUMMARY.OUTPUT[4,d] <- percentile_CI95_high
      SUMMARY.OUTPUT[7,d] <- boot_SE
      SUMMARY.OUTPUT[8,d] <- boot_var
      if(method == "FAST"){
         z0 <- qnorm(sum(BOOTSTRAP.OUTPUT[,d] < parameters[d])/N) 
         u <- BOOTSTRAP.OUTPUT_CV[,d]
         uu <- mean(u) - u
         ACC <- sum(uu^3)/(6 * (sum(uu^2))^1.5)
         zalpha <- qnorm(alpha)
         tt <- pnorm(z0 + (z0 + zalpha)/(1 - ACC * (z0 + zalpha)))
         TRUNC <- trunc(tt * N)
         CI <- sort(BOOTSTRAP.OUTPUT[,d])[TRUNC]
         BCa_CI95_low <- CI[1]
         BCa_CI95_high <- CI[2]
         SUMMARY.OUTPUT[5,d] <- BCa_CI95_low
         SUMMARY.OUTPUT[6,d] <- BCa_CI95_high
      }
   }
   if(method == "SLOW"){
      #SUMMARY.OUTPUT <- SUMMARY.OUTPUT[c(1:4, 7, 8), ]
      #colnames(SUMMARY.OUTPUT) <- c("b1","b1_slope","breakpoint","b2","b2_slope","quadratic_term","a1","a1_slope","a2","a2_slope","Quadratic_c","Quadratic_b","Quadratic_a")
   }
   if(method == "FAST" & par_length < 13){
      SUMMARY.OUTPUT <- SUMMARY.OUTPUT[,c(1:par_length)]
      BOOTSTRAP.OUTPUT <- BOOTSTRAP.OUTPUT[,c(1:par_length)]
   }
   return(list(summary = SUMMARY.OUTPUT, bootstraps = BOOTSTRAP.OUTPUT))
}