% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scenario.R
\name{create_scenario}
\alias{create_scenario}
\title{Create Stressed Scenarios}
\usage{
create_scenario(model, subsamples, alpha = 0.95, atcsr = FALSE)
}
\arguments{
\item{model}{An object of class \code{mldfm}, containing the factor estimates.}

\item{subsamples}{A list of \code{mldfm} objects returned from \code{mldfm_subsampling}.}

\item{alpha}{Numeric. Confidence level (level of stress) for the hyperellipsoid (e.g., 0.95).}

\item{atcsr}{Logical. If TRUE, uses the Adaptive Threshold Cross-Sectional Robust (AT-CSR) Gamma; otherwise, uses the standard time-varying Gamma.}
}
\value{
A list of matrices representing the hyperellipsoid points for each time observation.
}
\description{
Constructs confidence regions (hyperellipsoids) for the factor space based on a central MLDFM estimate
and a set of subsampled estimates. These regions capture estimation uncertainty and are used to simulate
stresses scenarios.
}
\examples{
\donttest{
data <- matrix(rnorm(100*300), nrow = 100, ncol = 300)
block_ind <- c(150, 300)  # Defines 2 blocks
global = 1
local <- c(1, 1)   
mldfm_result <- mldfm(data, blocks = 2, block_ind = block_ind, 
global = global, local = local)
mldfm_subsampling_result <- mldfm_subsampling(data, blocks = 2, 
block_ind = block_ind, global = global, 
local = local, n_samples = 100, sample_size = 0.9)
scenario <- create_scenario(mldfm_result, mldfm_subsampling_result, 
alpha = 0.95)
}

}
