% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{glm.loglik.g}
\alias{glm.loglik.g}
\title{Log likelihood function for glm regression with Zellner's g-prior and BIC-like approximations}
\usage{
glm.loglik.g(
  y,
  x,
  model,
  complex,
  mlpost_params = list(r = NULL, family = "binomial", g = NULL)
)
}
\arguments{
\item{y}{A vector containing the dependent variable}

\item{x}{The matrix containing the precalculated features}

\item{model}{A logical vector indicating which features are included in the model}

\item{complex}{A list of complexity measures for the features}

\item{mlpost_params}{A list of parameters for the log likelihood, including:
\itemize{
\item \code{r} - scalar tuning parameter for the prior (default is 1 / number of rows of \code{x})
\item \code{family} - GLM family as string ("binomial", "poisson", "Gamma"), default is "binomial"
\item \code{g} - scalar specifying the g prior hyperparameter (default max of model size squared and sample size)
}}
}
\value{
A list with the approximate log marginal likelihood (\code{crit}) and the posterior mode of coefficients (\code{coefs})
}
\description{
This function estimates marginal likelihood for generalized linear models using a
BIC-style penalty adjusted to approximate Zellner's g-prior effect.
}
\examples{
glm.loglik.g(as.integer(rnorm(100) > 0), 
cbind(1, matrix(rnorm(100))), c(TRUE, TRUE), list(oc = 1),
 list(r = 1/100, family = "binomial", g = 10))

}
