% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothCarpet.R
\name{smoothCarpet}
\alias{smoothCarpet}
\title{Smooth Carpet (Single Image)}
\usage{
smoothCarpet(img, dfV = 0, dfH = 0)
}
\arguments{
\item{img}{The image to analyze.}

\item{dfV}{The desired equivalent number of degrees of freedom in the vertical axis.}

\item{dfH}{The desired equivalent number of degrees of freedom in the horizontal axis.}
}
\value{
Smooth Carpet   A smooth image.
}
\description{
Generates a smooth carpet.
}
\details{
The smoothCarpet function makes use of the smooth.spline method to smooth the vertical and horizontal axes of an image.
The magnitude of the smoothing depends on the degrees of freedom set for and vertical ('dfV') and horizontal ('dfH') axes of the image.
}
\examples{
\donttest{
### Load the FCSlib package

library(FCSlib)

### As an example, we will use a data set that corresponds to a population of Venus dimers
# diffusing in HEK-293 cells. Use the readFileTiff() function to extract the information
# from the '.tiff' files.

v2 <- data.matrix(V2)
nbv2 <- nbline(img = v2, S=3.5, sigma0 = 1,offset = 0, wSigma = 100);
sC <- smoothCarpet(img = nbv2$number, dfV = 5, dfH = 5)
}
}
\seealso{
\code{\link{pcomb}, \link{smooth.spline}}
}
\author{
Raul Pinto Camara.
}
