% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power.oneway}
\alias{power.oneway}
\title{Compute power of one-way ANOVA}
\usage{
power.oneway(n, alpha, theta, k = 2)
}
\arguments{
\item{n}{per-group sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{theta}{sum of ((group mean - overall mean)/stdev)^2 across all groups for each hypothesis test(vector)}

\item{k}{the number of groups to be compared, default k=2}
}
\value{
Vector of power estimates for test of equal means
}
\description{
Compute power of one-way ANOVA; Uses classical power formula for ANOVA; Assumes equal variance and sample size
}
\details{
For many applications, the null effect is zero for the parameter theta described above
}
\examples{
theta=rep(c(2,0),c(100,900));
res = power.oneway(n = 50, alpha = 0.05, theta = theta, k = 2)
}
