% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSystem.R
\name{PlotSystem}
\alias{PlotSystem}
\title{PlotSystem}
\usage{
PlotSystem(meshP, meshT, PlotVal, a, b, c, d, e, f, g, h, i, j,
                  Oc, ac, bc, cc, dc, ec, fc, gc, hc, ic, jc)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{PlotVal}{Value to be plotted, either stress or strain, return from function LocalStress function.}

\item{a}{Threshold 1}

\item{b}{Threshold 2}

\item{c}{Threshold 3}

\item{d}{Threshold 4}

\item{e}{Threshold 5}

\item{f}{Threshold 6}

\item{g}{Threshold 7}

\item{h}{Threshold 8}

\item{i}{Threshold 9}

\item{j}{Threshold 10}

\item{Oc}{Color for all zero values}

\item{ac}{Color 1}

\item{bc}{Color 2}

\item{cc}{Color 3}

\item{dc}{Color 4}

\item{ec}{Color 5}

\item{fc}{Color 6}

\item{gc}{Color 7}

\item{hc}{Color 8}

\item{ic}{Color 9}

\item{jc}{Color 10}
}
\value{
Plot of colored polygon with mesh colored based on the plot value
}
\description{
Generates heat map for given stress or strain on the geometry. Threshold values for the color must be assigned.
}
\examples{
\donttest{
data(triMesh)
data(fea_result)

meshP = triMesh$MeshPts$p
meshT = triMesh$MeshPts$T
PlotVal = abs(fea_result$Stress[,1])
Oc = "slateblue"; ac = "steelblue2"; bc = "cyan2"; cc = "palegreen2";
dc = "darkolivegreen1"; ec = "lemonchiffon"; fc = "lightgoldenrod1"; gc = "gold";
hc= "lightsalmon"; ic= "tomato"; jc= "firebrick3"
a = 1e5;  b = 5e5;  c = 1e6;  d = 5e6;  e = 1e7;  f = 5e7;  g = 1e8;  h = 5e8; i = 1e9; j =5e9

PlotSystem(meshP, meshT, PlotVal, a, b, c, d, e, f, g, h, i, j,
           Oc, ac, bc, cc, dc, ec, fc, gc, hc, ic, jc)
}

}
