% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datPBpnt2pct.R
\name{datPBpnt2pct}
\alias{datPBpnt2pct}
\title{Data - Transpose point data to plot-level percent by domain.}
\usage{
datPBpnt2pct(pnt, uniqueid, tvar, othervars = NULL)
}
\arguments{
\item{pnt}{DF/DT or comma-delimited file (*.csv). Point-level table with one
record per point. If NULL, aggregated point counts must be in pntcnt.}

\item{uniqueid}{String. Name of unique identifier of plot in pnt.}

\item{tvar}{String. Name of variable to transpose.}

\item{othervars}{String vector. Name(s) of plot-level variables to merge
with transposed data.}
}
\value{
\item{pltdom.pct}{ Data frame with transposed data. }
}
\description{
Calculates percent point by plot and domain and transpose to plot level.
}
\examples{
# Load necessary data from FIESTA
## Point data
icepntfn <- system.file("extdata",
                        "PB_data/icepnt_utco1135.csv",
                         package = "FIESTA")
icepnt <- read.csv(icepntfn)

# Convert to percent
percent <- datPBpnt2pct(pnt = icepnt,
                        uniqueid = "plot_id",
                        tvar = "cover_1")
head(percent)
}
\author{
Tracey S. Frescino
}
\keyword{data}
