## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- include=FALSE-----------------------------------------------------------
devtools::load_all()

## ----setup,eval=FALSE---------------------------------------------------------
#  library(FLAME)

## -----------------------------------------------------------------------------
set.seed(45)
n <- 100
p <- 5
data <- gen_data(n, p) # Data we would like to match
holdout <- gen_data(n, p) # Data we will train on, to compute PE 

## -----------------------------------------------------------------------------
all(sapply(1:p, function(col) is.factor(data[[col]])))

## -----------------------------------------------------------------------------
names(data)

## -----------------------------------------------------------------------------
FLAME_out <- FLAME(data = data, holdout = holdout)

## -----------------------------------------------------------------------------
names(FLAME_out)

## -----------------------------------------------------------------------------
matched_data <- dplyr::filter(FLAME_out$data, matched)

## -----------------------------------------------------------------------------
head(FLAME_out$data)

## -----------------------------------------------------------------------------
FLAME_out$MGs[[1]]
length(FLAME_out$MGs)

## -----------------------------------------------------------------------------
FLAME_out$CATE[1]

## -----------------------------------------------------------------------------
FLAME_out$matched_on[[1]]

## -----------------------------------------------------------------------------
FLAME_out$matched_on[[17]]

## -----------------------------------------------------------------------------
FLAME_out$matching_covs

## -----------------------------------------------------------------------------
FLAME_out$dropped

## -----------------------------------------------------------------------------
MG(c(1, 2), FLAME_out)

## -----------------------------------------------------------------------------
MG(c(1, 2), FLAME_out, index_only = TRUE)

## -----------------------------------------------------------------------------
CATE(c(1, 2), FLAME_out)

## -----------------------------------------------------------------------------
ATE(FLAME_out = FLAME_out)
ATT(FLAME_out = FLAME_out)

## ---- eval=F------------------------------------------------------------------
#  library(dbarts)
#  my_fit <- dbarts::bart
#  my_fit_params <- list(ntree = 100, verbose = FALSE, keeptrees = TRUE)
#  my_predict <- function(bart_fit, new_data) {
#    return(colMeans(predict(bart_fit, new_data)))
#  }
#  FLAME_out <-
#    FLAME(data = data, holdout = holdout,
#          user_PE_fit = my_fit, user_PE_fit_params = my_fit_params,
#          user_PE_predict = my_predict)

