#' @title Subampled lengths of Bluntnose Minnows from Inch Lake, WI.
#' 
#' @description Total lengths for a subsample from 144 Bluntnose Minnows (\emph{Pimephales notatus}) from Inch Lake, WI in May, 2007.
#' 
#' @name BluntnoseIL1
#' 
#' @docType data
#' 
#' @format A data frame of 25 observations on the following 3 variables:
#'   \describe{
#'     \item{netID}{a netID factor (all 41)}
#'     \item{species}{species name (all Bluntnose)} 
#'     \item{tl}{total length (inches to nearest 0.1)} 
#'   }
#'   
#' @section Topic(s):
#'   \itemize{
#'     \item Length Frequency
#'     \item Length Expansion
#'     \item Size Structure
#'     \item PSD
#'   }
#'   
#' @concept Length Frequency
#' @concept Size Structure
#' @concept PSD
#' @concept Length Expansion
#' 
#' @seealso \code{\link{InchLake1}}, \code{\link{InchLake2}}.
#' 
#' @source Derek H. Ogle, personal collection. \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/BluntnoseIL1.csv}{CSV file}
#' 
#' @keywords datasets
#' 
#' @examples
#' data(BluntnoseIL1)
#' str(BluntnoseIL1)
#' head(BluntnoseIL1)
#' 
NULL
