% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{sa}
\alias{sa}
\title{Simulated Annealing}
\usage{
sa(
  data,
  class,
  featureSetEval,
  start = sample(0:1, ncol(data) - 1, replace = TRUE),
  temperature = 1,
  temperature_min = 0.01,
  reduction = 0.6,
  innerIter = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{start}{\itemize{
\item Binary vector with the set of initial features
}}

\item{temperature}{\itemize{
\item Temperature initial
}}

\item{temperature_min}{\itemize{
\item Temperature to stops in the outer loop
}}

\item{reduction}{\itemize{
\item Temperature reduction in the outer loop
}}

\item{innerIter}{\itemize{
\item Number of iterations of inner loop. By default no inner iterations are established
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration
}}
}
\value{
A list is returned containing for each repetition of the algorithm:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{initialVector}{The vector with which the algorithm started}
\item{initialEnergy}{The evaluation measure of the initial vector}
\item{traceOutter}{Matrix with the results of each iteration. Contains the number of the iteration, the value of the temperature, the subset of features of the iteration, its evaluation measure and whether there has been a movement from the previous iteration to obtain the subset of features in the current iteration.}
\item{traceInner}{List containing as many lists as outer iterations have been performed. In each iteration of these lists the same values are shown as for traceOutter but referring to each internal iteration.}
}
}
\description{
The sa method \insertCite{KirkpatrickGelattVecchi1983}{FSinR} starts with a certain set of features and in each iteration modifies an element of the previous feature vector and decreases the temperature. If the energy of the new feature vector is better than that of the old vector, it is accepted and moved towards it, otherwise it is moved towards the new vector according to an acceptance probability.  The algorithm ends when the minimum temperature has been reached. Additionally, a number of internal iterations can be performed within each iteration of the algorithm. In this case, the same temperature value of the outer iteration is used for the inner iterations
}
\examples{
## Simulated Annealing for iris dataset (filter method)
sa(iris, 'Species', roughsetConsistency, temperature = 5, temperature_min=0.01,
   reduction=0.6, verbose=TRUE)
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
