% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarmTest.R
\name{huber.reg}
\alias{huber.reg}
\title{Tuning-free Huber regression}
\usage{
huber.reg(X, Y, method = c("standard", "adaptive"))
}
\arguments{
\item{X}{An \eqn{n} by \eqn{p} design matrix, where \eqn{p < n}.}

\item{Y}{A continuous response with length \eqn{n}.}

\item{method}{An \strong{optional} character string specifying the method to calibrate the robustification parameter \eqn{\tau}. Two choices are "standard"(default) and "adaptive". See Wang et al.(2020) for details.}
}
\value{
A coefficients estimator with length \eqn{p + 1} will be returned.
}
\description{
The function conducts Huber regression from a data sample, with robustification parameter \eqn{\tau} determined by a tuning-free principle.
}
\examples{
n = 200
d = 10
beta = rep(1, d)
X = matrix(rnorm(n * d), n, d)
err = rnorm(n)
Y = 1 + X \%*\% beta + err
beta.hat = huber.reg(X, Y)
}
\references{
Huber, P. J. (1964). Robust estimation of a location parameter. Ann. Math. Statist., 35, 73–101.

Sun, Q., Zhou, W.-X. and Fan, J. (2020). Adaptive Huber regression. J. Amer. Statist. Assoc., 115, 254-265.

Wang, L., Zheng, C., Zhou, W. and Zhou, W.-X. (2020). A new principle for tuning-free Huber regression. Stat. Sin., to appear.
}
\seealso{
\code{\link{huber.mean}} for tuning-free Huber mean estimation and \code{\link{huber.cov}} for tuning-free Huber-type covariance estimation.
}
