/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.ohdsi.sql.StringUtils;

public class SqlSplit {
    public static String[] splitSql(String sql) {
        int cursor;
        ArrayList<String> parts = new ArrayList<String>();
        List<StringUtils.Token> tokens = StringUtils.tokenizeSql(sql.toLowerCase());
        Stack<String> nestStack = new Stack<String>();
        String lastPop = "";
        int start = 0;
        boolean quote = false;
        boolean bracket = false;
        String quoteText = "";
        for (cursor = start; cursor < tokens.size(); ++cursor) {
            StringUtils.Token token = tokens.get(cursor);
            if (quote) {
                if (!token.text.equals(quoteText)) continue;
                quote = false;
                continue;
            }
            if (bracket) {
                if (!token.text.equals("]")) continue;
                bracket = false;
                continue;
            }
            if (token.text.equals("'") || token.text.equals("\"")) {
                quote = true;
                quoteText = token.text;
                continue;
            }
            if (token.text.equals("[")) {
                bracket = true;
                continue;
            }
            if (token.text.equals("begin") || token.text.equals("case")) {
                nestStack.push(token.text);
                continue;
            }
            if (token.text.equals("end") && (cursor == tokens.size() - 1 || !tokens.get((int)(cursor + 1)).text.equals("if"))) {
                lastPop = (String)nestStack.pop();
                continue;
            }
            if (nestStack.size() != 0 || !token.text.equals(";")) continue;
            if (cursor == 0 || tokens.get((int)(cursor - 1)).text.equals("end") && lastPop.equals("begin")) {
                parts.add(sql.substring(tokens.get((int)start).start, token.end));
            } else {
                parts.add(sql.substring(tokens.get((int)start).start, token.end - 1));
            }
            start = cursor + 1;
        }
        if (start < cursor) {
            parts.add(sql.substring(tokens.get((int)start).start, tokens.get((int)(cursor - 1)).end));
            start = cursor + 1;
        }
        return parts.toArray(new String[parts.size()]);
    }
}

