% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetailedCovariateSettings.R
\name{createDetailedCovariateSettings}
\alias{createDetailedCovariateSettings}
\title{Create detailed covariate settings}
\usage{
createDetailedCovariateSettings(analyses = list())
}
\arguments{
\item{analyses}{A list of \code{analysisDetail} objects as created using
\code{\link{createAnalysisDetails}}.}
}
\value{
An object of type \code{covariateSettings}, to be used in other functions.
}
\description{
Create detailed covariate settings
}
\details{
creates an object specifying in detail how covariates should be constructed from data in the CDM
model. Warning: this function is for advanced users only.
}
\examples{
\donttest{
analysisDetails <- createAnalysisDetails(
  analysisId = 1,
  sqlFileName = "DemographicsGender.sql",
  parameters = list(
    analysisId = 1,
    analysisName = "Gender",
    domainId = "Demographics"
  ),
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)
covSettings <- createDetailedCovariateSettings(analyses = analysisDetails)
}

}
