% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_ID.R
\name{cluster_ID}
\alias{cluster_ID}
\title{cluster_ID}
\usage{
cluster_ID(
  pdb_df,
  max_range = 20,
  secondary_structures = TRUE,
  clusters = NULL,
  modelNames = NULL
)
}
\arguments{
\item{pdb_df}{data frame containing processed PDB file with Fi-score values}

\item{max_range}{number of clusters to consider during model selection; default 20 clusters}

\item{secondary_structures}{include information on secondary structure elements from PDB when plotting, default value is TRUE}

\item{clusters}{number of clusters to test not based on the best BIC output, user also needs to supply modelNames}

\item{modelNames}{can only be supplied when clusters are also specified, this option will model based on the user parameters}
}
\value{
A data frame object that contains a summary of clusters
}
\description{
Function to select an optimal number of clusters and a model to be fitted during the EM phase of clustering for Gaussian Mixture Models. The function provides summaries and helps to visualise clusters based on Fi-score using scatter plotting and dimension reduction plots.
}
\examples{
path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
# basic usage of cluster_ID
pdb_df<-read.table(path_to_processed_PDB)
head(cluster_ID(pdb_df))
}
