% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSFWER.R
\name{bisection.FWER}
\alias{bisection.FWER}
\title{Bisection algorithm (FWER)}
\usage{
bisection.FWER(f, a=0, b=1, p, beta, j, n = 1000, tol)
}
\arguments{
\item{f}{the objective function which to be optimized for the solution.}

\item{a}{mininum of the interval which cantains the solution from bisection algorithm.}

\item{b}{maxinum of the interval which cantains the solution from bisection algorithm.}

\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{beta}{pre-specified constant satisfying \eqn{0 \le \beta <1}, only for \code{method="accept"}.}

\item{j}{index of the hypothesis.}

\item{n}{number of sections that the interval which from bisection algorithm.}

\item{tol}{desired accuracy.}
}
\value{
a solution of the objective function which between the interwal from \code{a} to \code{b}.
}
\description{
Bisection algorithm to find the solution for the adjusted p-value for FWER controlling g-FSMTPs.
}
\author{
Yalin Zhu
}
\seealso{
\code{\link{bisection.FDR}}
}

