% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rFBB}
\alias{rFBB}
\title{Random generator from the flexible beta-binomial distribution}
\usage{
rFBB(n, size = NULL, mu, theta = NULL, phi = NULL, p, w)
}
\arguments{
\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{size}{the total number of trials.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{theta}{the overdispersion parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter, an alternative way to specify the overdispersion parameter \code{theta}. It must be a real positive value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{w}{the normalized distance among clusters. It must lie in (0, 1).}
}
\value{
A vector of length  \code{n}.
}
\description{
The function generates random values from the flexible beta-binomial distribution.
}
\examples{
rFBB(n = 100, size = 40, mu = .5, theta = .4, p = .3, w = .6)
rFBB(n = 100, size = 40, mu = .5, phi = 1.5, p = .3, w = .6)

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005
}
}
