% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowRegEnvCosts.R
\name{impact_reg_multi_plot}
\alias{impact_reg_multi_plot}
\title{Plots the daily environmental impact of flow regulation for multiple years}
\usage{
impact_reg_multi_plot(Row, Column, sp_years, River_name, First_year, Last_year,
  Year_impact)
}
\arguments{
\item{Row}{Number of rows in the figure to compare multiple years in separated graphs (e.g.:  Row = 2)}

\item{Column}{Number of columns in the figure to compare multiple years in separated graphs (e.g.:  Column = 5)}

\item{sp_years}{A vector specifying the years to be plotted (e.g.:  sp_years = c(1965,1966,1967,1968,1969,2006,2007,2008,2009,2010))}

\item{River_name}{Name of the river written as character (e.g.: River_name = "Esla")}

\item{First_year}{First year to consider in the analysis starting on October 1st (e.g.: First_year = 1964)}

\item{Last_year}{First year to consider in the analysis finishing on September 30th (e.g.: Last_year = 2011)}

\item{Year_impact}{Year when the human impact started (the construction of a dam) (e.g.: Year_impact = 1988)}
}
\value{
Plots the daily environmental impact of flow regulation for multiple years.
}
\description{
Plots the daily environmental impact of flow regulation for multiple years
}
\examples{
data(flowdata)
impact_reg_multi_plot(Row = 1,Column = 2,
sp_years = c(1965,2010),
River_name = "Esla", First_year=1964, Last_year=2011,
Year_impact=1988)
}
